/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Data;

class DataListener
extends AbstractIqRequestHandler {
    private final InBandBytestreamManager manager;

    DataListener(InBandBytestreamManager inBandBytestreamManager) {
        super("data", "http://jabber.org/protocol/ibb", IQ.Type.set, IQRequestHandler.Mode.async);
        this.manager = inBandBytestreamManager;
    }

    public IQ handleIQRequest(IQ iQ) {
        Data data = (Data)iQ;
        InBandBytestreamSession inBandBytestreamSession = this.manager.getSessions().get(data.getDataPacketExtension().getSessionID());
        try {
            if (inBandBytestreamSession == null) {
                this.manager.replyItemNotFoundPacket(data);
            } else {
                inBandBytestreamSession.processIQPacket(data);
            }
        }
        catch (InterruptedException | SmackException.NotConnectedException | SmackException.NotLoggedInException throwable) {
            return null;
        }
        return null;
    }
}

