/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.i;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.bytestreams.BytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Close;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Data;
import org.jivesoftware.smackx.bytestreams.ibb.packet.DataPacketExtension;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;

public class InBandBytestreamSession
implements BytestreamSession {
    private static final Logger LOGGER = Logger.getLogger(InBandBytestreamSession.class.getName());
    static final String UNEXPECTED_IBB_SEQUENCE = "Unexpected IBB sequence";
    private final XMPPConnection connection;
    private final Open byteStreamRequest;
    private IBBInputStream inputStream;
    private IBBOutputStream outputStream;
    private i remoteJID;
    private boolean closeBothStreamsEnabled = false;
    private boolean isClosed = false;

    protected InBandBytestreamSession(XMPPConnection xMPPConnection, Open open, i i2) {
        this.connection = xMPPConnection;
        this.byteStreamRequest = open;
        this.remoteJID = i2;
        switch (open.getStanza()) {
            case IQ: {
                this.inputStream = new IQIBBInputStream();
                this.outputStream = new IQIBBOutputStream();
                break;
            }
            case MESSAGE: {
                this.inputStream = new MessageIBBInputStream();
                this.outputStream = new MessageIBBOutputStream();
            }
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public int getReadTimeout() {
        return this.inputStream.readTimeout;
    }

    @Override
    public void setReadTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Timeout must be >= 0");
        }
        this.inputStream.readTimeout = n;
    }

    public boolean isCloseBothStreamsEnabled() {
        return this.closeBothStreamsEnabled;
    }

    public void setCloseBothStreamsEnabled(boolean bl) {
        this.closeBothStreamsEnabled = bl;
    }

    @Override
    public void close() {
        this.closeByLocal(true);
        this.closeByLocal(false);
    }

    protected void closeByPeer(Close close) {
        this.inputStream.closeInternal();
        this.inputStream.cleanup();
        this.outputStream.closeInternal(false);
        IQ iQ = IQ.createResultIQ((IQ)close);
        this.connection.sendStanza((Stanza)iQ);
    }

    protected synchronized void closeByLocal(boolean bl) {
        if (this.isClosed) {
            return;
        }
        if (this.closeBothStreamsEnabled) {
            this.inputStream.closeInternal();
            this.outputStream.closeInternal(true);
        } else if (bl) {
            this.inputStream.closeInternal();
        } else {
            this.outputStream.closeInternal(true);
        }
        if (this.inputStream.isClosed && this.outputStream.isClosed) {
            this.isClosed = true;
            Close close = new Close(this.byteStreamRequest.getSessionID());
            close.setTo(this.remoteJID);
            try {
                this.connection.createStanzaCollectorAndSend((IQ)close).nextResultOrThrow();
            }
            catch (Exception exception) {
                IOException iOException = new IOException();
                iOException.initCause(exception);
                throw iOException;
            }
            this.inputStream.cleanup();
            InBandBytestreamManager.getByteStreamManager(this.connection).getSessions().remove(this.byteStreamRequest.getSessionID());
        }
    }

    public void processIQPacket(Data data) {
        this.inputStream.dataPacketListener.processStanza((Stanza)data);
    }

    private class MessageIBBOutputStream
    extends IBBOutputStream {
        private MessageIBBOutputStream() {
        }

        @Override
        protected synchronized void writeToXML(DataPacketExtension dataPacketExtension) {
            Message message = ((MessageBuilder)((MessageBuilder)StanzaBuilder.buildMessage().to(InBandBytestreamSession.this.remoteJID)).addExtension((ExtensionElement)dataPacketExtension)).build();
            InBandBytestreamSession.this.connection.sendStanza((Stanza)message);
        }
    }

    private class IQIBBOutputStream
    extends IBBOutputStream {
        private IQIBBOutputStream() {
        }

        @Override
        protected synchronized void writeToXML(DataPacketExtension dataPacketExtension) {
            block2: {
                Data data = new Data(dataPacketExtension);
                data.setTo(InBandBytestreamSession.this.remoteJID);
                try {
                    InBandBytestreamSession.this.connection.createStanzaCollectorAndSend((IQ)data).nextResultOrThrow();
                }
                catch (Exception exception) {
                    if (this.isClosed) break block2;
                    InBandBytestreamSession.this.close();
                    IOException iOException = new IOException();
                    iOException.initCause(exception);
                    throw iOException;
                }
            }
        }
    }

    private abstract class IBBOutputStream
    extends OutputStream {
        protected final byte[] buffer;
        protected int bufferPointer = 0;
        protected UInt16 seq = UInt16.from((int)0);
        protected boolean isClosed = false;

        private IBBOutputStream() {
            this.buffer = new byte[InBandBytestreamSession.this.byteStreamRequest.getBlockSize()];
        }

        protected abstract void writeToXML(DataPacketExtension var1);

        @Override
        public synchronized void write(int n) {
            if (this.isClosed) {
                throw new IOException("Stream is closed");
            }
            if (this.bufferPointer >= this.buffer.length) {
                this.flushBuffer();
            }
            this.buffer[this.bufferPointer++] = (byte)n;
        }

        @Override
        public synchronized void write(byte[] byArray, int n, int n2) {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            if (this.isClosed) {
                throw new IOException("Stream is closed");
            }
            if (n2 >= this.buffer.length) {
                this.writeOut(byArray, n, this.buffer.length);
                this.write(byArray, n + this.buffer.length, n2 - this.buffer.length);
            } else {
                this.writeOut(byArray, n, n2);
            }
        }

        @Override
        public synchronized void write(byte[] byArray) {
            this.write(byArray, 0, byArray.length);
        }

        private synchronized void writeOut(byte[] byArray, int n, int n2) {
            if (this.isClosed) {
                throw new IOException("Stream is closed");
            }
            int n3 = 0;
            if (n2 > this.buffer.length - this.bufferPointer) {
                n3 = this.buffer.length - this.bufferPointer;
                System.arraycopy(byArray, n, this.buffer, this.bufferPointer, n3);
                this.bufferPointer += n3;
                this.flushBuffer();
            }
            System.arraycopy(byArray, n + n3, this.buffer, this.bufferPointer, n2 - n3);
            this.bufferPointer += n2 - n3;
        }

        @Override
        public synchronized void flush() {
            if (this.isClosed) {
                throw new IOException("Stream is closed");
            }
            this.flushBuffer();
        }

        private synchronized void flushBuffer() {
            if (this.bufferPointer == 0) {
                return;
            }
            String string = Base64.encodeToString((byte[])this.buffer, (int)0, (int)this.bufferPointer);
            DataPacketExtension dataPacketExtension = new DataPacketExtension(InBandBytestreamSession.this.byteStreamRequest.getSessionID(), this.seq, string);
            try {
                this.writeToXML(dataPacketExtension);
            }
            catch (InterruptedException | SmackException.NotConnectedException throwable) {
                IOException iOException = new IOException();
                iOException.initCause(throwable);
                throw iOException;
            }
            this.bufferPointer = 0;
            this.seq = this.seq.incrementedByOne();
        }

        @Override
        public void close() {
            if (this.isClosed) {
                return;
            }
            InBandBytestreamSession.this.closeByLocal(false);
        }

        protected void closeInternal(boolean bl) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            try {
                if (bl) {
                    this.flushBuffer();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class IBBDataPacketFilter
    implements StanzaFilter {
        private IBBDataPacketFilter() {
        }

        public boolean accept(Stanza stanza) {
            DataPacketExtension dataPacketExtension;
            if (!stanza.getFrom().a((CharSequence)InBandBytestreamSession.this.remoteJID)) {
                return false;
            }
            if (stanza instanceof Data) {
                dataPacketExtension = ((Data)stanza).getDataPacketExtension();
            } else {
                dataPacketExtension = (DataPacketExtension)stanza.getExtension(DataPacketExtension.class);
                if (dataPacketExtension == null) {
                    return false;
                }
            }
            return dataPacketExtension.getSessionID().equals(InBandBytestreamSession.this.byteStreamRequest.getSessionID());
        }
    }

    private class MessageIBBInputStream
    extends IBBInputStream {
        private MessageIBBInputStream() {
        }

        @Override
        protected StanzaListener getDataPacketListener() {
            return new StanzaListener(){

                public void processStanza(Stanza stanza) {
                    DataPacketExtension dataPacketExtension = (DataPacketExtension)stanza.getExtension(DataPacketExtension.class);
                    if (dataPacketExtension.getDecodedData() == null) {
                        return;
                    }
                    MessageIBBInputStream.this.dataQueue.offer(dataPacketExtension);
                }
            };
        }

        @Override
        protected StanzaFilter getDataPacketFilter() {
            return new AndFilter(new StanzaFilter[]{new StanzaTypeFilter(Message.class), new IBBDataPacketFilter()});
        }
    }

    private class IQIBBInputStream
    extends IBBInputStream {
        private IQIBBInputStream() {
        }

        @Override
        protected StanzaListener getDataPacketListener() {
            return new StanzaListener(){
                private UInt16 expectedSequence = UInt16.MIN_VALUE;

                public void processStanza(Stanza stanza) {
                    Data data = (Data)stanza;
                    DataPacketExtension dataPacketExtension = data.getDataPacketExtension();
                    UInt16 uInt16 = dataPacketExtension.getSeq();
                    if (!this.expectedSequence.equals((Object)uInt16)) {
                        String string = "Unexpected IBB sequence " + uInt16 + " received, expected " + this.expectedSequence;
                        StanzaError stanzaError = ((StanzaError.Builder)StanzaError.getBuilder().setCondition(StanzaError.Condition.unexpected_request).setDescriptiveEnText(string)).build();
                        ErrorIQ errorIQ = IQ.createErrorResponse((IQ)data, (StanzaError)stanzaError);
                        InBandBytestreamSession.this.connection.sendStanza((Stanza)errorIQ);
                        try {
                            IQIBBInputStream.this.close();
                        }
                        catch (IOException iOException) {
                            LOGGER.log(Level.FINER, "Could not close session, because of IOException. Close reason: " + string);
                        }
                        return;
                    }
                    if (dataPacketExtension.getDecodedData() == null) {
                        ErrorIQ errorIQ = IQ.createErrorResponse((IQ)((IQ)stanza), (StanzaError.Condition)StanzaError.Condition.bad_request);
                        InBandBytestreamSession.this.connection.sendStanza((Stanza)errorIQ);
                        return;
                    }
                    this.expectedSequence = uInt16.incrementedByOne();
                    IQIBBInputStream.this.dataQueue.offer(dataPacketExtension);
                    IQ iQ = IQ.createResultIQ((IQ)((IQ)stanza));
                    InBandBytestreamSession.this.connection.sendStanza((Stanza)iQ);
                }
            };
        }

        @Override
        protected StanzaFilter getDataPacketFilter() {
            return new AndFilter(new StanzaFilter[]{new StanzaTypeFilter(Data.class), new IBBDataPacketFilter()});
        }
    }

    private abstract class IBBInputStream
    extends InputStream {
        private final StanzaListener dataPacketListener;
        protected final BlockingQueue<DataPacketExtension> dataQueue = new LinkedBlockingQueue<DataPacketExtension>();
        private byte[] buffer;
        private int bufferPointer = -1;
        private UInt16 expectedSeq = UInt16.MIN_VALUE;
        private boolean isClosed = false;
        private boolean closeInvoked = false;
        private int readTimeout = 0;

        protected IBBInputStream() {
            this.dataPacketListener = this.getDataPacketListener();
            InBandBytestreamSession.this.connection.addSyncStanzaListener(this.dataPacketListener, this.getDataPacketFilter());
        }

        protected abstract StanzaListener getDataPacketListener();

        protected abstract StanzaFilter getDataPacketFilter();

        @Override
        public synchronized int read() {
            this.checkClosed();
            if (!(this.bufferPointer != -1 && this.bufferPointer < this.buffer.length || this.loadBuffer())) {
                return -1;
            }
            return this.buffer[this.bufferPointer++] & 0xFF;
        }

        @Override
        public synchronized int read(byte[] byArray, int n, int n2) {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            this.checkClosed();
            if (!(this.bufferPointer != -1 && this.bufferPointer < this.buffer.length || this.loadBuffer())) {
                return -1;
            }
            int n3 = this.buffer.length - this.bufferPointer;
            if (n2 > n3) {
                n2 = n3;
            }
            System.arraycopy(this.buffer, this.bufferPointer, byArray, n, n2);
            this.bufferPointer += n2;
            return n2;
        }

        @Override
        public synchronized int read(byte[] byArray) {
            return this.read(byArray, 0, byArray.length);
        }

        private synchronized boolean loadBuffer() {
            DataPacketExtension dataPacketExtension = null;
            try {
                if (this.readTimeout == 0) {
                    while (dataPacketExtension == null) {
                        if (this.isClosed && this.dataQueue.isEmpty()) {
                            return false;
                        }
                        dataPacketExtension = this.dataQueue.poll(1000L, TimeUnit.MILLISECONDS);
                    }
                } else {
                    dataPacketExtension = this.dataQueue.poll(this.readTimeout, TimeUnit.MILLISECONDS);
                    if (dataPacketExtension == null) {
                        throw new SocketTimeoutException();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return false;
            }
            UInt16 uInt16 = dataPacketExtension.getSeq();
            if (!this.expectedSeq.equals((Object)uInt16)) {
                InBandBytestreamSession.this.close();
                String string = "Unexpected IBB sequence " + uInt16 + " received, expected " + this.expectedSeq;
                throw new IOException(string);
            }
            this.expectedSeq = uInt16.incrementedByOne();
            this.buffer = dataPacketExtension.getDecodedData();
            this.bufferPointer = 0;
            return true;
        }

        private void checkClosed() {
            if (this.closeInvoked) {
                this.dataQueue.clear();
                throw new IOException("Stream is closed");
            }
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void close() {
            if (this.closeInvoked) {
                return;
            }
            this.closeInvoked = true;
            InBandBytestreamSession.this.closeByLocal(true);
        }

        private void closeInternal() {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }

        private void cleanup() {
            InBandBytestreamSession.this.connection.removeSyncStanzaListener(this.dataPacketListener);
        }
    }
}

