/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamRequest;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;

final class InitiationListener
extends AbstractIqRequestHandler {
    private static final Logger LOGGER = Logger.getLogger(InitiationListener.class.getName());
    private final Socks5BytestreamManager manager;
    private final ExecutorService initiationListenerExecutor;

    protected InitiationListener(Socks5BytestreamManager socks5BytestreamManager) {
        super("query", "http://jabber.org/protocol/bytestreams", IQ.Type.set, IQRequestHandler.Mode.async);
        this.manager = socks5BytestreamManager;
        this.initiationListenerExecutor = Executors.newCachedThreadPool();
    }

    public IQ handleIQRequest(final IQ iQ) {
        this.initiationListenerExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    InitiationListener.this.processRequest((Stanza)iQ);
                }
                catch (InterruptedException | SmackException.NotConnectedException throwable) {
                    LOGGER.log(Level.WARNING, "process request", throwable);
                }
            }
        });
        return null;
    }

    private void processRequest(Stanza stanza) {
        Bytestream bytestream = (Bytestream)stanza;
        StreamNegotiator.signal(bytestream.getFrom().toString() + '\t' + bytestream.getSessionID(), bytestream);
        if (this.manager.getIgnoredBytestreamRequests().remove(bytestream.getSessionID())) {
            return;
        }
        Socks5BytestreamRequest socks5BytestreamRequest = new Socks5BytestreamRequest(this.manager, bytestream);
        BytestreamListener bytestreamListener = this.manager.getUserListener(bytestream.getFrom());
        if (bytestreamListener != null) {
            bytestreamListener.incomingBytestreamRequest(socks5BytestreamRequest);
        } else if (!this.manager.getAllRequestListeners().isEmpty()) {
            for (BytestreamListener bytestreamListener2 : this.manager.getAllRequestListeners()) {
                bytestreamListener2.incomingBytestreamRequest(socks5BytestreamRequest);
            }
        } else {
            this.manager.replyRejectPacket(bytestream);
        }
    }

    protected void shutdown() {
        this.initiationListenerExecutor.shutdownNow();
    }
}

