/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.forward.provider;

import java.io.IOException;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.delay.packet.DelayInformation;
import org.jivesoftware.smackx.delay.provider.DelayInformationProvider;
import org.jivesoftware.smackx.forward.packet.Forwarded;

public class ForwardedProvider
extends ExtensionElementProvider<Forwarded<?>> {
    public static final ForwardedProvider INSTANCE = new ForwardedProvider();
    private static final Logger LOGGER = Logger.getLogger(ForwardedProvider.class.getName());

    /*
     * Enabled aggressive block sorting
     */
    public Forwarded<?> parse(XmlPullParser xmlPullParser, int n, XmlEnvironment xmlEnvironment) {
        DelayInformation delayInformation = null;
        Message message = null;
        block12: while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String string = xmlPullParser.getName();
                    String string2 = xmlPullParser.getNamespace();
                    switch (string) {
                        case "delay": {
                            if ("urn:xmpp:delay".equals(string2)) {
                                delayInformation = DelayInformationProvider.INSTANCE.parse(xmlPullParser, xmlPullParser.getDepth(), null);
                                break block0;
                            }
                            LOGGER.warning("Namespace '" + string2 + "' does not match expected namespace '" + "urn:xmpp:delay" + "'");
                            break block0;
                        }
                        case "message": {
                            message = PacketParserUtils.parseMessage((XmlPullParser)xmlPullParser);
                            break block0;
                        }
                    }
                    LOGGER.warning("Unsupported forwarded packet type: " + string);
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() == n) break block12;
                }
            }
        }
        if (message == null) {
            throw new IOException("forwarded extension must contain a packet");
        }
        return new Forwarded<Object>(message, delayInformation);
    }

    public static Forwarded<Message> parseForwardedMessage(XmlPullParser xmlPullParser, XmlEnvironment xmlEnvironment) {
        return ForwardedProvider.parseForwardedMessage(xmlPullParser, xmlPullParser.getDepth(), xmlEnvironment);
    }

    public static Forwarded<Message> parseForwardedMessage(XmlPullParser xmlPullParser, int n, XmlEnvironment xmlEnvironment) {
        Forwarded<Message> forwarded = INSTANCE.parse(xmlPullParser, n, xmlEnvironment);
        if (!forwarded.isForwarded(Message.class)) {
            throw new SmackParsingException("Expecting a forwarded message, but got " + forwarded);
        }
        return forwarded;
    }
}

