/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import org.e.a.h;
import org.e.a.i;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleAction;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.jivesoftware.smackx.jingle.element.JingleContentDescription;
import org.jivesoftware.smackx.jingle.element.JingleContentTransport;
import org.jivesoftware.smackx.jingle.element.JingleError;
import org.jivesoftware.smackx.jingle.element.JingleReason;

public class JingleUtil {
    private final XMPPConnection connection;

    public JingleUtil(XMPPConnection xMPPConnection) {
        this.connection = xMPPConnection;
    }

    public Jingle createSessionInitiate(h h2, String string, JingleContent.Creator creator, String string2, JingleContent.Senders senders, JingleContentDescription jingleContentDescription, JingleContentTransport jingleContentTransport) {
        Jingle.Builder builder = Jingle.builder(this.connection);
        builder.setAction(JingleAction.session_initiate).setSessionId(string).setInitiator((h)this.connection.getUser());
        JingleContent.Builder builder2 = JingleContent.getBuilder();
        builder2.setCreator(creator).setName(string2).setSenders(senders).setDescription(jingleContentDescription).setTransport(jingleContentTransport);
        Jingle jingle = builder.addJingleContent(builder2.build()).build();
        jingle.setFrom((i)this.connection.getUser());
        jingle.setTo((i)h2);
        return jingle;
    }

    public Jingle createSessionInitiateFileOffer(h h2, String string, JingleContent.Creator creator, String string2, JingleContentDescription jingleContentDescription, JingleContentTransport jingleContentTransport) {
        return this.createSessionInitiate(h2, string, creator, string2, JingleContent.Senders.initiator, jingleContentDescription, jingleContentTransport);
    }

    public IQ sendSessionInitiateFileOffer(h h2, String string, JingleContent.Creator creator, String string2, JingleContentDescription jingleContentDescription, JingleContentTransport jingleContentTransport) {
        Jingle jingle = this.createSessionInitiateFileOffer(h2, string, creator, string2, jingleContentDescription, jingleContentTransport);
        return (IQ)this.connection.createStanzaCollectorAndSend((IQ)jingle).nextResultOrThrow();
    }

    public IQ sendSessionInitiate(h h2, String string, JingleContent.Creator creator, String string2, JingleContent.Senders senders, JingleContentDescription jingleContentDescription, JingleContentTransport jingleContentTransport) {
        Jingle jingle = this.createSessionInitiate(h2, string, creator, string2, senders, jingleContentDescription, jingleContentTransport);
        return (IQ)this.connection.createStanzaCollectorAndSend((IQ)jingle).nextResult();
    }

    public Jingle createSessionAccept(h h2, String string, JingleContent.Creator creator, String string2, JingleContent.Senders senders, JingleContentDescription jingleContentDescription, JingleContentTransport jingleContentTransport) {
        Jingle.Builder builder = Jingle.builder(this.connection);
        builder.setResponder((h)this.connection.getUser()).setAction(JingleAction.session_accept).setSessionId(string);
        JingleContent.Builder builder2 = JingleContent.getBuilder();
        builder2.setCreator(creator).setName(string2).setSenders(senders).setDescription(jingleContentDescription).setTransport(jingleContentTransport);
        Jingle jingle = builder.addJingleContent(builder2.build()).build();
        jingle.setTo((i)h2);
        jingle.setFrom((i)this.connection.getUser());
        return jingle;
    }

    public IQ sendSessionAccept(h h2, String string, JingleContent.Creator creator, String string2, JingleContent.Senders senders, JingleContentDescription jingleContentDescription, JingleContentTransport jingleContentTransport) {
        Jingle jingle = this.createSessionAccept(h2, string, creator, string2, senders, jingleContentDescription, jingleContentTransport);
        return (IQ)this.connection.createStanzaCollectorAndSend((IQ)jingle).nextResult();
    }

    public Jingle createSessionTerminate(h h2, String string, JingleReason jingleReason) {
        Jingle.Builder builder = Jingle.builder(this.connection);
        builder.setAction(JingleAction.session_terminate).setSessionId(string).setReason(jingleReason);
        Jingle jingle = builder.build();
        jingle.setFrom((i)this.connection.getUser());
        jingle.setTo((i)h2);
        return jingle;
    }

    public Jingle createSessionTerminate(h h2, String string, JingleReason.Reason reason) {
        return this.createSessionTerminate(h2, string, new JingleReason(reason));
    }

    public Jingle createSessionTerminateDecline(h h2, String string) {
        return this.createSessionTerminate(h2, string, JingleReason.Reason.decline);
    }

    public IQ sendSessionTerminateDecline(h h2, String string) {
        Jingle jingle = this.createSessionTerminateDecline(h2, string);
        return (IQ)this.connection.createStanzaCollectorAndSend((IQ)jingle).nextResultOrThrow();
    }

    public Jingle createSessionTerminateSuccess(h h2, String string) {
        return this.createSessionTerminate(h2, string, JingleReason.Reason.success);
    }

    public IQ sendSessionTerminateSuccess(h h2, String string) {
        Jingle jingle = this.createSessionTerminateSuccess(h2, string);
        return (IQ)this.connection.createStanzaCollectorAndSend((IQ)jingle).nextResultOrThrow();
    }

    public Jingle createSessionTerminateBusy(h h2, String string) {
        return this.createSessionTerminate(h2, string, JingleReason.Reason.busy);
    }

    public IQ sendSessionTerminateBusy(h h2, String string) {
        Jingle jingle = this.createSessionTerminateBusy(h2, string);
        return (IQ)this.connection.createStanzaCollectorAndSend((IQ)jingle).nextResultOrThrow();
    }

    public Jingle createSessionTerminateAlternativeSession(h h2, String string, String string2) {
        return this.createSessionTerminate(h2, string, JingleReason.AlternativeSession(string2));
    }

    public IQ sendSessionTerminateAlternativeSession(h h2, String string, String string2) {
        Jingle jingle = this.createSessionTerminateAlternativeSession(h2, string, string2);
        return (IQ)this.connection.createStanzaCollectorAndSend((IQ)jingle).nextResultOrThrow();
    }

    public Jingle createSessionTerminateCancel(h h2, String string) {
        return this.createSessionTerminate(h2, string, JingleReason.Reason.cancel);
    }

    public IQ sendSessionTerminateCancel(h h2, String string) {
        Jingle jingle = this.createSessionTerminateCancel(h2, string);
        return (IQ)this.connection.createStanzaCollectorAndSend((IQ)jingle).nextResultOrThrow();
    }

    public Jingle createSessionTerminateContentCancel(h h2, String string, JingleContent.Creator creator, String string2) {
        Jingle.Builder builder = Jingle.builder(this.connection);
        builder.setAction(JingleAction.session_terminate).setSessionId(string);
        JingleContent.Builder builder2 = JingleContent.getBuilder();
        builder2.setCreator(creator).setName(string2);
        Jingle jingle = builder.addJingleContent(builder2.build()).build();
        jingle.setFrom((i)this.connection.getUser());
        jingle.setTo((i)h2);
        return jingle;
    }

    public IQ sendSessionTerminateContentCancel(h h2, String string, JingleContent.Creator creator, String string2) {
        Jingle jingle = this.createSessionTerminateContentCancel(h2, string, creator, string2);
        return (IQ)this.connection.createStanzaCollectorAndSend((IQ)jingle).nextResultOrThrow();
    }

    public Jingle createSessionTerminateUnsupportedTransports(h h2, String string) {
        return this.createSessionTerminate(h2, string, JingleReason.Reason.unsupported_transports);
    }

    public IQ sendSessionTerminateUnsupportedTransports(h h2, String string) {
        Jingle jingle = this.createSessionTerminateUnsupportedTransports(h2, string);
        return (IQ)this.connection.createStanzaCollectorAndSend((IQ)jingle).nextResultOrThrow();
    }

    public Jingle createSessionTerminateFailedTransport(h h2, String string) {
        return this.createSessionTerminate(h2, string, JingleReason.Reason.failed_transport);
    }

    public IQ sendSessionTerminateFailedTransport(h h2, String string) {
        Jingle jingle = this.createSessionTerminateFailedTransport(h2, string);
        return (IQ)this.connection.createStanzaCollectorAndSend((IQ)jingle).nextResultOrThrow();
    }

    public Jingle createSessionTerminateUnsupportedApplications(h h2, String string) {
        return this.createSessionTerminate(h2, string, JingleReason.Reason.unsupported_applications);
    }

    public IQ sendSessionTerminateUnsupportedApplications(h h2, String string) {
        Jingle jingle = this.createSessionTerminateUnsupportedApplications(h2, string);
        return (IQ)this.connection.createStanzaCollectorAndSend((IQ)jingle).nextResultOrThrow();
    }

    public Jingle createSessionTerminateFailedApplication(h h2, String string) {
        return this.createSessionTerminate(h2, string, JingleReason.Reason.failed_application);
    }

    public IQ sendSessionTerminateFailedApplication(h h2, String string) {
        Jingle jingle = this.createSessionTerminateFailedApplication(h2, string);
        return (IQ)this.connection.createStanzaCollectorAndSend((IQ)jingle).nextResultOrThrow();
    }

    public Jingle createSessionTerminateIncompatibleParameters(h h2, String string) {
        return this.createSessionTerminate(h2, string, JingleReason.Reason.incompatible_parameters);
    }

    public IQ sendSessionTerminateIncompatibleParameters(h h2, String string) {
        Jingle jingle = this.createSessionTerminateIncompatibleParameters(h2, string);
        return (IQ)this.connection.createStanzaCollectorAndSend((IQ)jingle).nextResultOrThrow();
    }

    public IQ sendContentRejectFileNotAvailable(h h2, String string, JingleContentDescription jingleContentDescription) {
        return null;
    }

    public Jingle createSessionPing(h h2, String string) {
        Jingle.Builder builder = Jingle.builder(this.connection);
        builder.setSessionId(string).setAction(JingleAction.session_info);
        Jingle jingle = builder.build();
        jingle.setFrom((i)this.connection.getUser());
        jingle.setTo((i)h2);
        return jingle;
    }

    public IQ sendSessionPing(h h2, String string) {
        Jingle jingle = this.createSessionPing(h2, string);
        return (IQ)this.connection.createStanzaCollectorAndSend((IQ)jingle).nextResultOrThrow();
    }

    public IQ createAck(Jingle jingle) {
        return IQ.createResultIQ((IQ)jingle);
    }

    public void sendAck(Jingle jingle) {
        this.connection.sendStanza((Stanza)this.createAck(jingle));
    }

    public Jingle createTransportReplace(h h2, h h3, String string, JingleContent.Creator creator, String string2, JingleContentTransport jingleContentTransport) {
        Jingle.Builder builder = Jingle.builder(this.connection);
        builder.setInitiator(h3).setSessionId(string).setAction(JingleAction.transport_replace);
        JingleContent.Builder builder2 = JingleContent.getBuilder();
        builder2.setName(string2).setCreator(creator).setTransport(jingleContentTransport);
        Jingle jingle = builder.addJingleContent(builder2.build()).build();
        jingle.setTo((i)h2);
        jingle.setFrom((i)this.connection.getUser());
        return jingle;
    }

    public IQ sendTransportReplace(h h2, h h3, String string, JingleContent.Creator creator, String string2, JingleContentTransport jingleContentTransport) {
        Jingle jingle = this.createTransportReplace(h2, h3, string, creator, string2, jingleContentTransport);
        return (IQ)this.connection.createStanzaCollectorAndSend((IQ)jingle).nextResultOrThrow();
    }

    public Jingle createTransportAccept(h h2, h h3, String string, JingleContent.Creator creator, String string2, JingleContentTransport jingleContentTransport) {
        Jingle.Builder builder = Jingle.builder(this.connection);
        builder.setAction(JingleAction.transport_accept).setInitiator(h3).setSessionId(string);
        JingleContent.Builder builder2 = JingleContent.getBuilder();
        builder2.setCreator(creator).setName(string2).setTransport(jingleContentTransport);
        Jingle jingle = builder.addJingleContent(builder2.build()).build();
        jingle.setTo((i)h2);
        jingle.setFrom((i)this.connection.getUser());
        return jingle;
    }

    public IQ sendTransportAccept(h h2, h h3, String string, JingleContent.Creator creator, String string2, JingleContentTransport jingleContentTransport) {
        Jingle jingle = this.createTransportAccept(h2, h3, string, creator, string2, jingleContentTransport);
        return (IQ)this.connection.createStanzaCollectorAndSend((IQ)jingle).nextResultOrThrow();
    }

    public Jingle createTransportReject(h h2, h h3, String string, JingleContent.Creator creator, String string2, JingleContentTransport jingleContentTransport) {
        Jingle.Builder builder = Jingle.builder(this.connection);
        builder.setAction(JingleAction.transport_reject).setInitiator(h3).setSessionId(string);
        JingleContent.Builder builder2 = JingleContent.getBuilder();
        builder2.setCreator(creator).setName(string2).setTransport(jingleContentTransport);
        Jingle jingle = builder.addJingleContent(builder2.build()).build();
        jingle.setTo((i)h2);
        jingle.setFrom((i)this.connection.getUser());
        return jingle;
    }

    public IQ sendTransportReject(h h2, h h3, String string, JingleContent.Creator creator, String string2, JingleContentTransport jingleContentTransport) {
        Jingle jingle = this.createTransportReject(h2, h3, string, creator, string2, jingleContentTransport);
        return (IQ)this.connection.createStanzaCollectorAndSend((IQ)jingle).nextResultOrThrow();
    }

    public IQ createErrorUnknownSession(Jingle jingle) {
        StanzaError stanzaError = ((StanzaError.Builder)StanzaError.getBuilder().setCondition(StanzaError.Condition.item_not_found).addExtension((ExtensionElement)JingleError.UNKNOWN_SESSION)).build();
        return IQ.createErrorResponse((IQ)jingle, (StanzaError)stanzaError);
    }

    public void sendErrorUnknownSession(Jingle jingle) {
        this.connection.sendStanza((Stanza)this.createErrorUnknownSession(jingle));
    }

    public IQ createErrorUnknownInitiator(Jingle jingle) {
        return IQ.createErrorResponse((IQ)jingle, (StanzaError.Condition)StanzaError.Condition.service_unavailable);
    }

    public void sendErrorUnknownInitiator(Jingle jingle) {
        this.connection.sendStanza((Stanza)this.createErrorUnknownInitiator(jingle));
    }

    public IQ createErrorUnsupportedInfo(Jingle jingle) {
        StanzaError stanzaError = ((StanzaError.Builder)StanzaError.getBuilder().setCondition(StanzaError.Condition.feature_not_implemented).addExtension((ExtensionElement)JingleError.UNSUPPORTED_INFO)).build();
        return IQ.createErrorResponse((IQ)jingle, (StanzaError)stanzaError);
    }

    public void sendErrorUnsupportedInfo(Jingle jingle) {
        this.connection.sendStanza((Stanza)this.createErrorUnsupportedInfo(jingle));
    }

    public IQ createErrorTieBreak(Jingle jingle) {
        StanzaError stanzaError = ((StanzaError.Builder)StanzaError.getBuilder().setCondition(StanzaError.Condition.conflict).addExtension((ExtensionElement)JingleError.TIE_BREAK)).build();
        return IQ.createErrorResponse((IQ)jingle, (StanzaError)stanzaError);
    }

    public void sendErrorTieBreak(Jingle jingle) {
        this.connection.sendStanza((Stanza)this.createErrorTieBreak(jingle));
    }

    public IQ createErrorOutOfOrder(Jingle jingle) {
        StanzaError stanzaError = ((StanzaError.Builder)StanzaError.getBuilder().setCondition(StanzaError.Condition.unexpected_request).addExtension((ExtensionElement)JingleError.OUT_OF_ORDER)).build();
        return IQ.createErrorResponse((IQ)jingle, (StanzaError)stanzaError);
    }

    public void sendErrorOutOfOrder(Jingle jingle) {
        this.connection.sendStanza((Stanza)this.createErrorOutOfOrder(jingle));
    }

    public IQ createErrorMalformedRequest(Jingle jingle) {
        return IQ.createErrorResponse((IQ)jingle, (StanzaError.Condition)StanzaError.Condition.bad_request);
    }

    public void sendErrorMalformedRequest(Jingle jingle) {
        this.connection.sendStanza((Stanza)this.createErrorMalformedRequest(jingle));
    }
}

