/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.transports.jingle_s5b;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.e.a.i;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.bytestreams.BytestreamSession;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamSession;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5ClientForInitiator;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.jingle.JingleManager;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.jivesoftware.smackx.jingle.element.JingleContentTransport;
import org.jivesoftware.smackx.jingle.element.JingleContentTransportCandidate;
import org.jivesoftware.smackx.jingle.transports.JingleTransportInitiationCallback;
import org.jivesoftware.smackx.jingle.transports.JingleTransportSession;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.JingleS5BTransportManager;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransport;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransportCandidate;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransportInfo;

public class JingleS5BTransportSession
extends JingleTransportSession<JingleS5BTransport> {
    private static final Logger LOGGER = Logger.getLogger(JingleS5BTransportSession.class.getName());
    private JingleTransportInitiationCallback callback;
    private UsedCandidate ourChoice;
    private UsedCandidate theirChoice;
    private static final UsedCandidate CANDIDATE_FAILURE = new UsedCandidate(null, null, null);

    public JingleS5BTransportSession(JingleSession jingleSession) {
        super(jingleSession);
    }

    @Override
    public JingleS5BTransport createTransport() {
        if (this.ourProposal == null) {
            this.ourProposal = this.createTransport(JingleManager.randomId(), Bytestream.Mode.tcp);
        }
        return (JingleS5BTransport)this.ourProposal;
    }

    @Override
    public void setTheirProposal(JingleContentTransport jingleContentTransport) {
        this.theirProposal = (JingleS5BTransport)jingleContentTransport;
    }

    public JingleS5BTransport createTransport(String string, Bytestream.Mode mode) {
        JingleS5BTransport.Builder builder = JingleS5BTransport.getBuilder().setStreamId(string).setMode(mode).setDestinationAddress(Socks5Utils.createDigest(string, (i)this.jingleSession.getLocal(), (i)this.jingleSession.getRemote()));
        if (JingleS5BTransportManager.isUseLocalCandidates()) {
            for (Bytestream.StreamHost object : this.transportManager().getLocalStreamHosts()) {
                builder.addTransportCandidate(new JingleS5BTransportCandidate(object, 100, JingleS5BTransportCandidate.Type.direct));
            }
        }
        List<Bytestream.StreamHost> list = Collections.emptyList();
        if (JingleS5BTransportManager.isUseExternalCandidates()) {
            try {
                list = this.transportManager().getAvailableStreamHosts();
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException throwable) {
                LOGGER.log(Level.WARNING, "Could not determine available StreamHosts.", throwable);
            }
        }
        for (Bytestream.StreamHost streamHost : list) {
            builder.addTransportCandidate(new JingleS5BTransportCandidate(streamHost, 0, JingleS5BTransportCandidate.Type.proxy));
        }
        return builder.build();
    }

    public void setTheirTransport(JingleContentTransport jingleContentTransport) {
        this.theirProposal = (JingleS5BTransport)jingleContentTransport;
    }

    @Override
    public void initiateOutgoingSession(JingleTransportInitiationCallback jingleTransportInitiationCallback) {
        this.callback = jingleTransportInitiationCallback;
        this.initiateSession();
    }

    @Override
    public void initiateIncomingSession(JingleTransportInitiationCallback jingleTransportInitiationCallback) {
        this.callback = jingleTransportInitiationCallback;
        this.initiateSession();
    }

    private void initiateSession() {
        Socks5Proxy.getSocks5Proxy().addTransfer(this.createTransport().getDestinationAddress());
        JingleContent jingleContent = this.jingleSession.getContents().get(0);
        UsedCandidate usedCandidate = this.chooseFromProposedCandidates((JingleS5BTransport)this.theirProposal);
        if (usedCandidate == null) {
            this.ourChoice = CANDIDATE_FAILURE;
            Jingle jingle = this.transportManager().createCandidateError(this.jingleSession.getRemote(), this.jingleSession.getInitiator(), this.jingleSession.getSessionId(), jingleContent.getSenders(), jingleContent.getCreator(), jingleContent.getName(), ((JingleS5BTransport)this.theirProposal).getStreamId());
            try {
                this.jingleSession.getConnection().sendStanza((Stanza)jingle);
            }
            catch (InterruptedException | SmackException.NotConnectedException throwable) {
                LOGGER.log(Level.WARNING, "Could not send candidate-error.", throwable);
            }
        } else {
            this.ourChoice = usedCandidate;
            Jingle jingle = this.transportManager().createCandidateUsed(this.jingleSession.getRemote(), this.jingleSession.getInitiator(), this.jingleSession.getSessionId(), jingleContent.getSenders(), jingleContent.getCreator(), jingleContent.getName(), ((JingleS5BTransport)this.theirProposal).getStreamId(), this.ourChoice.candidate.getCandidateId());
            try {
                this.jingleSession.getConnection().createStanzaCollectorAndSend((IQ)jingle).nextResultOrThrow();
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException throwable) {
                LOGGER.log(Level.WARNING, "Could not send candidate-used.", throwable);
            }
        }
        this.connectIfReady();
    }

    private UsedCandidate chooseFromProposedCandidates(JingleS5BTransport jingleS5BTransport) {
        for (JingleContentTransportCandidate jingleContentTransportCandidate : jingleS5BTransport.getCandidates()) {
            JingleS5BTransportCandidate jingleS5BTransportCandidate = (JingleS5BTransportCandidate)jingleContentTransportCandidate;
            try {
                return this.connectToTheirCandidate(jingleS5BTransportCandidate);
            }
            catch (IOException | InterruptedException | TimeoutException | SmackException | XMPPException throwable) {
                LOGGER.log(Level.WARNING, "Could not connect to " + jingleS5BTransportCandidate.getHost(), throwable);
            }
        }
        LOGGER.log(Level.WARNING, "Failed to connect to any candidate.");
        return null;
    }

    private UsedCandidate connectToTheirCandidate(JingleS5BTransportCandidate jingleS5BTransportCandidate) {
        Bytestream.StreamHost streamHost = jingleS5BTransportCandidate.getStreamHost();
        InetAddress inetAddress = streamHost.getAddress().asInetAddress();
        Socks5Client socks5Client = new Socks5Client(streamHost, ((JingleS5BTransport)this.theirProposal).getDestinationAddress());
        Socket socket = socks5Client.getSocket(10000);
        LOGGER.log(Level.INFO, "Connected to their StreamHost " + inetAddress + " using dstAddr " + ((JingleS5BTransport)this.theirProposal).getDestinationAddress());
        return new UsedCandidate((JingleS5BTransport)this.theirProposal, jingleS5BTransportCandidate, socket);
    }

    private UsedCandidate connectToOurCandidate(JingleS5BTransportCandidate jingleS5BTransportCandidate) {
        Bytestream.StreamHost streamHost = jingleS5BTransportCandidate.getStreamHost();
        InetAddress inetAddress = streamHost.getAddress().asInetAddress();
        Socks5ClientForInitiator socks5ClientForInitiator = new Socks5ClientForInitiator(streamHost, ((JingleS5BTransport)this.ourProposal).getDestinationAddress(), this.jingleSession.getConnection(), ((JingleS5BTransport)this.ourProposal).getStreamId(), (i)this.jingleSession.getRemote());
        Socket socket = socks5ClientForInitiator.getSocket(10000);
        LOGGER.log(Level.INFO, "Connected to our StreamHost " + inetAddress + " using dstAddr " + ((JingleS5BTransport)this.ourProposal).getDestinationAddress());
        return new UsedCandidate((JingleS5BTransport)this.ourProposal, jingleS5BTransportCandidate, socket);
    }

    @Override
    public String getNamespace() {
        return "urn:xmpp:jingle:transports:s5b:1";
    }

    @Override
    public IQ handleTransportInfo(Jingle jingle) {
        JingleS5BTransportInfo jingleS5BTransportInfo = (JingleS5BTransportInfo)jingle.getContents().get(0).getTransport().getInfo();
        switch (jingleS5BTransportInfo.getElementName()) {
            case "candidate-used": {
                return this.handleCandidateUsed(jingle);
            }
            case "activated": {
                return this.handleCandidateActivate(jingle);
            }
            case "candidate-error": {
                return this.handleCandidateError(jingle);
            }
            case "proxy-error": {
                return this.handleProxyError(jingle);
            }
        }
        return IQ.createResultIQ((IQ)jingle);
    }

    public IQ handleCandidateUsed(Jingle jingle) {
        JingleS5BTransportInfo jingleS5BTransportInfo = (JingleS5BTransportInfo)jingle.getContents().get(0).getTransport().getInfo();
        String string = ((JingleS5BTransportInfo.CandidateUsed)jingleS5BTransportInfo).getCandidateId();
        this.theirChoice = new UsedCandidate((JingleS5BTransport)this.ourProposal, ((JingleS5BTransport)this.ourProposal).getCandidate(string), null);
        if (this.theirChoice.candidate == null) {
            // empty if block
        }
        this.connectIfReady();
        return IQ.createResultIQ((IQ)jingle);
    }

    public IQ handleCandidateActivate(Jingle jingle) {
        LOGGER.log(Level.INFO, "handleCandidateActivate");
        Socks5BytestreamSession socks5BytestreamSession = new Socks5BytestreamSession(this.ourChoice.socket, this.ourChoice.candidate.getJid().n().a((CharSequence)this.jingleSession.getRemote().n()));
        this.callback.onSessionInitiated(socks5BytestreamSession);
        return IQ.createResultIQ((IQ)jingle);
    }

    public IQ handleCandidateError(Jingle jingle) {
        this.theirChoice = CANDIDATE_FAILURE;
        this.connectIfReady();
        return IQ.createResultIQ((IQ)jingle);
    }

    public IQ handleProxyError(Jingle jingle) {
        return IQ.createResultIQ((IQ)jingle);
    }

    private void connectIfReady() {
        JingleContent jingleContent = this.jingleSession.getContents().get(0);
        if (this.ourChoice == null || this.theirChoice == null) {
            LOGGER.log(Level.INFO, "Not ready.");
            return;
        }
        if (this.ourChoice == CANDIDATE_FAILURE && this.theirChoice == CANDIDATE_FAILURE) {
            LOGGER.log(Level.INFO, "Failure.");
            this.jingleSession.onTransportMethodFailed(this.getNamespace());
            return;
        }
        LOGGER.log(Level.INFO, "Ready.");
        UsedCandidate usedCandidate = this.ourChoice != CANDIDATE_FAILURE && this.theirChoice != CANDIDATE_FAILURE ? (this.ourChoice.candidate.getPriority() > this.theirChoice.candidate.getPriority() ? this.ourChoice : (this.ourChoice.candidate.getPriority() < this.theirChoice.candidate.getPriority() ? this.theirChoice : (this.jingleSession.isInitiator() ? this.ourChoice : this.theirChoice))) : (this.ourChoice != CANDIDATE_FAILURE ? this.ourChoice : this.theirChoice);
        if (usedCandidate == this.theirChoice) {
            Object object;
            LOGGER.log(Level.INFO, "Their choice, so our proposed candidate is used.");
            boolean bl = usedCandidate.candidate.getType() == JingleS5BTransportCandidate.Type.proxy;
            try {
                usedCandidate = this.connectToOurCandidate(usedCandidate.candidate);
            }
            catch (IOException | InterruptedException | TimeoutException | SmackException | XMPPException throwable) {
                LOGGER.log(Level.INFO, "Could not connect to our candidate.", throwable);
                return;
            }
            if (bl) {
                LOGGER.log(Level.INFO, "Is external proxy. Activate it.");
                object = new Bytestream(((JingleS5BTransport)this.ourProposal).getStreamId());
                ((Bytestream)((Object)object)).setMode(null);
                object.setType(IQ.Type.set);
                object.setTo(usedCandidate.candidate.getJid());
                ((Bytestream)((Object)object)).setToActivate((i)this.jingleSession.getRemote());
                object.setFrom((i)this.jingleSession.getLocal());
                try {
                    this.jingleSession.getConnection().createStanzaCollectorAndSend((IQ)object).nextResultOrThrow();
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException throwable) {
                    LOGGER.log(Level.WARNING, "Could not activate proxy.", throwable);
                    return;
                }
                LOGGER.log(Level.INFO, "Send candidate-activate.");
                Jingle jingle = this.transportManager().createCandidateActivated(this.jingleSession.getRemote(), this.jingleSession.getInitiator(), this.jingleSession.getSessionId(), jingleContent.getSenders(), jingleContent.getCreator(), jingleContent.getName(), usedCandidate.transport.getStreamId(), usedCandidate.candidate.getCandidateId());
                try {
                    this.jingleSession.getConnection().createStanzaCollectorAndSend((IQ)jingle).nextResultOrThrow();
                }
                catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException throwable) {
                    LOGGER.log(Level.WARNING, "Could not send candidate-activated", throwable);
                    return;
                }
            }
            LOGGER.log(Level.INFO, "Start transmission.");
            object = new Socks5BytestreamSession(usedCandidate.socket, !bl);
            this.callback.onSessionInitiated((BytestreamSession)object);
        } else {
            boolean bl;
            LOGGER.log(Level.INFO, "Our choice, so their candidate was used.");
            boolean bl2 = bl = usedCandidate.candidate.getType() == JingleS5BTransportCandidate.Type.proxy;
            if (!bl) {
                LOGGER.log(Level.INFO, "Direct connection.");
                Socks5BytestreamSession socks5BytestreamSession = new Socks5BytestreamSession(usedCandidate.socket, true);
                this.callback.onSessionInitiated(socks5BytestreamSession);
            } else {
                LOGGER.log(Level.INFO, "Our choice was their external proxy. wait for candidate-activate.");
            }
        }
    }

    public JingleS5BTransportManager transportManager() {
        return JingleS5BTransportManager.getInstanceFor(this.jingleSession.getConnection());
    }

    private static final class UsedCandidate {
        private final Socket socket;
        private final JingleS5BTransport transport;
        private final JingleS5BTransportCandidate candidate;

        private UsedCandidate(JingleS5BTransport jingleS5BTransport, JingleS5BTransportCandidate jingleS5BTransportCandidate, Socket socket) {
            this.socket = socket;
            this.transport = jingleS5BTransport;
            this.candidate = jingleS5BTransportCandidate;
        }
    }
}

