/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jiveproperties.provider;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.jiveproperties.JivePropertiesManager;
import org.jivesoftware.smackx.jiveproperties.packet.JivePropertiesExtension;

public class JivePropertiesExtensionProvider
extends ExtensionElementProvider<JivePropertiesExtension> {
    private static final Logger LOGGER = Logger.getLogger(JivePropertiesExtensionProvider.class.getName());

    public JivePropertiesExtension parse(XmlPullParser xmlPullParser, int n, XmlEnvironment xmlEnvironment) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        block2: while (true) {
            XmlPullParser.Event event;
            if ((event = xmlPullParser.next()) == XmlPullParser.Event.START_ELEMENT && xmlPullParser.getName().equals("property")) {
                boolean bl = false;
                String string = null;
                String string2 = null;
                String string3 = null;
                Object object = null;
                while (true) {
                    Object object2;
                    if (bl) continue block2;
                    event = xmlPullParser.next();
                    if (event == XmlPullParser.Event.START_ELEMENT) {
                        object2 = xmlPullParser.getName();
                        if (((String)object2).equals("name")) {
                            string = xmlPullParser.nextText();
                            continue;
                        }
                        if (!((String)object2).equals("value")) continue;
                        string2 = xmlPullParser.getAttributeValue("", "type");
                        string3 = xmlPullParser.nextText();
                        continue;
                    }
                    if (event != XmlPullParser.Event.END_ELEMENT || !xmlPullParser.getName().equals("property")) continue;
                    if ("integer".equals(string2)) {
                        object = Integer.valueOf(string3);
                    } else if ("long".equals(string2)) {
                        object = Long.valueOf(string3);
                    } else if ("float".equals(string2)) {
                        object = Float.valueOf(string3);
                    } else if ("double".equals(string2)) {
                        object = Double.valueOf(string3);
                    } else if ("boolean".equals(string2)) {
                        object = Boolean.valueOf(string3);
                    } else if ("string".equals(string2)) {
                        object = string3;
                    } else if ("java-object".equals(string2)) {
                        if (JivePropertiesManager.isJavaObjectEnabled()) {
                            try {
                                object2 = Base64.decode((String)string3);
                                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream((byte[])object2));
                                object = objectInputStream.readObject();
                            }
                            catch (Exception exception) {
                                LOGGER.log(Level.SEVERE, "Error parsing java object", exception);
                            }
                        } else {
                            LOGGER.severe("JavaObject is not enabled. Enable with JivePropertiesManager.setJavaObjectEnabled(true)");
                        }
                    }
                    if (string != null && object != null) {
                        hashMap.put(string, object);
                    }
                    bl = true;
                }
            }
            if (event == XmlPullParser.Event.END_ELEMENT && xmlPullParser.getName().equals("properties")) break;
        }
        return new JivePropertiesExtension(hashMap);
    }
}

