/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.offline;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.offline.OfflineMessageHeader;
import org.jivesoftware.smackx.offline.packet.OfflineMessageInfo;
import org.jivesoftware.smackx.offline.packet.OfflineMessageRequest;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public final class OfflineMessageManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(OfflineMessageManager.class.getName());
    public static final String NAMESPACE = "http://jabber.org/protocol/offline";
    private static final Map<XMPPConnection, OfflineMessageManager> INSTANCES = new WeakHashMap<XMPPConnection, OfflineMessageManager>();
    private static final StanzaFilter PACKET_FILTER = new AndFilter(new StanzaFilter[]{new StanzaExtensionFilter((ExtensionElement)new OfflineMessageInfo()), StanzaTypeFilter.MESSAGE});
    private ServiceDiscoveryManager serviceDiscoveryManager;

    private OfflineMessageManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
    }

    public static synchronized OfflineMessageManager getInstanceFor(XMPPConnection xMPPConnection) {
        OfflineMessageManager offlineMessageManager = INSTANCES.get(xMPPConnection);
        if (offlineMessageManager == null) {
            offlineMessageManager = new OfflineMessageManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, offlineMessageManager);
        }
        return offlineMessageManager;
    }

    public boolean supportsFlexibleRetrieval() {
        return this.serviceDiscoveryManager.serverSupportsFeature(NAMESPACE);
    }

    public int getMessageCount() {
        DiscoverInfo discoverInfo = this.serviceDiscoveryManager.discoverInfo(null, NAMESPACE);
        DataForm dataForm = DataForm.from((StanzaView)discoverInfo, NAMESPACE);
        if (dataForm == null) {
            return 0;
        }
        String string = dataForm.getField("number_of_messages").getFirstValue();
        return Integer.parseInt(string);
    }

    public List<OfflineMessageHeader> getHeaders() {
        ArrayList<OfflineMessageHeader> arrayList = new ArrayList<OfflineMessageHeader>();
        DiscoverItems discoverItems = this.serviceDiscoveryManager.discoverItems(null, NAMESPACE);
        for (DiscoverItems.Item item : discoverItems.getItems()) {
            arrayList.add(new OfflineMessageHeader(item));
        }
        return arrayList;
    }

    public List<Message> getMessages(final List<String> list) {
        OfflineMessageRequest.Item item;
        ArrayList<Message> arrayList = new ArrayList<Message>(list.size());
        OfflineMessageRequest offlineMessageRequest = new OfflineMessageRequest();
        for (String string : list) {
            item = new OfflineMessageRequest.Item(string);
            item.setAction("view");
            offlineMessageRequest.addItem(item);
        }
        AndFilter andFilter = new AndFilter(new StanzaFilter[]{PACKET_FILTER, new StanzaFilter(){

            public boolean accept(Stanza stanza) {
                OfflineMessageInfo offlineMessageInfo = (OfflineMessageInfo)stanza.getExtension(OfflineMessageInfo.class);
                return list.contains(offlineMessageInfo.getNode());
            }
        }});
        int n = list.size();
        item = this.connection().createStanzaCollector((StanzaFilter)andFilter);
        try {
            Message message;
            this.connection().createStanzaCollectorAndSend((IQ)offlineMessageRequest).nextResultOrThrow();
            do {
                if ((message = (Message)item.nextResult()) != null) {
                    arrayList.add(message);
                    --n;
                    continue;
                }
                if (message != null || n <= 0) continue;
                LOGGER.log(Level.WARNING, "Did not receive all expected offline messages. " + n + " are missing.");
            } while (message != null && n > 0);
        }
        finally {
            if (item != null) {
                item.close();
            }
        }
        return arrayList;
    }

    public List<Message> getMessages() {
        ArrayList<Message> arrayList;
        OfflineMessageRequest offlineMessageRequest = new OfflineMessageRequest();
        offlineMessageRequest.setFetch(true);
        StanzaCollector stanzaCollector = this.connection().createStanzaCollectorAndSend((IQ)offlineMessageRequest);
        StanzaCollector.Configuration configuration = StanzaCollector.newConfiguration().setStanzaFilter(PACKET_FILTER).setCollectorToReset(stanzaCollector);
        try (StanzaCollector stanzaCollector2 = this.connection().createStanzaCollector(configuration);){
            Message message;
            stanzaCollector.nextResultOrThrow();
            stanzaCollector2.cancel();
            arrayList = new ArrayList<Message>(stanzaCollector2.getCollectedCount());
            while ((message = (Message)stanzaCollector2.pollResult()) != null) {
                arrayList.add(message);
            }
        }
        return arrayList;
    }

    public void deleteMessages(List<String> list) {
        OfflineMessageRequest offlineMessageRequest = new OfflineMessageRequest();
        offlineMessageRequest.setType(IQ.Type.set);
        for (String string : list) {
            OfflineMessageRequest.Item item = new OfflineMessageRequest.Item(string);
            item.setAction("remove");
            offlineMessageRequest.addItem(item);
        }
        this.connection().createStanzaCollectorAndSend((IQ)offlineMessageRequest).nextResultOrThrow();
    }

    public void deleteMessages() {
        OfflineMessageRequest offlineMessageRequest = new OfflineMessageRequest();
        offlineMessageRequest.setType(IQ.Type.set);
        offlineMessageRequest.setPurge(true);
        this.connection().createStanzaCollectorAndSend((IQ)offlineMessageRequest).nextResultOrThrow();
    }
}

