/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.e.a.a.d;
import org.e.a.i;
import org.e.b.c;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.FlexibleStanzaTypeFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.delay.DelayInformationManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;
import org.jivesoftware.smackx.pubsub.Affiliation;
import org.jivesoftware.smackx.pubsub.AffiliationsExtension;
import org.jivesoftware.smackx.pubsub.ConfigurationEvent;
import org.jivesoftware.smackx.pubsub.EmbeddedPacketExtension;
import org.jivesoftware.smackx.pubsub.EventElement;
import org.jivesoftware.smackx.pubsub.EventElementType;
import org.jivesoftware.smackx.pubsub.FormNode;
import org.jivesoftware.smackx.pubsub.FormNodeType;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.ItemDeleteEvent;
import org.jivesoftware.smackx.pubsub.ItemPublishEvent;
import org.jivesoftware.smackx.pubsub.ItemsExtension;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.OptionsExtension;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.RetractItem;
import org.jivesoftware.smackx.pubsub.SubscribeExtension;
import org.jivesoftware.smackx.pubsub.Subscription;
import org.jivesoftware.smackx.pubsub.SubscriptionsExtension;
import org.jivesoftware.smackx.pubsub.UnsubscribeExtension;
import org.jivesoftware.smackx.pubsub.form.ConfigureForm;
import org.jivesoftware.smackx.pubsub.form.FillableConfigureForm;
import org.jivesoftware.smackx.pubsub.form.FillableSubscribeForm;
import org.jivesoftware.smackx.pubsub.form.SubscribeForm;
import org.jivesoftware.smackx.pubsub.listener.ItemDeleteListener;
import org.jivesoftware.smackx.pubsub.listener.ItemEventListener;
import org.jivesoftware.smackx.pubsub.listener.NodeConfigListener;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.jivesoftware.smackx.pubsub.util.NodeUtils;
import org.jivesoftware.smackx.shim.packet.Header;
import org.jivesoftware.smackx.shim.packet.HeadersExtension;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public abstract class Node {
    protected final PubSubManager pubSubManager;
    protected final String id;
    protected ConcurrentHashMap<ItemEventListener<Item>, StanzaListener> itemEventToListenerMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<ItemDeleteListener, StanzaListener> itemDeleteToListenerMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<NodeConfigListener, StanzaListener> configEventToListenerMap = new ConcurrentHashMap();

    Node(PubSubManager pubSubManager, String string) {
        this.pubSubManager = pubSubManager;
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public ConfigureForm getNodeConfiguration() {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.CONFIGURE_OWNER, this.getId()));
        PubSub pubSub2 = this.sendPubsubPacket(pubSub);
        return NodeUtils.getFormFromPacket((Stanza)pubSub2, PubSubElementType.CONFIGURE_OWNER);
    }

    public void sendConfigurationForm(FillableConfigureForm fillableConfigureForm) {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.set, new FormNode(FormNodeType.CONFIGURE_OWNER, this.getId(), fillableConfigureForm.getDataFormToSubmit()));
        this.pubSubManager.getConnection().createStanzaCollectorAndSend((IQ)pubSub).nextResultOrThrow();
    }

    public DiscoverInfo discoverInfo() {
        XMPPConnection xMPPConnection = this.pubSubManager.getConnection();
        DiscoverInfo discoverInfo = ((DiscoverInfoBuilder)DiscoverInfo.builder(xMPPConnection).to((i)this.pubSubManager.getServiceJid())).setNode(this.getId()).build();
        return (DiscoverInfo)xMPPConnection.createStanzaCollectorAndSend((IQ)discoverInfo).nextResultOrThrow();
    }

    public List<Subscription> getSubscriptions() {
        return this.getSubscriptions(null, null);
    }

    public List<Subscription> getSubscriptions(List<ExtensionElement> list, Collection<ExtensionElement> collection) {
        return this.getSubscriptions(SubscriptionsExtension.SubscriptionsNamespace.basic, list, collection);
    }

    public List<Subscription> getSubscriptionsAsOwner() {
        return this.getSubscriptionsAsOwner(null, null);
    }

    public List<Subscription> getSubscriptionsAsOwner(List<ExtensionElement> list, Collection<ExtensionElement> collection) {
        return this.getSubscriptions(SubscriptionsExtension.SubscriptionsNamespace.owner, list, collection);
    }

    private List<Subscription> getSubscriptions(SubscriptionsExtension.SubscriptionsNamespace subscriptionsNamespace, List<ExtensionElement> list, Collection<ExtensionElement> collection) {
        ExtensionElement extensionElement2;
        PubSubElementType pubSubElementType = subscriptionsNamespace.type;
        PubSub pubSub = this.createPubsubPacket(IQ.Type.get, new NodeExtension(pubSubElementType, this.getId()));
        if (list != null) {
            for (ExtensionElement extensionElement2 : list) {
                pubSub.addExtension(extensionElement2);
            }
        }
        PubSub pubSub2 = this.sendPubsubPacket(pubSub);
        if (collection != null) {
            collection.addAll(pubSub2.getExtensions());
        }
        extensionElement2 = (SubscriptionsExtension)pubSub2.getExtension(pubSubElementType);
        return extensionElement2.getSubscriptions();
    }

    public PubSub modifySubscriptionsAsOwner(List<Subscription> list) {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.set, new SubscriptionsExtension(SubscriptionsExtension.SubscriptionsNamespace.owner, this.getId(), list));
        return this.sendPubsubPacket(pubSub);
    }

    public List<Affiliation> getAffiliations() {
        return this.getAffiliations(null, null);
    }

    public List<Affiliation> getAffiliations(List<ExtensionElement> list, Collection<ExtensionElement> collection) {
        return this.getAffiliations(Affiliation.AffiliationNamespace.basic, list, collection);
    }

    public List<Affiliation> getAffiliationsAsOwner() {
        return this.getAffiliationsAsOwner(null, null);
    }

    public List<Affiliation> getAffiliationsAsOwner(List<ExtensionElement> list, Collection<ExtensionElement> collection) {
        return this.getAffiliations(Affiliation.AffiliationNamespace.owner, list, collection);
    }

    private List<Affiliation> getAffiliations(Affiliation.AffiliationNamespace affiliationNamespace, List<ExtensionElement> list, Collection<ExtensionElement> collection) {
        ExtensionElement extensionElement2;
        PubSubElementType pubSubElementType = affiliationNamespace.type;
        PubSub pubSub = this.createPubsubPacket(IQ.Type.get, new NodeExtension(pubSubElementType, this.getId()));
        if (list != null) {
            for (ExtensionElement extensionElement2 : list) {
                pubSub.addExtension(extensionElement2);
            }
        }
        PubSub pubSub2 = this.sendPubsubPacket(pubSub);
        if (collection != null) {
            collection.addAll(pubSub2.getExtensions());
        }
        extensionElement2 = (AffiliationsExtension)pubSub2.getExtension(pubSubElementType);
        return extensionElement2.getAffiliations();
    }

    public PubSub modifyAffiliationAsOwner(List<Affiliation> list) {
        for (Affiliation affiliation : list) {
            if (affiliation.getPubSubNamespace() == PubSubNamespace.owner) continue;
            throw new IllegalArgumentException("Must use Affiliation(BareJid, Type) affiliations");
        }
        Object object = this.createPubsubPacket(IQ.Type.set, new AffiliationsExtension(Affiliation.AffiliationNamespace.owner, list, this.getId()));
        return this.sendPubsubPacket((PubSub)((Object)object));
    }

    public Subscription subscribe(i i2) {
        PubSub pubSub = this.createPubsubPacket(IQ.Type.set, new SubscribeExtension(i2, this.getId()));
        PubSub pubSub2 = this.sendPubsubPacket(pubSub);
        return (Subscription)pubSub2.getExtension(PubSubElementType.SUBSCRIPTION);
    }

    @Deprecated
    public Subscription subscribe(String string) {
        i i2;
        try {
            i2 = d.a((String)string);
        }
        catch (c c2) {
            throw new IllegalArgumentException(c2);
        }
        return this.subscribe(i2);
    }

    public Subscription subscribe(i i2, FillableSubscribeForm fillableSubscribeForm) {
        DataForm dataForm = fillableSubscribeForm.getDataFormToSubmit();
        PubSub pubSub = this.createPubsubPacket(IQ.Type.set, new SubscribeExtension(i2, this.getId()));
        pubSub.addExtension(new FormNode(FormNodeType.OPTIONS, dataForm));
        PubSub pubSub2 = this.sendPubsubPacket(pubSub);
        return (Subscription)pubSub2.getExtension(PubSubElementType.SUBSCRIPTION);
    }

    @Deprecated
    public Subscription subscribe(String string, FillableSubscribeForm fillableSubscribeForm) {
        i i2;
        try {
            i2 = d.a((String)string);
        }
        catch (c c2) {
            throw new IllegalArgumentException(c2);
        }
        return this.subscribe(i2, fillableSubscribeForm);
    }

    public void unsubscribe(String string) {
        this.unsubscribe(string, null);
    }

    public void unsubscribe(String string, String string2) {
        this.sendPubsubPacket(this.createPubsubPacket(IQ.Type.set, new UnsubscribeExtension(string, this.getId(), string2)));
    }

    public SubscribeForm getSubscriptionOptions(String string) {
        return this.getSubscriptionOptions(string, null);
    }

    public SubscribeForm getSubscriptionOptions(String string, String string2) {
        PubSub pubSub = this.sendPubsubPacket(this.createPubsubPacket(IQ.Type.get, new OptionsExtension(string, this.getId(), string2)));
        FormNode formNode = (FormNode)pubSub.getExtension(PubSubElementType.OPTIONS);
        return new SubscribeForm(formNode.getForm());
    }

    public void addItemEventListener(ItemEventListener itemEventListener) {
        ItemEventTranslator itemEventTranslator = new ItemEventTranslator(itemEventListener);
        this.itemEventToListenerMap.put(itemEventListener, itemEventTranslator);
        this.pubSubManager.getConnection().addSyncStanzaListener((StanzaListener)itemEventTranslator, (StanzaFilter)new EventContentFilter(EventElementType.items.toString(), "item"));
    }

    public void removeItemEventListener(ItemEventListener itemEventListener) {
        StanzaListener stanzaListener = this.itemEventToListenerMap.remove(itemEventListener);
        if (stanzaListener != null) {
            this.pubSubManager.getConnection().removeSyncStanzaListener(stanzaListener);
        }
    }

    public void addConfigurationListener(NodeConfigListener nodeConfigListener) {
        NodeConfigTranslator nodeConfigTranslator = new NodeConfigTranslator(nodeConfigListener);
        this.configEventToListenerMap.put(nodeConfigListener, nodeConfigTranslator);
        this.pubSubManager.getConnection().addSyncStanzaListener((StanzaListener)nodeConfigTranslator, (StanzaFilter)new EventContentFilter(EventElementType.configuration.toString()));
    }

    public void removeConfigurationListener(NodeConfigListener nodeConfigListener) {
        StanzaListener stanzaListener = this.configEventToListenerMap.remove(nodeConfigListener);
        if (stanzaListener != null) {
            this.pubSubManager.getConnection().removeSyncStanzaListener(stanzaListener);
        }
    }

    public void addItemDeleteListener(ItemDeleteListener itemDeleteListener) {
        ItemDeleteTranslator itemDeleteTranslator = new ItemDeleteTranslator(itemDeleteListener);
        this.itemDeleteToListenerMap.put(itemDeleteListener, itemDeleteTranslator);
        EventContentFilter eventContentFilter = new EventContentFilter(EventElementType.items.toString(), "retract");
        EventContentFilter eventContentFilter2 = new EventContentFilter(EventElementType.purge.toString());
        this.pubSubManager.getConnection().addSyncStanzaListener((StanzaListener)itemDeleteTranslator, (StanzaFilter)new OrFilter(new StanzaFilter[]{eventContentFilter, eventContentFilter2}));
    }

    public void removeItemDeleteListener(ItemDeleteListener itemDeleteListener) {
        StanzaListener stanzaListener = this.itemDeleteToListenerMap.remove(itemDeleteListener);
        if (stanzaListener != null) {
            this.pubSubManager.getConnection().removeSyncStanzaListener(stanzaListener);
        }
    }

    public String toString() {
        return super.toString() + " " + this.getClass().getName() + " id: " + this.id;
    }

    protected PubSub createPubsubPacket(IQ.Type type, NodeExtension nodeExtension) {
        return PubSub.createPubsubPacket((i)this.pubSubManager.getServiceJid(), type, nodeExtension);
    }

    protected PubSub sendPubsubPacket(PubSub pubSub) {
        return this.pubSubManager.sendPubsubPacket(pubSub);
    }

    private static List<String> getSubscriptionIds(Stanza stanza) {
        HeadersExtension headersExtension = (HeadersExtension)stanza.getExtension(HeadersExtension.class);
        ArrayList<String> arrayList = null;
        if (headersExtension != null) {
            arrayList = new ArrayList<String>(headersExtension.getHeaders().size());
            for (Header header : headersExtension.getHeaders()) {
                arrayList.add(header.getValue());
            }
        }
        return arrayList;
    }

    class EventContentFilter
    extends FlexibleStanzaTypeFilter<Message> {
        private final String firstElement;
        private final String secondElement;
        private final boolean allowEmpty;

        EventContentFilter(String string) {
            this(string, null);
        }

        EventContentFilter(String string, String string2) {
            this.firstElement = string;
            this.secondElement = string2;
            this.allowEmpty = this.firstElement.equals(EventElementType.items.toString()) && "item".equals(string2);
        }

        public boolean acceptSpecific(Message message) {
            EventElement eventElement = EventElement.from((Stanza)message);
            if (eventElement == null) {
                return false;
            }
            NodeExtension nodeExtension = eventElement.getEvent();
            if (nodeExtension == null) {
                return false;
            }
            if (nodeExtension.getElementName().equals(this.firstElement)) {
                if (!nodeExtension.getNode().equals(Node.this.getId())) {
                    return false;
                }
                if (this.secondElement == null) {
                    return true;
                }
                if (nodeExtension instanceof EmbeddedPacketExtension) {
                    List<ExtensionElement> list = ((EmbeddedPacketExtension)((Object)nodeExtension)).getExtensions();
                    if (this.allowEmpty && list.isEmpty()) {
                        return true;
                    }
                    if (list.size() > 0 && list.get(0).getElementName().equals(this.secondElement)) {
                        return true;
                    }
                }
            }
            return false;
        }
    }

    public static class NodeConfigTranslator
    implements StanzaListener {
        private final NodeConfigListener listener;

        public NodeConfigTranslator(NodeConfigListener nodeConfigListener) {
            this.listener = nodeConfigListener;
        }

        public void processStanza(Stanza stanza) {
            EventElement eventElement = (EventElement)stanza.getExtensionElement("event", PubSubNamespace.event.getXmlns());
            ConfigurationEvent configurationEvent = (ConfigurationEvent)eventElement.getEvent();
            this.listener.handleNodeConfiguration(configurationEvent);
        }
    }

    public static class ItemDeleteTranslator
    implements StanzaListener {
        private final ItemDeleteListener listener;

        public ItemDeleteTranslator(ItemDeleteListener itemDeleteListener) {
            this.listener = itemDeleteListener;
        }

        public void processStanza(Stanza stanza) {
            EventElement eventElement = (EventElement)stanza.getExtensionElement("event", PubSubNamespace.event.getXmlns());
            List<ExtensionElement> list = eventElement.getExtensions();
            if (list.get(0).getElementName().equals(PubSubElementType.PURGE_EVENT.getElementName())) {
                this.listener.handlePurge();
            } else {
                ItemsExtension itemsExtension = (ItemsExtension)eventElement.getEvent();
                List<? extends NamedElement> list2 = itemsExtension.getItems();
                ArrayList<String> arrayList = new ArrayList<String>(list2.size());
                for (RetractItem retractItem : list2) {
                    arrayList.add(retractItem.getId());
                }
                ItemDeleteEvent itemDeleteEvent = new ItemDeleteEvent(itemsExtension.getNode(), arrayList, Node.getSubscriptionIds(stanza));
                this.listener.handleDeletedItems(itemDeleteEvent);
            }
        }
    }

    public static class ItemEventTranslator
    implements StanzaListener {
        private final ItemEventListener listener;

        public ItemEventTranslator(ItemEventListener itemEventListener) {
            this.listener = itemEventListener;
        }

        public void processStanza(Stanza stanza) {
            EventElement eventElement = (EventElement)stanza.getExtensionElement("event", PubSubNamespace.event.getXmlns());
            ItemsExtension itemsExtension = (ItemsExtension)eventElement.getEvent();
            ItemPublishEvent<? extends NamedElement> itemPublishEvent = new ItemPublishEvent<NamedElement>(itemsExtension.getNode(), itemsExtension.getItems(), Node.getSubscriptionIds(stanza), DelayInformationManager.getDelayTimestamp(stanza));
            this.listener.handlePublishedItems(itemPublishEvent);
        }
    }
}

