/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.softwareinfo;

import java.util.Map;
import java.util.WeakHashMap;
import org.e.a.i;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.softwareinfo.form.SoftwareInfoForm;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public final class SoftwareInfoManager
extends Manager {
    private static final Map<XMPPConnection, SoftwareInfoManager> INSTANCES = new WeakHashMap<XMPPConnection, SoftwareInfoManager>();
    private final ServiceDiscoveryManager serviceDiscoveryManager;

    public static synchronized SoftwareInfoManager getInstanceFor(XMPPConnection xMPPConnection) {
        SoftwareInfoManager softwareInfoManager = INSTANCES.get(xMPPConnection);
        if (softwareInfoManager == null) {
            softwareInfoManager = new SoftwareInfoManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, softwareInfoManager);
        }
        return softwareInfoManager;
    }

    private SoftwareInfoManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(xMPPConnection);
    }

    public void publishSoftwareInformationForm(SoftwareInfoForm softwareInfoForm) {
        this.serviceDiscoveryManager.addExtendedInfo(softwareInfoForm.getDataForm());
    }

    public SoftwareInfoForm fromJid(i i2) {
        DiscoverInfo discoverInfo = this.serviceDiscoveryManager.discoverInfo(i2);
        DataForm dataForm = DataForm.from((StanzaView)discoverInfo, "urn:xmpp:dataforms:softwareinfo");
        if (dataForm == null) {
            return null;
        }
        return SoftwareInfoForm.getBuilder().setDataForm(dataForm).build();
    }
}

