/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.FullyQualifiedElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.formtypes.FormFieldRegistry;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;

public final class DataForm
implements ExtensionElement {
    public static final String NAMESPACE = "jabber:x:data";
    public static final String ELEMENT = "x";
    public static final QName QNAME = new QName("jabber:x:data", "x");
    private final Type type;
    private final String title;
    private final List<String> instructions;
    private final ReportedData reportedData;
    private final List<Item> items;
    private final List<FormField> fields;
    private final Map<String, FormField> fieldsMap;
    private final List<Element> extensionElements;

    private DataForm(Builder builder) {
        this.type = builder.type;
        this.title = builder.title;
        this.instructions = CollectionUtil.cloneAndSeal((Collection)builder.instructions);
        this.reportedData = builder.reportedData;
        this.items = CollectionUtil.cloneAndSeal((Collection)builder.items);
        builder.orderFields();
        this.fields = CollectionUtil.cloneAndSeal((Collection)builder.fields);
        this.fieldsMap = CollectionUtil.cloneAndSeal((Map)builder.fieldsMap);
        this.extensionElements = CollectionUtil.cloneAndSeal((Collection)builder.extensionElements);
        if (this.type == Type.form) {
            FormFieldRegistry.register(this);
        }
    }

    public Type getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getInstructions() {
        return this.instructions;
    }

    public ReportedData getReportedData() {
        return this.reportedData;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public List<FormField> getFields() {
        return this.fields;
    }

    public FormField getField(String string) {
        return this.fieldsMap.get(string);
    }

    public boolean hasField(String string) {
        return this.fieldsMap.containsKey(string);
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public List<Element> getExtensionElements() {
        return this.extensionElements;
    }

    public String getFormType() {
        TextSingleFormField textSingleFormField = this.getHiddenFormTypeField();
        if (textSingleFormField == null) {
            return null;
        }
        return textSingleFormField.getFirstValue();
    }

    public TextSingleFormField getHiddenFormTypeField() {
        FormField formField = this.getField("FORM_TYPE");
        if (formField == null) {
            return null;
        }
        return formField.asHiddenFormTypeFieldIfPossible();
    }

    public boolean hasHiddenFormTypeField() {
        return this.getHiddenFormTypeField() != null;
    }

    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder xmlStringBuilder = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
        xmlStringBuilder.attribute("type", (Enum)this.getType());
        xmlStringBuilder.rightAngleBracket();
        xmlEnvironment = xmlStringBuilder.getXmlEnvironment();
        xmlStringBuilder.optElement("title", this.getTitle());
        for (String object : this.getInstructions()) {
            xmlStringBuilder.element("instructions", object);
        }
        xmlStringBuilder.optElement((Element)this.getReportedData());
        xmlStringBuilder.append(this.getItems());
        boolean bl = this.getType() != Type.submit;
        for (FormField formField : this.getFields()) {
            xmlStringBuilder.append(formField.toXML(xmlEnvironment, bl));
        }
        xmlStringBuilder.append(this.getExtensionElements());
        xmlStringBuilder.closeElement((NamedElement)this);
        return xmlStringBuilder;
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    public static DataForm from(StanzaView stanzaView) {
        return DataForm.from(stanzaView, null);
    }

    public static DataForm from(StanzaView stanzaView, String string) {
        if (string == null) {
            return (DataForm)stanzaView.getExtension(DataForm.class);
        }
        List list = stanzaView.getExtensions(DataForm.class);
        return DataForm.from(list, string);
    }

    public static DataForm from(Collection<DataForm> collection, String string) {
        for (DataForm dataForm : collection) {
            if (!string.equals(dataForm.getFormType())) continue;
            return dataForm;
        }
        return null;
    }

    public static DataForm remove(Collection<DataForm> collection, String string) {
        Iterator<DataForm> iterator = collection.iterator();
        while (iterator.hasNext()) {
            DataForm dataForm = iterator.next();
            if (!string.equals(dataForm.getFormType())) continue;
            iterator.remove();
            return dataForm;
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Type type) {
        return new Builder(type);
    }

    public static class Item
    implements ExtensionElement {
        public static final String ELEMENT = "item";
        public static final QName QNAME = new QName("jabber:x:data", "item");
        private final List<? extends FormField> fields;

        public Item(List<? extends FormField> list) {
            this.fields = Collections.unmodifiableList(list);
        }

        public String getElementName() {
            return ELEMENT;
        }

        public String getNamespace() {
            return DataForm.NAMESPACE;
        }

        public List<? extends FormField> getFields() {
            return this.fields;
        }

        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            xmlStringBuilder.rightAngleBracket();
            xmlStringBuilder.append(this.getFields());
            xmlStringBuilder.closeElement((NamedElement)this);
            return xmlStringBuilder;
        }
    }

    public static class ReportedData
    implements ExtensionElement {
        public static final String ELEMENT = "reported";
        public static final QName QNAME = new QName("jabber:x:data", "reported");
        private final List<? extends FormField> fields;
        private Map<String, FormField> fieldMap;

        public ReportedData(List<? extends FormField> list) {
            this.fields = Collections.unmodifiableList(list);
        }

        public String getElementName() {
            return ELEMENT;
        }

        public String getNamespace() {
            return DataForm.NAMESPACE;
        }

        public List<? extends FormField> getFields() {
            return this.fields;
        }

        public FormField getField(String string) {
            if (this.fieldMap == null) {
                this.fieldMap = new HashMap<String, FormField>(this.fields.size());
                for (FormField formField : this.fields) {
                    String string2 = formField.getFieldName();
                    this.fieldMap.put(string2, formField);
                }
            }
            return this.fieldMap.get(string);
        }

        public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
            XmlStringBuilder xmlStringBuilder = new XmlStringBuilder((FullyQualifiedElement)this, xmlEnvironment);
            xmlStringBuilder.rightAngleBracket();
            xmlStringBuilder.append(this.getFields());
            xmlStringBuilder.closeElement((NamedElement)this);
            return xmlStringBuilder;
        }
    }

    public static final class Builder {
        private Type type;
        private String title;
        private List<String> instructions;
        private ReportedData reportedData;
        private List<Item> items;
        private List<FormField> fields = new ArrayList<FormField>();
        private Map<String, FormField> fieldsMap = new HashMap<String, FormField>();
        private List<Element> extensionElements;

        private Builder() {
            this(Type.submit);
        }

        private Builder(Type type) {
            this.type = type;
        }

        private Builder(DataForm dataForm) {
            this.type = dataForm.getType();
            this.title = dataForm.getTitle();
            this.instructions = dataForm.getInstructions();
            this.reportedData = dataForm.getReportedData();
            this.items = CollectionUtil.newListWith(dataForm.getItems());
            this.fields = CollectionUtil.newListWith(dataForm.getFields());
            this.fieldsMap = new HashMap<String, FormField>(dataForm.fieldsMap);
            this.extensionElements = CollectionUtil.newListWith(dataForm.getExtensionElements());
        }

        private void orderFields() {
            Iterator<FormField> iterator = this.fields.iterator();
            if (!iterator.hasNext()) {
                return;
            }
            TextSingleFormField textSingleFormField = iterator.next().asHiddenFormTypeFieldIfPossible();
            if (textSingleFormField != null) {
                return;
            }
            while (iterator.hasNext()) {
                textSingleFormField = iterator.next().asHiddenFormTypeFieldIfPossible();
                if (textSingleFormField == null) continue;
                iterator.remove();
                this.fields.add(0, textSingleFormField);
                break;
            }
        }

        @Deprecated
        public Builder setType(Type type) {
            this.type = (Type)((Object)Objects.requireNonNull((Object)((Object)type)));
            return this;
        }

        public Builder setTitle(String string) {
            this.title = string;
            return this;
        }

        public Builder addField(FormField formField) {
            String string = formField.getFieldName();
            if (string != null) {
                if (this.fieldsMap.containsKey(string)) {
                    throw new IllegalArgumentException("A field with the name " + string + " already exists");
                }
                this.fieldsMap.put(string, formField);
            }
            this.fields.add(formField);
            return this;
        }

        public Builder addFields(Collection<? extends FormField> collection) {
            String string;
            for (FormField formField : collection) {
                string = formField.getFieldName();
                if (!this.fieldsMap.containsKey(string)) continue;
                throw new IllegalArgumentException("A field with the name " + string + " already exists");
            }
            for (FormField formField : collection) {
                string = formField.getFieldName();
                if (string != null) {
                    this.fieldsMap.put(string, formField);
                }
                this.fields.add(formField);
            }
            return this;
        }

        public Builder removeField(String string) {
            FormField formField = this.fieldsMap.remove(string);
            if (formField != null) {
                this.fields.remove(formField);
            }
            return this;
        }

        public Builder setFormType(String string) {
            TextSingleFormField textSingleFormField = FormField.buildHiddenFormType(string);
            return this.addField(textSingleFormField);
        }

        public Builder setInstructions(String string) {
            return this.setInstructions(StringUtils.splitLinesPortable((String)string));
        }

        public Builder setInstructions(List<String> list) {
            this.instructions = list;
            return this;
        }

        public Builder addInstruction(String string) {
            if (this.instructions == null) {
                this.instructions = new ArrayList<String>();
            }
            this.instructions.add(string);
            return this;
        }

        public Builder addItem(Item item) {
            if (this.items == null) {
                this.items = new ArrayList<Item>();
            }
            this.items.add(item);
            return this;
        }

        public Builder setReportedData(ReportedData reportedData) {
            this.reportedData = reportedData;
            return this;
        }

        public Builder addExtensionElement(Element element) {
            if (this.extensionElements == null) {
                this.extensionElements = new ArrayList<Element>();
            }
            this.extensionElements.add(element);
            return this;
        }

        public DataForm build() {
            return new DataForm(this);
        }
    }

    public static enum Type {
        form,
        submit,
        cancel,
        result;


        public static Type fromString(String string) {
            return Type.valueOf(string.toLowerCase(Locale.US));
        }
    }
}

