/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdatavalidation.provider;

import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.datatypes.UInt32;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smackx.xdata.provider.FormFieldChildElementProvider;
import org.jivesoftware.smackx.xdatavalidation.packet.ValidateElement;

public class DataValidationProvider
extends FormFieldChildElementProvider<ValidateElement> {
    private static final Logger LOGGER = Logger.getLogger(DataValidationProvider.class.getName());

    /*
     * Enabled aggressive block sorting
     */
    public ValidateElement parse(XmlPullParser xmlPullParser, int n, XmlEnvironment xmlEnvironment) {
        String string = xmlPullParser.getAttributeValue("", "datatype");
        ValidateElement validateElement = null;
        ValidateElement.ListRange listRange = null;
        while (true) {
            XmlPullParser.Event event = xmlPullParser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String string2;
                    switch (string2 = xmlPullParser.getName()) {
                        case "open": {
                            validateElement = new ValidateElement.OpenValidateElement(string);
                            break block0;
                        }
                        case "basic": {
                            validateElement = new ValidateElement.BasicValidateElement(string);
                            break block0;
                        }
                        case "range": {
                            validateElement = new ValidateElement.RangeValidateElement(string, xmlPullParser.getAttributeValue("", "min"), xmlPullParser.getAttributeValue("", "max"));
                            break block0;
                        }
                        case "regex": {
                            validateElement = new ValidateElement.RegexValidateElement(string, xmlPullParser.nextText());
                            break block0;
                        }
                        case "list-range": {
                            UInt32 uInt32 = ParserUtils.getUInt32Attribute((XmlPullParser)xmlPullParser, (String)"min");
                            UInt32 uInt322 = ParserUtils.getUInt32Attribute((XmlPullParser)xmlPullParser, (String)"max");
                            if (uInt32 != null || uInt322 != null) {
                                listRange = new ValidateElement.ListRange(uInt32, uInt322);
                                break block0;
                            }
                            LOGGER.fine("Ignoring list-range element without min or max attribute");
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (xmlPullParser.getDepth() != n) break;
                    if (validateElement == null) {
                        validateElement = new ValidateElement.BasicValidateElement(string);
                    }
                    validateElement.setListRange(listRange);
                    return validateElement;
                }
            }
        }
    }

    @Override
    public QName getQName() {
        return ValidateElement.QNAME;
    }
}

