/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslInternalSession;
import io.netty.handler.ssl.OpenSslSessionContext;
import io.netty.handler.ssl.OpenSslSessionId;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.internal.tcnative.SSLSession;
import io.netty.internal.tcnative.SSLSessionCache;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.SystemPropertyUtil;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.cert.X509Certificate;

class OpenSslSessionCache
implements SSLSessionCache {
    private static final OpenSslInternalSession[] EMPTY_SESSIONS = new OpenSslInternalSession[0];
    private static final int DEFAULT_CACHE_SIZE;
    private final OpenSslEngineMap engineMap;
    private final Map<OpenSslSessionId, NativeSslSession> sessions = new LinkedHashMap<OpenSslSessionId, NativeSslSession>(){
        private static final long serialVersionUID = -7773696788135734448L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<OpenSslSessionId, NativeSslSession> entry) {
            int n = OpenSslSessionCache.this.maximumCacheSize.get();
            if (n >= 0 && this.size() > n) {
                OpenSslSessionCache.this.removeSessionWithId(entry.getKey());
            }
            return false;
        }
    };
    private final AtomicInteger maximumCacheSize = new AtomicInteger(DEFAULT_CACHE_SIZE);
    private final AtomicInteger sessionTimeout = new AtomicInteger(300);
    private int sessionCounter;

    OpenSslSessionCache(OpenSslEngineMap openSslEngineMap) {
        this.engineMap = openSslEngineMap;
    }

    final void setSessionTimeout(int n) {
        int n2 = this.sessionTimeout.getAndSet(n);
        if (n2 > n) {
            this.clear();
        }
    }

    final int getSessionTimeout() {
        return this.sessionTimeout.get();
    }

    protected boolean sessionCreated(NativeSslSession nativeSslSession) {
        return true;
    }

    protected void sessionRemoved(NativeSslSession nativeSslSession) {
    }

    final void setSessionCacheSize(int n) {
        long l = this.maximumCacheSize.getAndSet(n);
        if (l > (long)n || n == 0) {
            this.clear();
        }
    }

    final int getSessionCacheSize() {
        return this.maximumCacheSize.get();
    }

    private void expungeInvalidSessions() {
        NativeSslSession nativeSslSession;
        if (this.sessions.isEmpty()) {
            return;
        }
        long l = System.currentTimeMillis();
        Iterator<Map.Entry<OpenSslSessionId, NativeSslSession>> iterator = this.sessions.entrySet().iterator();
        while (iterator.hasNext() && !(nativeSslSession = iterator.next().getValue()).isValid(l)) {
            iterator.remove();
            this.notifyRemovalAndFree(nativeSslSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sessionCreated(long l, long l2) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.engineMap.get(l);
        if (referenceCountedOpenSslEngine == null) {
            return false;
        }
        OpenSslInternalSession openSslInternalSession = (OpenSslInternalSession)referenceCountedOpenSslEngine.getSession();
        NativeSslSession nativeSslSession = new NativeSslSession(l2, referenceCountedOpenSslEngine.getPeerHost(), referenceCountedOpenSslEngine.getPeerPort(), (long)this.getSessionTimeout() * 1000L, openSslInternalSession.keyValueStorage());
        openSslInternalSession.setSessionDetails(nativeSslSession.creationTime, nativeSslSession.lastAccessedTime, nativeSslSession.sessionId(), nativeSslSession.keyValueStorage);
        OpenSslSessionCache openSslSessionCache = this;
        synchronized (openSslSessionCache) {
            if (++this.sessionCounter == 255) {
                this.sessionCounter = 0;
                this.expungeInvalidSessions();
            }
            if (!this.sessionCreated(nativeSslSession)) {
                nativeSslSession.close();
                return false;
            }
            NativeSslSession nativeSslSession2 = this.sessions.put(nativeSslSession.sessionId(), nativeSslSession);
            if (nativeSslSession2 != null) {
                this.notifyRemovalAndFree(nativeSslSession2);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getSession(long l, byte[] byArray) {
        NativeSslSession nativeSslSession;
        OpenSslSessionId openSslSessionId = new OpenSslSessionId(byArray);
        Object object = this;
        synchronized (object) {
            nativeSslSession = this.sessions.get(openSslSessionId);
            if (nativeSslSession == null) {
                return -1L;
            }
            if (!nativeSslSession.isValid() || !nativeSslSession.upRef()) {
                this.removeSessionWithId(nativeSslSession.sessionId());
                return -1L;
            }
            if (nativeSslSession.shouldBeSingleUse()) {
                this.removeSessionWithId(nativeSslSession.sessionId());
            }
        }
        nativeSslSession.setLastAccessedTime(System.currentTimeMillis());
        object = this.engineMap.get(l);
        if (object != null) {
            OpenSslInternalSession openSslInternalSession = (OpenSslInternalSession)((ReferenceCountedOpenSslEngine)object).getSession();
            openSslInternalSession.setSessionDetails(nativeSslSession.getCreationTime(), nativeSslSession.getLastAccessedTime(), nativeSslSession.sessionId(), nativeSslSession.keyValueStorage);
        }
        return nativeSslSession.session();
    }

    boolean setSession(long l, OpenSslInternalSession openSslInternalSession, String string, int n) {
        return false;
    }

    final synchronized void removeSessionWithId(OpenSslSessionId openSslSessionId) {
        NativeSslSession nativeSslSession = this.sessions.remove(openSslSessionId);
        if (nativeSslSession != null) {
            this.notifyRemovalAndFree(nativeSslSession);
        }
    }

    final synchronized boolean containsSessionWithId(OpenSslSessionId openSslSessionId) {
        return this.sessions.containsKey(openSslSessionId);
    }

    private void notifyRemovalAndFree(NativeSslSession nativeSslSession) {
        this.sessionRemoved(nativeSslSession);
        nativeSslSession.free();
    }

    final synchronized OpenSslInternalSession getSession(OpenSslSessionId openSslSessionId) {
        NativeSslSession nativeSslSession = this.sessions.get(openSslSessionId);
        if (nativeSslSession != null && !nativeSslSession.isValid()) {
            this.removeSessionWithId(nativeSslSession.sessionId());
            return null;
        }
        return nativeSslSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<OpenSslSessionId> getIds() {
        OpenSslInternalSession[] openSslInternalSessionArray;
        Object object = this;
        synchronized (object) {
            openSslInternalSessionArray = this.sessions.values().toArray(EMPTY_SESSIONS);
        }
        object = new ArrayList(openSslInternalSessionArray.length);
        for (OpenSslInternalSession openSslInternalSession : openSslInternalSessionArray) {
            if (!openSslInternalSession.isValid()) continue;
            object.add(openSslInternalSession.sessionId());
        }
        return object;
    }

    synchronized void clear() {
        Iterator<Map.Entry<OpenSslSessionId, NativeSslSession>> iterator = this.sessions.entrySet().iterator();
        while (iterator.hasNext()) {
            NativeSslSession nativeSslSession = iterator.next().getValue();
            iterator.remove();
            this.notifyRemovalAndFree(nativeSslSession);
        }
    }

    static {
        int n = SystemPropertyUtil.getInt((String)"javax.net.ssl.sessionCacheSize", (int)20480);
        DEFAULT_CACHE_SIZE = n >= 0 ? n : 20480;
    }

    static final class NativeSslSession
    implements OpenSslInternalSession {
        static final ResourceLeakDetector<NativeSslSession> LEAK_DETECTOR = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(NativeSslSession.class);
        private final ResourceLeakTracker<NativeSslSession> leakTracker;
        final Map<String, Object> keyValueStorage;
        private final long session;
        private final String peerHost;
        private final int peerPort;
        private final OpenSslSessionId id;
        private final long timeout;
        private final long creationTime;
        private volatile long lastAccessedTime;
        private volatile boolean valid;
        private boolean freed;

        NativeSslSession(long l, String string, int n, long l2, Map<String, Object> map) {
            this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
            this.valid = true;
            this.session = l;
            this.peerHost = string;
            this.peerPort = n;
            this.timeout = l2;
            this.id = new OpenSslSessionId(SSLSession.getSessionId((long)l));
            this.keyValueStorage = map;
            this.leakTracker = LEAK_DETECTOR.track((Object)this);
        }

        @Override
        public Map<String, Object> keyValueStorage() {
            return this.keyValueStorage;
        }

        @Override
        public void prepareHandshake() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSessionDetails(long l, long l2, OpenSslSessionId openSslSessionId, Map<String, Object> map) {
            throw new UnsupportedOperationException();
        }

        boolean shouldBeSingleUse() {
            assert (!this.freed);
            return SSLSession.shouldBeSingleUse((long)this.session);
        }

        long session() {
            assert (!this.freed);
            return this.session;
        }

        boolean upRef() {
            assert (!this.freed);
            return SSLSession.upRef((long)this.session);
        }

        synchronized void free() {
            this.close();
            SSLSession.free((long)this.session);
        }

        void close() {
            assert (!this.freed);
            this.freed = true;
            this.invalidate();
            if (this.leakTracker != null) {
                this.leakTracker.close((Object)this);
            }
        }

        @Override
        public OpenSslSessionId sessionId() {
            return this.id;
        }

        boolean isValid(long l) {
            return this.creationTime + this.timeout >= l && this.valid;
        }

        @Override
        public void setLocalCertificate(Certificate[] certificateArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public OpenSslSessionContext getSessionContext() {
            return null;
        }

        @Override
        public void tryExpandApplicationBufferSize(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void handshakeFinished(byte[] byArray, String string, String string2, byte[] byArray2, byte[][] byArray3, long l, long l2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getId() {
            return this.id.cloneBytes();
        }

        @Override
        public long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public void setLastAccessedTime(long l) {
            this.lastAccessedTime = l;
        }

        @Override
        public long getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        @Override
        public void invalidate() {
            this.valid = false;
        }

        @Override
        public boolean isValid() {
            return this.isValid(System.currentTimeMillis());
        }

        @Override
        public void putValue(String string, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getValue(String string) {
            return null;
        }

        @Override
        public void removeValue(String string) {
        }

        @Override
        public String[] getValueNames() {
            return EmptyArrays.EMPTY_STRINGS;
        }

        @Override
        public Certificate[] getPeerCertificates() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPeerCertificates() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Certificate[] getLocalCertificates() {
            throw new UnsupportedOperationException();
        }

        @Override
        public X509Certificate[] getPeerCertificateChain() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Principal getPeerPrincipal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Principal getLocalPrincipal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCipherSuite() {
            return null;
        }

        @Override
        public String getProtocol() {
            return null;
        }

        @Override
        public String getPeerHost() {
            return this.peerHost;
        }

        @Override
        public int getPeerPort() {
            return this.peerPort;
        }

        @Override
        public int getPacketBufferSize() {
            return ReferenceCountedOpenSslEngine.MAX_RECORD_SIZE;
        }

        @Override
        public int getApplicationBufferSize() {
            return ReferenceCountedOpenSslEngine.MAX_PLAINTEXT_LENGTH;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof OpenSslInternalSession)) {
                return false;
            }
            OpenSslInternalSession openSslInternalSession = (OpenSslInternalSession)object;
            return this.id.equals(openSslInternalSession.sessionId());
        }
    }
}

