/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.QuickSelect;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u0002H\u00070\u000bj\b\u0012\u0004\u0012\u0002H\u0007`\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u000eJA\u0010\u000f\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u0002H\u00070\u000bj\b\u0012\u0004\u0012\u0002H\u0007`\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u000eJG\u0010\u0010\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u0002H\u00070\u000bj\b\u0012\u0004\u0012\u0002H\u0007`\f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0012JG\u0010\u0013\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u0002H\u00070\u000bj\b\u0012\u0004\u0012\u0002H\u0007`\f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldorkbox/collections/Select;", "", "()V", "quickSelect", "Ldorkbox/collections/QuickSelect;", "fastMax", "", "T", "items", "", "comp", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "size", "([Ljava/lang/Object;Ljava/util/Comparator;I)I", "fastMin", "select", "kthLowest", "([Ljava/lang/Object;Ljava/util/Comparator;II)Ljava/lang/Object;", "selectIndex", "([Ljava/lang/Object;Ljava/util/Comparator;II)I", "Companion", "Collections"})
public final class Select {
    public static final Companion Companion = new Companion(null);
    private QuickSelect<?> quickSelect;
    public static final String version = "2.8";
    private static Select instance;

    public final <T> T select(T[] TArray, Comparator<T> comparator, int n, int n2) {
        Intrinsics.checkNotNullParameter(TArray, (String)"");
        Intrinsics.checkNotNullParameter(comparator, (String)"");
        int n3 = this.selectIndex(TArray, comparator, n, n2);
        return TArray[n3];
    }

    public final <T> int selectIndex(T[] TArray, Comparator<T> comparator, int n, int n2) {
        Intrinsics.checkNotNullParameter(TArray, (String)"");
        Intrinsics.checkNotNullParameter(comparator, (String)"");
        if (n2 < 1) {
            throw new RuntimeException("cannot select from empty array (size < 1)");
        }
        if (n > n2) {
            throw new RuntimeException("Kth rank is larger than size. k: " + n + ", size: " + n2);
        }
        int n3 = 0;
        if (n == 1) {
            n3 = this.fastMin(TArray, comparator, n2);
        } else if (n == n2) {
            n3 = this.fastMax(TArray, comparator, n2);
        } else {
            if (this.quickSelect == null) {
                this.quickSelect = new QuickSelect();
            }
            QuickSelect<?> quickSelect = this.quickSelect;
            Intrinsics.checkNotNull(quickSelect);
            QuickSelect<?> quickSelect2 = quickSelect;
            n3 = quickSelect2.select(TArray, comparator, n, n2);
        }
        return n3;
    }

    private final <T> int fastMin(T[] TArray, Comparator<T> comparator, int n) {
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            int n3 = comparator.compare(TArray[i], TArray[n2]);
            if (n3 >= 0) continue;
            n2 = i;
        }
        return n2;
    }

    private final <T> int fastMax(T[] TArray, Comparator<T> comparator, int n) {
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            int n3 = comparator.compare(TArray[i], TArray[n2]);
            if (n3 <= 0) continue;
            n2 = i;
        }
        return n2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ldorkbox/collections/Select$Companion;", "", "()V", "instance", "Ldorkbox/collections/Select;", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public final Select instance() {
            if (instance == null) {
                instance = new Select();
            }
            Select select = instance;
            Intrinsics.checkNotNull((Object)select);
            return select;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

