/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.BlendMode;
import org.jetbrains.skia.ColorFilterKt;
import org.jetbrains.skia.ColorMatrix;
import org.jetbrains.skia.InversionMode;
import org.jetbrains.skia.impl.InteropScope;
import org.jetbrains.skia.impl.Library;
import org.jetbrains.skia.impl.NativeKt;
import org.jetbrains.skia.impl.Native_jvmKt;
import org.jetbrains.skia.impl.RefCnt;
import org.jetbrains.skia.impl.Stats;
import org.jetbrains.skia.impl.theScope;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0015\b\u0010\u0012\n\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0010\u0012\n\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\t\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/skia/ColorFilter;", "Lorg/jetbrains/skia/impl/RefCnt;", "ptr", "Lorg/jetbrains/skia/impl/NativePointer;", "", "<init>", "(J)V", "allowClose", "", "(JZ)V", "Companion", "skiko"})
public final class ColorFilter
extends RefCnt {
    public static final Companion Companion = new Companion(null);
    private static final ColorFilter sRGBToLinearGamma;
    private static final ColorFilter luma;

    public ColorFilter(long l) {
        super(l);
    }

    public ColorFilter(long l, boolean bl) {
        super(l, bl);
    }

    static {
        Library.Companion.staticLoad();
        sRGBToLinearGamma = new ColorFilter(ColorFilterKt.access$_nGetSRGBToLinearGamma(), false);
        luma = new ColorFilter(ColorFilterKt.access$_nGetLuma(), false);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\"\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nJ\u001e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0015J\u000e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 J.\u0010!\u001a\u00020\u00052\b\u0010\"\u001a\u0004\u0018\u00010 2\b\u0010#\u001a\u0004\u0018\u00010 2\b\u0010$\u001a\u0004\u0018\u00010 2\b\u0010%\u001a\u0004\u0018\u00010 J\u000e\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(R\u0011\u0010)\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010+\u00a8\u0006."}, d2={"Lorg/jetbrains/skia/ColorFilter$Companion;", "", "<init>", "()V", "makeComposed", "Lorg/jetbrains/skia/ColorFilter;", "outer", "inner", "makeBlend", "color", "", "mode", "Lorg/jetbrains/skia/BlendMode;", "makeMatrix", "matrix", "Lorg/jetbrains/skia/ColorMatrix;", "makeHSLAMatrix", "makeLerp", "dst", "src", "t", "", "makeLighting", "colorMul", "colorAdd", "makeHighContrast", "grayscale", "", "Lorg/jetbrains/skia/InversionMode;", "contrast", "makeTable", "table", "", "makeTableARGB", "a", "r", "g", "b", "makeOverdraw", "colors", "", "sRGBToLinearGamma", "getSRGBToLinearGamma", "()Lorg/jetbrains/skia/ColorFilter;", "luma", "getLuma", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final ColorFilter makeComposed(ColorFilter colorFilter, ColorFilter colorFilter2) {
            ColorFilter colorFilter3;
            try {
                Stats.INSTANCE.onNativeCall();
                colorFilter3 = new ColorFilter(ColorFilterKt.access$_nMakeComposed(NativeKt.getPtr(colorFilter), NativeKt.getPtr(colorFilter2)));
            }
            finally {
                Native_jvmKt.reachabilityBarrier(colorFilter);
                Native_jvmKt.reachabilityBarrier(colorFilter2);
            }
            return colorFilter3;
        }

        public final ColorFilter makeBlend(int n, BlendMode blendMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)blendMode), (String)"");
            Stats.INSTANCE.onNativeCall();
            return new ColorFilter(ColorFilterKt.access$_nMakeBlend(n, blendMode.ordinal()));
        }

        public final ColorFilter makeMatrix(ColorMatrix colorMatrix) {
            Intrinsics.checkNotNullParameter((Object)colorMatrix, (String)"");
            Stats.INSTANCE.onNativeCall();
            boolean bl = false;
            InteropScope interopScope = theScope.INSTANCE;
            boolean bl2 = false;
            long l = ColorFilterKt.access$_nMakeMatrix(interopScope.toInterop(colorMatrix.getMat()));
            return new ColorFilter(l);
        }

        public final ColorFilter makeHSLAMatrix(ColorMatrix colorMatrix) {
            Intrinsics.checkNotNullParameter((Object)colorMatrix, (String)"");
            Stats.INSTANCE.onNativeCall();
            boolean bl = false;
            InteropScope interopScope = theScope.INSTANCE;
            boolean bl2 = false;
            long l = ColorFilterKt.access$_nMakeHSLAMatrix(interopScope.toInterop(colorMatrix.getMat()));
            return new ColorFilter(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final ColorFilter makeLerp(ColorFilter colorFilter, ColorFilter colorFilter2, float f) {
            ColorFilter colorFilter3;
            try {
                colorFilter3 = new ColorFilter(ColorFilterKt.access$_nMakeLerp(f, NativeKt.getPtr(colorFilter), NativeKt.getPtr(colorFilter2)));
            }
            finally {
                Native_jvmKt.reachabilityBarrier(colorFilter);
                Native_jvmKt.reachabilityBarrier(colorFilter2);
            }
            return colorFilter3;
        }

        public final ColorFilter makeLighting(int n, int n2) {
            return new ColorFilter(ColorFilterKt.access$_nMakeLighting(n, n2));
        }

        public final ColorFilter makeHighContrast(boolean bl, InversionMode inversionMode, float f) {
            Intrinsics.checkNotNullParameter((Object)((Object)inversionMode), (String)"");
            return new ColorFilter(ColorFilterKt.access$_nMakeHighContrast(bl, inversionMode.ordinal(), f));
        }

        public final ColorFilter makeTable(byte[] byArray) {
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"");
            if (!(byArray.length == 256)) {
                boolean bl = false;
                String string = "Expected 256 elements, got " + byArray.length;
                throw new IllegalArgumentException(string.toString());
            }
            boolean bl = false;
            InteropScope interopScope = theScope.INSTANCE;
            boolean bl2 = false;
            long l = ColorFilterKt.access$_nMakeTable(interopScope.toInterop(byArray));
            return new ColorFilter(l);
        }

        public final ColorFilter makeTableARGB(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
            if (!(byArray == null || byArray.length == 256)) {
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder().append("Expected 256 elements in a[], got ");
                Intrinsics.checkNotNull((Object)byArray);
                String string = stringBuilder.append(byArray.length).toString();
                throw new IllegalArgumentException(string.toString());
            }
            if (!(byArray2 == null || byArray2.length == 256)) {
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder().append("Expected 256 elements in r[], got ");
                Intrinsics.checkNotNull((Object)byArray2);
                String string = stringBuilder.append(byArray2.length).toString();
                throw new IllegalArgumentException(string.toString());
            }
            if (!(byArray3 == null || byArray3.length == 256)) {
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder().append("Expected 256 elements in g[], got ");
                Intrinsics.checkNotNull((Object)byArray3);
                String string = stringBuilder.append(byArray3.length).toString();
                throw new IllegalArgumentException(string.toString());
            }
            if (!(byArray4 == null || byArray4.length == 256)) {
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder().append("Expected 256 elements in b[], got ");
                Intrinsics.checkNotNull((Object)byArray4);
                String string = stringBuilder.append(byArray4.length).toString();
                throw new IllegalArgumentException(string.toString());
            }
            boolean bl = false;
            InteropScope interopScope = theScope.INSTANCE;
            boolean bl2 = false;
            return new ColorFilter(ColorFilterKt.access$_nMakeTableARGB(interopScope.toInterop(byArray), interopScope.toInterop(byArray2), interopScope.toInterop(byArray3), interopScope.toInterop(byArray4)));
        }

        public final ColorFilter makeOverdraw(int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"");
            if (!(nArray.length == 6)) {
                boolean bl = false;
                String string = "Expected 6 elements, got " + nArray.length;
                throw new IllegalArgumentException(string.toString());
            }
            return new ColorFilter(ColorFilterKt.access$_nMakeOverdraw(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]));
        }

        public final ColorFilter getSRGBToLinearGamma() {
            return sRGBToLinearGamma;
        }

        public final ColorFilter getLuma() {
            return luma;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

