/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.skia.RRectKt;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.impl.InteropScope;
import org.jetbrains.skia.impl.theScope;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/skia/RRect;", "Lorg/jetbrains/skia/Rect;", "l", "", "t", "r", "b", "radii", "", "<init>", "(FFFF[F)V", "getRadii", "()[F", "inflate", "spread", "toString", "", "equals", "", "other", "", "hashCode", "", "Companion", "skiko"})
public final class RRect
extends Rect {
    public static final Companion Companion = new Companion(null);
    private final float[] radii;

    public RRect(float f, float f2, float f3, float f4, float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
        super(f, f2, f3, f4);
        this.radii = fArray;
    }

    public final float[] getRadii() {
        return this.radii;
    }

    @Override
    public Rect inflate(float f) {
        Rect rect;
        boolean bl = true;
        int n = this.radii.length;
        for (int i = 0; i < n; ++i) {
            if (!(this.radii[i] + f >= 0.0f)) continue;
            bl = false;
            break;
        }
        if (bl) {
            rect = Rect.Companion.makeLTRB(this.getLeft() - f, this.getTop() - f, Math.max(this.getLeft() - f, this.getRight() + f), Math.max(this.getTop() - f, this.getBottom() + f));
        } else {
            float[] fArray = Arrays.copyOf(this.radii, this.radii.length);
            Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"");
            float[] fArray2 = fArray;
            int n2 = fArray2.length;
            for (n = 0; n < n2; ++n) {
                fArray2[n] = Math.max(0.0f, fArray2[n] + f);
            }
            rect = new RRect(this.getLeft() - f, this.getTop() - f, Math.max(this.getLeft() - f, this.getRight() + f), Math.max(this.getTop() - f, this.getBottom() + f), fArray2);
        }
        return rect;
    }

    @Override
    public String toString() {
        return "RRect(_left=" + this.getLeft() + ", _top=" + this.getTop() + ", _right=" + this.getRight() + ", _bottom=" + this.getBottom() + ", _radii=" + ArraysKt.joinToString$default((float[])this.radii, null, null, null, (int)0, null, null, (int)63, null) + ')';
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RRect)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        return this.radii.length == ((RRect)object).radii.length ? Arrays.equals(this.radii, ((RRect)object).radii) : Arrays.equals(RRectKt.access$normalizeRadii(this.radii), RRectKt.access$normalizeRadii(((RRect)object).radii));
    }

    @Override
    public int hashCode() {
        int n = 59;
        int n2 = super.hashCode();
        n2 = n2 * n + Arrays.hashCode(this.radii);
        return n2;
    }

    @JvmStatic
    public static final RRect makeLTRB(float f, float f2, float f3, float f4, float f5) {
        return Companion.makeLTRB(f, f2, f3, f4, f5);
    }

    @JvmStatic
    public static final RRect makeLTRB(float f, float f2, float f3, float f4, float f5, float f6) {
        return Companion.makeLTRB(f, f2, f3, f4, f5, f6);
    }

    @JvmStatic
    public static final RRect makeLTRB(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        return Companion.makeLTRB(f, f2, f3, f4, f5, f6, f7, f8);
    }

    @JvmStatic
    public static final RRect makeNinePatchLTRB(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        return Companion.makeNinePatchLTRB(f, f2, f3, f4, f5, f6, f7, f8);
    }

    @JvmStatic
    public static final RRect makeComplexLTRB(float f, float f2, float f3, float f4, float[] fArray) {
        return Companion.makeComplexLTRB(f, f2, f3, f4, fArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0010\u0014\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0007J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0007JH\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0007JH\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0007J0\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J&\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J&\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J.\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007J6\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007JF\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007JF\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007J.\u0010 \u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019J&\u0010!\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007J&\u0010\"\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007J0\u0010#\u001a\u00020\u00052!\u0010$\u001a\u001d\u0012\u0004\u0012\u00020&\u0012\b\u0012\u00060(j\u0002`'\u0012\u0004\u0012\u00020)0%\u00a2\u0006\u0002\b*H\u0000\u00a2\u0006\u0002\b+J'\u0010,\u001a\u0004\u0018\u00010\u00052\u0016\u0010$\u001a\u0012\u0012\b\u0012\u00060(j\u0002`'\u0012\u0004\u0012\u00020.0-H\u0000\u00a2\u0006\u0002\b/\u00a8\u00060"}, d2={"Lorg/jetbrains/skia/RRect$Companion;", "", "<init>", "()V", "makeLTRB", "Lorg/jetbrains/skia/RRect;", "l", "", "t", "r", "b", "radius", "xRad", "yRad", "tlRad", "trRad", "brRad", "blRad", "makeNinePatchLTRB", "lRad", "tRad", "rRad", "bRad", "makeComplexLTRB", "radii", "", "makeOvalLTRB", "makePillLTRB", "makeXYWH", "w", "h", "makeNinePatchXYWH", "makeComplexXYWH", "makeOvalXYWH", "makePillXYWH", "fromInteropPointer", "block", "Lkotlin/Function2;", "Lorg/jetbrains/skia/impl/InteropScope;", "Lorg/jetbrains/skia/impl/InteropPointer;", "Ljava/lang/Object;", "", "Lkotlin/ExtensionFunctionType;", "fromInteropPointer$skiko", "fromInteropPointerNullable", "Lkotlin/Function1;", "", "fromInteropPointerNullable$skiko", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final RRect makeLTRB(float f, float f2, float f3, float f4, float f5) {
            float[] fArray = new float[]{f5};
            return new RRect(f, f2, f3, f4, fArray);
        }

        @JvmStatic
        public final RRect makeLTRB(float f, float f2, float f3, float f4, float f5, float f6) {
            float[] fArray = new float[]{f5, f6};
            return new RRect(f, f2, f3, f4, fArray);
        }

        @JvmStatic
        public final RRect makeLTRB(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            float[] fArray = new float[]{f5, f6, f7, f8};
            return new RRect(f, f2, f3, f4, fArray);
        }

        @JvmStatic
        public final RRect makeNinePatchLTRB(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            float[] fArray = new float[]{f5, f6, f7, f6, f7, f8, f5, f8};
            return new RRect(f, f2, f3, f4, fArray);
        }

        @JvmStatic
        public final RRect makeComplexLTRB(float f, float f2, float f3, float f4, float[] fArray) {
            Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
            return new RRect(f, f2, f3, f4, fArray);
        }

        public final RRect makeOvalLTRB(float f, float f2, float f3, float f4) {
            float[] fArray = new float[]{Math.abs(f3 - f) / 2.0f, Math.abs(f4 - f2) / 2.0f};
            return new RRect(f, f2, f3, f4, fArray);
        }

        public final RRect makePillLTRB(float f, float f2, float f3, float f4) {
            float[] fArray = new float[]{Math.min(Math.abs(f3 - f), Math.abs(f2 - f4)) / 2.0f};
            return new RRect(f, f2, f3, f4, fArray);
        }

        public final RRect makeXYWH(float f, float f2, float f3, float f4, float f5) {
            float[] fArray = new float[]{f5};
            return new RRect(f, f2, f + f3, f2 + f4, fArray);
        }

        public final RRect makeXYWH(float f, float f2, float f3, float f4, float f5, float f6) {
            float[] fArray = new float[]{f5, f6};
            return new RRect(f, f2, f + f3, f2 + f4, fArray);
        }

        public final RRect makeXYWH(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            float[] fArray = new float[]{f5, f6, f7, f8};
            return new RRect(f, f2, f + f3, f2 + f4, fArray);
        }

        public final RRect makeNinePatchXYWH(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            float[] fArray = new float[]{f5, f6, f7, f6, f7, f8, f5, f8};
            return new RRect(f, f2, f + f3, f2 + f4, fArray);
        }

        public final RRect makeComplexXYWH(float f, float f2, float f3, float f4, float[] fArray) {
            Intrinsics.checkNotNullParameter((Object)fArray, (String)"");
            return new RRect(f, f2, f + f3, f2 + f4, fArray);
        }

        public final RRect makeOvalXYWH(float f, float f2, float f3, float f4) {
            float[] fArray = new float[]{f3 / 2.0f, f4 / 2.0f};
            return new RRect(f, f2, f + f3, f2 + f4, fArray);
        }

        public final RRect makePillXYWH(float f, float f2, float f3, float f4) {
            float[] fArray = new float[]{Math.min(f3, f4) / 2.0f};
            return new RRect(f, f2, f + f3, f2 + f4, fArray);
        }

        public final RRect fromInteropPointer$skiko(Function2<? super InteropScope, ? super Object, Unit> function2) {
            float[] fArray;
            Intrinsics.checkNotNullParameter(function2, (String)"");
            float[] fArray2 = new float[12];
            int n = 0;
            int n2 = 0;
            InteropScope interopScope = theScope.INSTANCE;
            boolean bl = false;
            Object object = interopScope.toInteropForResult(fArray2);
            function2.invoke((Object)interopScope, object);
            interopScope.fromInterop(object, fArray2);
            fArray2 = fArray = fArray2;
            n = 4;
            n2 = 12;
            return new RRect(fArray[0], fArray[1], fArray[2], fArray[3], ArraysKt.copyOfRange((float[])fArray2, (int)n, (int)n2));
        }

        public final RRect fromInteropPointerNullable$skiko(Function1<? super Object, Boolean> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"");
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = true;
            RRect rRect = this.fromInteropPointer$skiko((Function2<? super InteropScope, ? super Object, Unit>)((Function2)(arg_0, arg_1) -> Companion.fromInteropPointerNullable$lambda$0(booleanRef, function1, arg_0, arg_1)));
            return booleanRef.element ? rRect : null;
        }

        private static final Unit fromInteropPointerNullable$lambda$0(Ref.BooleanRef booleanRef, Function1 function1, InteropScope interopScope, Object object) {
            Intrinsics.checkNotNullParameter((Object)booleanRef, (String)"");
            Intrinsics.checkNotNullParameter((Object)function1, (String)"");
            Intrinsics.checkNotNullParameter((Object)interopScope, (String)"");
            Intrinsics.checkNotNullParameter((Object)object, (String)"");
            booleanRef.element = (Boolean)function1.invoke(object);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

