/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia.impl;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.skia.impl.Cleanable;
import org.jetbrains.skia.impl.Cleaner;
import org.jetbrains.skia.impl.Native;
import org.jetbrains.skia.impl.Stats;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.SkikoLoggerInterface;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00122\u00020\u00012\u00060\u0003j\u0002`\u0002:\u0002\u0011\u0012B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\r\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/skia/impl/Managed;", "Lorg/jetbrains/skia/impl/Native;", "Lkotlin/AutoCloseable;", "Ljava/lang/AutoCloseable;", "ptr", "", "finalizer", "managed", "", "<init>", "(JJZ)V", "close", "", "isClosed", "()Z", "cleanable", "Lorg/jetbrains/skia/impl/Cleanable;", "CleanerThunk", "Companion", "skiko"})
public abstract class Managed
extends Native
implements AutoCloseable {
    public static final Companion Companion = new Companion(null);
    private Cleanable cleanable;
    private static final Cleaner CLEANER = new Cleaner();

    public Managed(long l, long l2, boolean bl) {
        super(l);
        if (bl) {
            boolean bl2;
            boolean bl3 = bl2 = l != 0L;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl4 = false;
                String string = "Managed ptr is 0";
                throw new AssertionError((Object)string);
            }
            boolean bl5 = bl2 = l2 != 0L;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl6 = false;
                String string = "Managed finalizer is 0";
                throw new AssertionError((Object)string);
            }
            String string = this.getClass().getSimpleName();
            Intrinsics.checkNotNull((Object)string);
            Stats.INSTANCE.onAllocated(string);
            this.cleanable = CLEANER.register(this, new CleanerThunk(string, l, l2));
        }
    }

    public /* synthetic */ Managed(long l, long l2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(l, l2, bl);
    }

    @Override
    public void close() {
        if (0L == this.get_ptr$skiko()) {
            throw new RuntimeException("Object already closed: " + this.getClass() + ", _ptr=" + this.get_ptr$skiko());
        }
        if (this.cleanable == null) {
            throw new RuntimeException("Object is not managed in JVM, can't close(): " + this.getClass() + ", _ptr=" + this.get_ptr$skiko());
        }
        Cleanable cleanable = this.cleanable;
        Intrinsics.checkNotNull((Object)cleanable);
        cleanable.clean();
        this.cleanable = null;
        this.set_ptr$skiko(0L);
    }

    public boolean isClosed() {
        return this.get_ptr$skiko() == 0L;
    }

    @JvmStatic
    public static final native void _nInvokeFinalizer(long var0, long var2);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/skia/impl/Managed$CleanerThunk;", "Ljava/lang/Runnable;", "className", "", "ptr", "", "finalizerPtr", "<init>", "(Ljava/lang/String;JJ)V", "getClassName", "()Ljava/lang/String;", "setClassName", "(Ljava/lang/String;)V", "getPtr", "()J", "setPtr", "(J)V", "getFinalizerPtr", "setFinalizerPtr", "run", "", "skiko"})
    public static final class CleanerThunk
    implements Runnable {
        private String className;
        private long ptr;
        private long finalizerPtr;

        public CleanerThunk(String string, long l, long l2) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            this.className = string;
            this.ptr = l;
            this.finalizerPtr = l2;
        }

        public final String getClassName() {
            return this.className;
        }

        public final void setClassName(String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            this.className = string;
        }

        public final long getPtr() {
            return this.ptr;
        }

        public final void setPtr(long l) {
            this.ptr = l;
        }

        public final long getFinalizerPtr() {
            return this.finalizerPtr;
        }

        public final void setFinalizerPtr(long l) {
            this.finalizerPtr = l;
        }

        @Override
        public void run() {
            Logger logger = Logger.INSTANCE;
            boolean bl = false;
            if (logger.getLoggerImpl().isTraceEnabled()) {
                SkikoLoggerInterface skikoLoggerInterface = logger.getLoggerImpl();
                boolean bl2 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Cleaning ").append(this.className).append(' ');
                String string = Long.toString(this.ptr, CharsKt.checkRadix((int)16));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                skikoLoggerInterface.trace(stringBuilder.append(string).toString());
            }
            Stats.INSTANCE.onDeallocated(this.className);
            Stats.INSTANCE.onNativeCall();
            Companion._nInvokeFinalizer(this.finalizerPtr, this.ptr);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0087 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/skia/impl/Managed$Companion;", "", "<init>", "()V", "CLEANER", "Lorg/jetbrains/skia/impl/Cleaner;", "_nInvokeFinalizer", "", "finalizer", "", "ptr", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void _nInvokeFinalizer(long l, long l2) {
            Managed._nInvokeFinalizer(l, l2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

