/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia.skottie;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.ManagedString;
import org.jetbrains.skia.Point;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.impl.InteropScope;
import org.jetbrains.skia.impl.Library;
import org.jetbrains.skia.impl.Managed;
import org.jetbrains.skia.impl.Native;
import org.jetbrains.skia.impl.NativeKt;
import org.jetbrains.skia.impl.Native_jvmKt;
import org.jetbrains.skia.impl.Stats;
import org.jetbrains.skia.impl.theScope;
import org.jetbrains.skia.skottie.AnimationKt;
import org.jetbrains.skia.skottie.RenderFlag;
import org.jetbrains.skia.sksg.InvalidationController;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u0000 02\u00020\u0001:\u000201B\u0015\b\u0000\u0012\n\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ/\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\"\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\rJ\u0018\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\rJ\u0018\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\rJ\u0018\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018R\u0011\u0010\u001b\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0011\u0010 \u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001dR\u0011\u0010\"\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001dR\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0010\u0010(\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u001dR\u0011\u0010.\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u001d\u00a8\u00062"}, d2={"Lorg/jetbrains/skia/skottie/Animation;", "Lorg/jetbrains/skia/impl/Managed;", "ptr", "Lorg/jetbrains/skia/impl/NativePointer;", "", "<init>", "(J)V", "render", "canvas", "Lorg/jetbrains/skia/Canvas;", "offset", "Lorg/jetbrains/skia/Point;", "left", "", "top", "dst", "Lorg/jetbrains/skia/Rect;", "renderFlags", "", "Lorg/jetbrains/skia/skottie/RenderFlag;", "(Lorg/jetbrains/skia/Canvas;Lorg/jetbrains/skia/Rect;[Lorg/jetbrains/skia/skottie/RenderFlag;)Lorg/jetbrains/skia/skottie/Animation;", "seek", "t", "ic", "Lorg/jetbrains/skia/sksg/InvalidationController;", "seekFrame", "seekFrameTime", "duration", "getDuration", "()F", "fPS", "getFPS", "inPoint", "getInPoint", "outPoint", "getOutPoint", "version", "", "getVersion", "()Ljava/lang/String;", "_size", "size", "getSize", "()Lorg/jetbrains/skia/Point;", "width", "getWidth", "height", "getHeight", "Companion", "_FinalizerHolder", "skiko"})
public final class Animation
extends Managed {
    public static final Companion Companion = new Companion(null);
    private Point _size;

    public Animation(long l) {
        super(l, _FinalizerHolder.INSTANCE.getPTR(), false, 4, null);
    }

    public final Animation render(Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"");
        return this.render(canvas, Rect.Companion.makeXYWH(0.0f, 0.0f, this.getWidth(), this.getHeight()), new RenderFlag[0]);
    }

    public final Animation render(Canvas canvas, Point point) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"");
        Intrinsics.checkNotNullParameter((Object)point, (String)"");
        return this.render(canvas, point.getX(), point.getY());
    }

    public final Animation render(Canvas canvas, float f, float f2) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"");
        return this.render(canvas, Rect.Companion.makeXYWH(f, f2, this.getWidth(), this.getHeight()), new RenderFlag[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Animation render(Canvas canvas, Rect rect, RenderFlag ... renderFlagArray) {
        Animation animation;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"");
        Intrinsics.checkNotNullParameter((Object)renderFlagArray, (String)"");
        try {
            Stats.INSTANCE.onNativeCall();
            int n = 0;
            for (RenderFlag renderFlag : renderFlagArray) {
                n |= renderFlag.get_flag();
            }
            AnimationKt.access$_nRender(this.get_ptr$skiko(), NativeKt.getPtr(canvas), rect.getLeft(), rect.getTop(), rect.getRight(), rect.getBottom(), n);
            animation = this;
        }
        finally {
            Native_jvmKt.reachabilityBarrier(this);
            Native_jvmKt.reachabilityBarrier(canvas);
        }
        return animation;
    }

    public final Animation seek(float f) {
        return this.seek(f, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Animation seek(float f, InvalidationController invalidationController) {
        Animation animation;
        try {
            Stats.INSTANCE.onNativeCall();
            AnimationKt.access$_nSeek(this.get_ptr$skiko(), f, NativeKt.getPtr(invalidationController));
            animation = this;
        }
        finally {
            Native_jvmKt.reachabilityBarrier(this);
            Native_jvmKt.reachabilityBarrier(invalidationController);
        }
        return animation;
    }

    public final Animation seekFrame(float f) {
        return this.seekFrame(f, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Animation seekFrame(float f, InvalidationController invalidationController) {
        Animation animation;
        try {
            Stats.INSTANCE.onNativeCall();
            AnimationKt.access$_nSeekFrame(this.get_ptr$skiko(), f, NativeKt.getPtr(invalidationController));
            animation = this;
        }
        finally {
            Native_jvmKt.reachabilityBarrier(this);
            Native_jvmKt.reachabilityBarrier(invalidationController);
        }
        return animation;
    }

    public final Animation seekFrameTime(float f) {
        return this.seekFrameTime(f, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Animation seekFrameTime(float f, InvalidationController invalidationController) {
        Animation animation;
        try {
            Stats.INSTANCE.onNativeCall();
            AnimationKt.access$_nSeekFrameTime(this.get_ptr$skiko(), f, NativeKt.getPtr(invalidationController));
            animation = this;
        }
        finally {
            Native_jvmKt.reachabilityBarrier(this);
            Native_jvmKt.reachabilityBarrier(invalidationController);
        }
        return animation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getDuration() {
        float f;
        try {
            Stats.INSTANCE.onNativeCall();
            f = AnimationKt.access$_nGetDuration(this.get_ptr$skiko());
        }
        finally {
            Native_jvmKt.reachabilityBarrier(this);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getFPS() {
        float f;
        try {
            Stats.INSTANCE.onNativeCall();
            f = AnimationKt.access$_nGetFPS(this.get_ptr$skiko());
        }
        finally {
            Native_jvmKt.reachabilityBarrier(this);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getInPoint() {
        float f;
        try {
            Stats.INSTANCE.onNativeCall();
            f = AnimationKt.access$_nGetInPoint(this.get_ptr$skiko());
        }
        finally {
            Native_jvmKt.reachabilityBarrier(this);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getOutPoint() {
        float f;
        try {
            Stats.INSTANCE.onNativeCall();
            f = AnimationKt.access$_nGetOutPoint(this.get_ptr$skiko());
        }
        finally {
            Native_jvmKt.reachabilityBarrier(this);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getVersion() {
        String string;
        try {
            Stats.INSTANCE.onNativeCall();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            long l = AnimationKt.access$_nGetVersion(this.get_ptr$skiko());
            ManagedString managedString = new ManagedString(l, bl3);
            string = managedString.toString();
        }
        finally {
            Native_jvmKt.reachabilityBarrier(this);
        }
        return string;
    }

    public final Point getSize() {
        if (this._size == null) {
            this._size = Point.Companion.fromInteropPointer$skiko((Function2<? super InteropScope, ? super Object, Unit>)((Function2)(arg_0, arg_1) -> Animation._get_size_$lambda$1(this, arg_0, arg_1)));
        }
        Point point = this._size;
        Intrinsics.checkNotNull((Object)point);
        return point;
    }

    public final float getWidth() {
        return this.getSize().getX();
    }

    public final float getHeight() {
        return this.getSize().getY();
    }

    private static final Unit _get_size_$lambda$1(Animation animation, InteropScope interopScope, Object object) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"");
        Intrinsics.checkNotNullParameter((Object)interopScope, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        AnimationKt.access$_nGetSize(animation.get_ptr$skiko(), object);
        return Unit.INSTANCE;
    }

    static {
        Library.Companion.staticLoad();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/skia/skottie/Animation$Companion;", "", "<init>", "()V", "makeFromString", "Lorg/jetbrains/skia/skottie/Animation;", "data", "", "makeFromData", "Lorg/jetbrains/skia/Data;", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public final Animation makeFromString(String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            Stats.INSTANCE.onNativeCall();
            boolean bl = false;
            InteropScope interopScope = theScope.INSTANCE;
            boolean bl2 = false;
            long l = AnimationKt.access$_nMakeFromString(interopScope.toInterop(string));
            if (!(l != Native.Companion.getNullPointer())) {
                boolean bl3 = false;
                String string2 = "Failed to create Animation from string=\"" + string + '\"';
                throw new IllegalArgumentException(string2.toString());
            }
            return new Animation(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Animation makeFromData(Data data) {
            long l;
            Intrinsics.checkNotNullParameter((Object)data, (String)"");
            Stats.INSTANCE.onNativeCall();
            try {
                l = AnimationKt.access$_nMakeFromData(NativeKt.getPtr(data));
            }
            finally {
                Native_jvmKt.reachabilityBarrier(data);
            }
            long l2 = l;
            if (!(l2 != Native.Companion.getNullPointer())) {
                boolean bl = false;
                String string = "Failed to create Animation from data.";
                throw new IllegalArgumentException(string.toString());
            }
            return new Animation(l2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\u00060\u0006j\u0002`\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/skia/skottie/Animation$_FinalizerHolder;", "", "<init>", "()V", "PTR", "Lorg/jetbrains/skia/impl/NativePointer;", "", "getPTR", "()J", "J", "skiko"})
    public static final class _FinalizerHolder {
        public static final _FinalizerHolder INSTANCE = new _FinalizerHolder();
        private static final long PTR = AnimationKt.access$_nGetFinalizer();

        private _FinalizerHolder() {
        }

        public final long getPTR() {
            return PTR;
        }
    }
}

