/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import java.lang.ref.Reference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.impl.NativeKt;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.context.ContextFreeContextHandler;
import org.jetbrains.skiko.redrawer.AbstractDirectSoftwareRedrawer;
import org.jetbrains.skiko.redrawer.Redrawer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0014R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/skiko/context/DirectSoftwareContextHandler;", "Lorg/jetbrains/skiko/context/ContextFreeContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "<init>", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "softwareRedrawer", "Lorg/jetbrains/skiko/redrawer/AbstractDirectSoftwareRedrawer;", "getSoftwareRedrawer", "()Lorg/jetbrains/skiko/redrawer/AbstractDirectSoftwareRedrawer;", "currentWidth", "", "currentHeight", "isSizeChanged", "", "width", "height", "initCanvas", "", "flush", "skiko"})
public final class DirectSoftwareContextHandler
extends ContextFreeContextHandler {
    private int currentWidth;
    private int currentHeight;

    public DirectSoftwareContextHandler(SkiaLayer skiaLayer) {
        Intrinsics.checkNotNullParameter((Object)skiaLayer, (String)"");
        super(skiaLayer);
    }

    private final AbstractDirectSoftwareRedrawer getSoftwareRedrawer() {
        Redrawer redrawer = this.getLayer().getRedrawer$skiko();
        Intrinsics.checkNotNull((Object)redrawer);
        return (AbstractDirectSoftwareRedrawer)redrawer;
    }

    private final boolean isSizeChanged(int n2, int n3) {
        if (n2 != this.currentWidth || n3 != this.currentHeight) {
            this.currentWidth = n2;
            this.currentHeight = n3;
            return true;
        }
        return false;
    }

    @Override
    protected void initCanvas() {
        int n2;
        float f = this.getLayer().getContentScale();
        int n3 = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * f)), (int)0);
        if (this.isSizeChanged(n3, n2 = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * f)), (int)0)) || this.getSurface() == null) {
            this.disposeCanvas();
            if (n3 > 0 && n2 > 0) {
                this.getSoftwareRedrawer().resize(n3, n2);
                this.setSurface(this.getSoftwareRedrawer().acquireSurface());
                Surface surface = this.getSurface();
                Intrinsics.checkNotNull((Object)surface);
                this.setCanvas(surface.getCanvas());
            } else {
                this.setSurface(null);
                this.setCanvas(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flush() {
        Surface surface = this.getSurface();
        if (surface != null) {
            try {
                this.getSoftwareRedrawer().finishFrame(NativeKt.getPtr(surface));
            }
            finally {
                Reference.reachabilityFence(surface);
            }
        }
    }
}

