/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.Version;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingLayerPropertiesKt;
import org.jetbrains.skiko.swing.SwingRedrawer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H$J\b\u0010\u001a\u001a\u00020\u0012H\u0016J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u001c\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0004J\b\u0010\u001f\u001a\u00020\u001eH\u0014J\u0012\u0010 \u001a\u00020\u00122\b\u0010!\u001a\u0004\u0018\u00010\"H\u0004J\u0016\u0010#\u001a\u00020\"*\u00020\"2\b\b\u0002\u0010$\u001a\u00020\u0019H\u0004J\u0017\u0010%\u001a\u00020\u00122\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00120'H\u0082\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "Lorg/jetbrains/skiko/swing/SwingRedrawer;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "graphicsApi", "Lorg/jetbrains/skiko/GraphicsApi;", "<init>", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skiko/GraphicsApi;)V", "isFirstFrameRendered", "", "rendererAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$RendererAnalytics;", "deviceAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$DeviceAnalytics;", "isDisposed", "onRender", "", "g", "Ljava/awt/Graphics2D;", "width", "", "height", "nanoTime", "", "dispose", "redraw", "onDeviceChosen", "deviceName", "", "rendererInfo", "onContextInit", "context", "Lorg/jetbrains/skia/DirectContext;", "configureContext", "gpuResourceCacheLimit", "inDrawScope", "body", "Lkotlin/Function0;", "skiko"})
public abstract class SwingRedrawerBase
implements SwingRedrawer {
    private final SwingLayerProperties swingLayerProperties;
    private final SkiaLayerAnalytics analytics;
    private final GraphicsApi graphicsApi;
    private boolean isFirstFrameRendered;
    private final SkiaLayerAnalytics.RendererAnalytics rendererAnalytics;
    private SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics;
    private boolean isDisposed;

    public SwingRedrawerBase(SwingLayerProperties swingLayerProperties2, SkiaLayerAnalytics skiaLayerAnalytics, GraphicsApi graphicsApi) {
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"");
        Intrinsics.checkNotNullParameter((Object)skiaLayerAnalytics, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)graphicsApi), (String)"");
        this.swingLayerProperties = swingLayerProperties2;
        this.analytics = skiaLayerAnalytics;
        this.graphicsApi = graphicsApi;
        this.rendererAnalytics = this.analytics.renderer(Version.INSTANCE.getSkiko(), OsArch_jvmKt.getHostOs(), this.graphicsApi);
        this.rendererAnalytics.init();
    }

    protected abstract void onRender(Graphics2D var1, int var2, int var3, long var4);

    @Override
    public void dispose() {
        if (!(!this.isDisposed)) {
            boolean bl = false;
            String string = this.getClass() + " is disposed";
            throw new IllegalArgumentException(string.toString());
        }
        this.isDisposed = true;
    }

    @Override
    public final void redraw(Graphics2D graphics2D) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"");
            if (!(!this.isDisposed)) {
                boolean bl = false;
                String string = this.getClass() + " is disposed";
                throw new IllegalArgumentException(string.toString());
            }
            SwingRedrawerBase swingRedrawerBase = this;
            boolean bl = false;
            if (!SwingUtilities.isEventDispatchThread()) {
                boolean bl2 = false;
                String string = "Method should be called from AWT event dispatch thread";
                throw new IllegalStateException(string.toString());
            }
            if (swingRedrawerBase.deviceAnalytics == null) {
                boolean bl3 = false;
                String string = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
                throw new IllegalArgumentException(string.toString());
            }
            if (swingRedrawerBase.isDisposed) break block9;
            boolean bl4 = !swingRedrawerBase.isFirstFrameRendered;
            swingRedrawerBase.isFirstFrameRendered = true;
            if (bl4) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics;
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics2 = deviceAnalytics = swingRedrawerBase.deviceAnalytics;
                if (deviceAnalytics2 != null) {
                    deviceAnalytics2.beforeFirstFrameRender();
                }
            }
            try {
                boolean bl5 = false;
                float f = SwingLayerPropertiesKt.getScale(this.swingLayerProperties);
                int n2 = RangesKt.coerceAtLeast((int)((int)((float)this.swingLayerProperties.getWidth() * f)), (int)0);
                int n3 = RangesKt.coerceAtLeast((int)((int)((float)this.swingLayerProperties.getHeight() * f)), (int)0);
                this.onRender(graphics2D, n2, n3, System.nanoTime());
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
            if (bl4 && !swingRedrawerBase.isDisposed) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = swingRedrawerBase.deviceAnalytics;
                if (deviceAnalytics != null) {
                    deviceAnalytics.afterFirstFrameRender();
                }
            }
        }
    }

    protected final void onDeviceChosen(String string) {
        block2: {
            if (!(!this.isDisposed)) {
                boolean bl = false;
                String string2 = this.getClass() + " is disposed";
                throw new IllegalArgumentException(string2.toString());
            }
            if (!(this.deviceAnalytics == null)) {
                boolean bl = false;
                String string3 = "deviceAnalytics is not null";
                throw new IllegalArgumentException(string3.toString());
            }
            this.rendererAnalytics.deviceChosen();
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics = this.analytics.device(Version.INSTANCE.getSkiko(), OsArch_jvmKt.getHostOs(), this.graphicsApi, string);
            if (deviceAnalytics == null) break block2;
            deviceAnalytics.init();
        }
    }

    protected String rendererInfo() {
        return "GraphicsApi: " + (Object)((Object)this.graphicsApi) + "\nOS: " + OsArch_jvmKt.getHostOs().getId() + ' ' + OsArch_jvmKt.getHostArch().getId() + '\n';
    }

    protected final void onContextInit(DirectContext directContext) {
        block5: {
            if (!(!this.isDisposed)) {
                boolean bl = false;
                String string = this.getClass() + " is disposed";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.deviceAnalytics == null) {
                boolean bl = false;
                String string = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
                throw new IllegalArgumentException(string.toString());
            }
            if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true")) {
                Logger logger = Logger.INSTANCE;
                boolean bl = false;
                if (logger.getLoggerImpl().isInfoEnabled()) {
                    SkikoLoggerInterface skikoLoggerInterface = logger.getLoggerImpl();
                    boolean bl2 = false;
                    skikoLoggerInterface.info("Renderer info:\n " + this.rendererInfo());
                }
            }
            DirectContext directContext2 = directContext;
            if (directContext2 != null) {
                SwingRedrawerBase.configureContext$default(this, directContext2, 0L, 1, null);
            }
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
            if (deviceAnalytics == null) break block5;
            deviceAnalytics.contextInit();
        }
    }

    protected final DirectContext configureContext(DirectContext directContext, long l) {
        DirectContext directContext2;
        Intrinsics.checkNotNullParameter((Object)directContext, (String)"");
        DirectContext directContext3 = directContext2 = directContext;
        boolean bl = false;
        if (l >= 0L) {
            directContext3.setResourceCacheLimit(l);
        }
        return directContext2;
    }

    public static /* synthetic */ DirectContext configureContext$default(SwingRedrawerBase swingRedrawerBase, DirectContext directContext, long l, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configureContext");
        }
        if ((n2 & 1) != 0) {
            l = swingRedrawerBase.swingLayerProperties.getGpuResourceCacheLimit();
        }
        return swingRedrawerBase.configureContext(directContext, l);
    }

    private final void inDrawScope(Function0<Unit> function0) {
        block8: {
            boolean bl = false;
            if (!SwingUtilities.isEventDispatchThread()) {
                boolean bl2 = false;
                String string = "Method should be called from AWT event dispatch thread";
                throw new IllegalStateException(string.toString());
            }
            if (this.deviceAnalytics == null) {
                boolean bl3 = false;
                String string = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.isDisposed) break block8;
            boolean bl4 = !this.isFirstFrameRendered;
            this.isFirstFrameRendered = true;
            if (bl4) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics;
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics2 = deviceAnalytics = this.deviceAnalytics;
                if (deviceAnalytics2 != null) {
                    deviceAnalytics2.beforeFirstFrameRender();
                }
            }
            try {
                function0.invoke();
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
            if (bl4 && !this.isDisposed) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
                if (deviceAnalytics != null) {
                    deviceAnalytics.afterFirstFrameRender();
                }
            }
        }
    }
}

