/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.ObjectUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.InputStream;

public class ByteBufInputStream
extends InputStream
implements DataInput {
    private final ByteBuf buffer;
    private final int startIndex;
    private final int endIndex;
    private boolean closed;
    private final boolean releaseOnClose;
    private StringBuilder lineBuf;

    public ByteBufInputStream(ByteBuf byteBuf) {
        this(byteBuf, byteBuf.readableBytes());
    }

    public ByteBufInputStream(ByteBuf byteBuf, int n) {
        this(byteBuf, n, false);
    }

    public ByteBufInputStream(ByteBuf byteBuf, boolean bl) {
        this(byteBuf, byteBuf.readableBytes(), bl);
    }

    public ByteBufInputStream(ByteBuf byteBuf, int n, boolean bl) {
        ObjectUtil.checkNotNull((Object)byteBuf, (String)"buffer");
        if (n < 0) {
            if (bl) {
                byteBuf.release();
            }
            ObjectUtil.checkPositiveOrZero((int)n, (String)"length");
        }
        if (n > byteBuf.readableBytes()) {
            if (bl) {
                byteBuf.release();
            }
            throw new IndexOutOfBoundsException("Too many bytes to be read - Needs " + n + ", maximum is " + byteBuf.readableBytes());
        }
        this.releaseOnClose = bl;
        this.buffer = byteBuf;
        this.startIndex = byteBuf.readerIndex();
        this.endIndex = this.startIndex + n;
        byteBuf.markReaderIndex();
    }

    public int readBytes() {
        return this.buffer.readerIndex() - this.startIndex;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            if (this.releaseOnClose && !this.closed) {
                this.closed = true;
                this.buffer.release();
            }
        }
    }

    @Override
    public int available() {
        return this.endIndex - this.buffer.readerIndex();
    }

    @Override
    public void mark(int n) {
        this.buffer.markReaderIndex();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        int n = this.available();
        if (n == 0) {
            return -1;
        }
        return this.buffer.readByte() & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3 = this.available();
        if (n3 == 0) {
            return -1;
        }
        n2 = Math.min(n3, n2);
        this.buffer.readBytes(byArray, n, n2);
        return n2;
    }

    @Override
    public void reset() {
        this.buffer.resetReaderIndex();
    }

    @Override
    public long skip(long l) {
        if (l > Integer.MAX_VALUE) {
            return this.skipBytes(Integer.MAX_VALUE);
        }
        return this.skipBytes((int)l);
    }

    @Override
    public boolean readBoolean() {
        this.checkAvailable(1);
        return this.read() != 0;
    }

    @Override
    public byte readByte() {
        int n = this.available();
        if (n == 0) {
            throw new EOFException();
        }
        return this.buffer.readByte();
    }

    @Override
    public char readChar() {
        return (char)this.readShort();
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public void readFully(byte[] byArray) {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) {
        this.checkAvailable(n2);
        this.buffer.readBytes(byArray, n, n2);
    }

    @Override
    public int readInt() {
        this.checkAvailable(4);
        return this.buffer.readInt();
    }

    @Override
    public String readLine() {
        int n = this.available();
        if (n == 0) {
            return null;
        }
        if (this.lineBuf != null) {
            this.lineBuf.setLength(0);
        }
        block4: while (true) {
            short s = this.buffer.readUnsignedByte();
            --n;
            switch (s) {
                case 10: {
                    break block4;
                }
                case 13: {
                    if (n <= 0 || (char)this.buffer.getUnsignedByte(this.buffer.readerIndex()) != '\n') break block4;
                    this.buffer.skipBytes(1);
                    --n;
                    break block4;
                }
                default: {
                    if (this.lineBuf == null) {
                        this.lineBuf = new StringBuilder();
                    }
                    this.lineBuf.append((char)s);
                    if (n > 0) continue block4;
                }
            }
            break;
        }
        return this.lineBuf != null && this.lineBuf.length() > 0 ? this.lineBuf.toString() : "";
    }

    @Override
    public long readLong() {
        this.checkAvailable(8);
        return this.buffer.readLong();
    }

    @Override
    public short readShort() {
        this.checkAvailable(2);
        return this.buffer.readShort();
    }

    @Override
    public String readUTF() {
        return DataInputStream.readUTF(this);
    }

    @Override
    public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int skipBytes(int n) {
        int n2 = Math.min(this.available(), n);
        this.buffer.skipBytes(n2);
        return n2;
    }

    private void checkAvailable(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fieldSize cannot be a negative number");
        }
        if (n > this.available()) {
            throw new EOFException("fieldSize is too long! Length is " + n + ", but maximum is " + this.available());
        }
    }
}

