/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.AddressResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.net.SocketAddress;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class AddressResolverGroup<T extends SocketAddress>
implements Closeable {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AddressResolverGroup.class);
    private final Map<EventExecutor, AddressResolver<T>> resolvers = new IdentityHashMap<EventExecutor, AddressResolver<T>>();
    private final Map<EventExecutor, GenericFutureListener<Future<Object>>> executorTerminationListeners = new IdentityHashMap<EventExecutor, GenericFutureListener<Future<Object>>>();

    protected AddressResolverGroup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressResolver<T> getResolver(final EventExecutor eventExecutor) {
        AddressResolver<T> addressResolver;
        ObjectUtil.checkNotNull((Object)eventExecutor, (String)"executor");
        if (eventExecutor.isShuttingDown()) {
            throw new IllegalStateException("executor not accepting a task");
        }
        Map<EventExecutor, AddressResolver<T>> map = this.resolvers;
        synchronized (map) {
            addressResolver = this.resolvers.get(eventExecutor);
            if (addressResolver == null) {
                AddressResolver<T> addressResolver2;
                try {
                    addressResolver2 = this.newResolver(eventExecutor);
                }
                catch (Exception exception) {
                    throw new IllegalStateException("failed to create a new resolver", exception);
                }
                this.resolvers.put(eventExecutor, addressResolver2);
                FutureListener<Object> futureListener = new FutureListener<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void operationComplete(Future<Object> future) {
                        Map map = AddressResolverGroup.this.resolvers;
                        synchronized (map) {
                            AddressResolverGroup.this.resolvers.remove(eventExecutor);
                            AddressResolverGroup.this.executorTerminationListeners.remove(eventExecutor);
                        }
                        addressResolver2.close();
                    }
                };
                this.executorTerminationListeners.put(eventExecutor, (GenericFutureListener<Future<Object>>)futureListener);
                eventExecutor.terminationFuture().addListener((GenericFutureListener)futureListener);
                addressResolver = addressResolver2;
            }
        }
        return addressResolver;
    }

    protected abstract AddressResolver<T> newResolver(EventExecutor var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object[] objectArray = this.resolvers;
        synchronized (this.resolvers) {
            AddressResolver[] addressResolverArray = this.resolvers.values().toArray(new AddressResolver[0]);
            this.resolvers.clear();
            Map.Entry[] entryArray = this.executorTerminationListeners.entrySet().toArray(new Map.Entry[0]);
            this.executorTerminationListeners.clear();
            // ** MonitorExit[objectArray] (shouldn't be in output)
            for (Map.Entry object : entryArray) {
                ((EventExecutor)object.getKey()).terminationFuture().removeListener((GenericFutureListener)object.getValue());
            }
            for (AddressResolver addressResolver : addressResolverArray) {
                try {
                    addressResolver.close();
                }
                catch (Throwable throwable) {
                    logger.warn("Failed to close a resolver:", throwable);
                }
            }
            return;
        }
    }
}

