/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.HostsFileEntriesProvider;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class DefaultHostsFileEntriesResolver
implements HostsFileEntriesResolver {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHostsFileEntriesResolver.class);
    private static final long DEFAULT_REFRESH_INTERVAL = SystemPropertyUtil.getLong((String)"io.netty.hostsFileRefreshInterval", (long)0L);
    private final long refreshInterval;
    private final AtomicLong lastRefresh = new AtomicLong(System.nanoTime());
    private final HostsFileEntriesProvider.Parser hostsFileParser;
    private volatile Map<String, List<InetAddress>> inet4Entries;
    private volatile Map<String, List<InetAddress>> inet6Entries;

    public DefaultHostsFileEntriesResolver() {
        this(HostsFileEntriesProvider.parser(), DEFAULT_REFRESH_INTERVAL);
    }

    DefaultHostsFileEntriesResolver(HostsFileEntriesProvider.Parser parser, long l) {
        this.hostsFileParser = parser;
        this.refreshInterval = ObjectUtil.checkPositiveOrZero((long)l, (String)"refreshInterval");
        HostsFileEntriesProvider hostsFileEntriesProvider = DefaultHostsFileEntriesResolver.parseEntries(parser);
        this.inet4Entries = hostsFileEntriesProvider.ipv4Entries();
        this.inet6Entries = hostsFileEntriesProvider.ipv6Entries();
    }

    @Override
    public InetAddress address(String string, ResolvedAddressTypes resolvedAddressTypes) {
        return DefaultHostsFileEntriesResolver.firstAddress(this.addresses(string, resolvedAddressTypes));
    }

    public List<InetAddress> addresses(String string, ResolvedAddressTypes resolvedAddressTypes) {
        String string2 = this.normalize(string);
        this.ensureHostsFileEntriesAreFresh();
        switch (resolvedAddressTypes) {
            case IPV4_ONLY: {
                return this.inet4Entries.get(string2);
            }
            case IPV6_ONLY: {
                return this.inet6Entries.get(string2);
            }
            case IPV4_PREFERRED: {
                List<InetAddress> list = this.inet4Entries.get(string2);
                return list != null ? DefaultHostsFileEntriesResolver.allAddresses(list, this.inet6Entries.get(string2)) : this.inet6Entries.get(string2);
            }
            case IPV6_PREFERRED: {
                List<InetAddress> list = this.inet6Entries.get(string2);
                return list != null ? DefaultHostsFileEntriesResolver.allAddresses(list, this.inet4Entries.get(string2)) : this.inet4Entries.get(string2);
            }
        }
        throw new IllegalArgumentException("Unknown ResolvedAddressTypes " + (Object)((Object)resolvedAddressTypes));
    }

    private void ensureHostsFileEntriesAreFresh() {
        long l = this.refreshInterval;
        if (l == 0L) {
            return;
        }
        long l2 = this.lastRefresh.get();
        long l3 = System.nanoTime();
        if (l3 - l2 > l && this.lastRefresh.compareAndSet(l2, l3)) {
            HostsFileEntriesProvider hostsFileEntriesProvider = DefaultHostsFileEntriesResolver.parseEntries(this.hostsFileParser);
            this.inet4Entries = hostsFileEntriesProvider.ipv4Entries();
            this.inet6Entries = hostsFileEntriesProvider.ipv6Entries();
        }
    }

    String normalize(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    private static List<InetAddress> allAddresses(List<InetAddress> list, List<InetAddress> list2) {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>(list.size() + (list2 == null ? 0 : list2.size()));
        arrayList.addAll(list);
        if (list2 != null) {
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    private static InetAddress firstAddress(List<InetAddress> list) {
        return list != null && !list.isEmpty() ? list.get(0) : null;
    }

    private static HostsFileEntriesProvider parseEntries(HostsFileEntriesProvider.Parser parser) {
        if (PlatformDependent.isWindows()) {
            return parser.parseSilently(Charset.defaultCharset(), CharsetUtil.UTF_16, CharsetUtil.UTF_8);
        }
        return parser.parseSilently();
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.hostsFileRefreshInterval: {}", (Object)DEFAULT_REFRESH_INTERVAL);
        }
    }
}

