/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.InetNameResolver;
import io.netty.resolver.NameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RoundRobinInetAddressResolver
extends InetNameResolver {
    private final NameResolver<InetAddress> nameResolver;

    public RoundRobinInetAddressResolver(EventExecutor eventExecutor, NameResolver<InetAddress> nameResolver) {
        super(eventExecutor);
        this.nameResolver = nameResolver;
    }

    @Override
    protected void doResolve(final String string, final Promise<InetAddress> promise) {
        this.nameResolver.resolveAll(string).addListener((GenericFutureListener)new FutureListener<List<InetAddress>>(){

            public void operationComplete(Future<List<InetAddress>> future) {
                if (future.isSuccess()) {
                    List list = (List)future.getNow();
                    int n = list.size();
                    if (n > 0) {
                        promise.setSuccess(list.get(RoundRobinInetAddressResolver.randomIndex(n)));
                    } else {
                        promise.setFailure((Throwable)new UnknownHostException(string));
                    }
                } else {
                    promise.setFailure(future.cause());
                }
            }
        });
    }

    @Override
    protected void doResolveAll(String string, final Promise<List<InetAddress>> promise) {
        this.nameResolver.resolveAll(string).addListener((GenericFutureListener)new FutureListener<List<InetAddress>>(){

            public void operationComplete(Future<List<InetAddress>> future) {
                if (future.isSuccess()) {
                    List list = (List)future.getNow();
                    if (!list.isEmpty()) {
                        ArrayList arrayList = new ArrayList(list);
                        Collections.rotate(arrayList, RoundRobinInetAddressResolver.randomIndex(list.size()));
                        promise.setSuccess(arrayList);
                    } else {
                        promise.setSuccess((Object)list);
                    }
                } else {
                    promise.setFailure(future.cause());
                }
            }
        });
    }

    private static int randomIndex(int n) {
        return n == 1 ? 0 : PlatformDependent.threadLocalRandom().nextInt(n);
    }

    @Override
    public void close() {
        this.nameResolver.close();
    }
}

