/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpVersion
implements Comparable<HttpVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\S+)/(\\d+)\\.(\\d+)");
    static final String HTTP_1_0_STRING = "HTTP/1.0";
    static final String HTTP_1_1_STRING = "HTTP/1.1";
    public static final HttpVersion HTTP_1_0 = new HttpVersion("HTTP", 1, 0, false, true);
    public static final HttpVersion HTTP_1_1 = new HttpVersion("HTTP", 1, 1, true, true);
    private final String protocolName;
    private final int majorVersion;
    private final int minorVersion;
    private final String text;
    private final boolean keepAliveDefault;
    private final byte[] bytes;

    public static HttpVersion valueOf(String string) {
        return HttpVersion.valueOf(string, false);
    }

    static HttpVersion valueOf(String string, boolean bl) {
        ObjectUtil.checkNotNull((Object)string, (String)"text");
        if (string == HTTP_1_1_STRING) {
            return HTTP_1_1;
        }
        if (string == HTTP_1_0_STRING) {
            return HTTP_1_0;
        }
        if ((string = string.trim()).isEmpty()) {
            throw new IllegalArgumentException("text is empty (possibly HTTP/0.9)");
        }
        HttpVersion httpVersion = HttpVersion.version0(string);
        if (httpVersion == null) {
            httpVersion = new HttpVersion(string, bl, true);
        }
        return httpVersion;
    }

    private static HttpVersion version0(String string) {
        if (HTTP_1_1_STRING.equals(string)) {
            return HTTP_1_1;
        }
        if (HTTP_1_0_STRING.equals(string)) {
            return HTTP_1_0;
        }
        return null;
    }

    public HttpVersion(String string, boolean bl) {
        this(string, false, bl);
    }

    HttpVersion(String string, boolean bl, boolean bl2) {
        string = ObjectUtil.checkNonEmptyAfterTrim((String)string, (String)"text").toUpperCase();
        if (bl) {
            if (string.length() != 8 || !string.startsWith("HTTP/") || string.charAt(6) != '.') {
                throw new IllegalArgumentException("invalid version format: " + string);
            }
            this.protocolName = "HTTP";
            this.majorVersion = HttpVersion.toDecimal(string.charAt(5));
            this.minorVersion = HttpVersion.toDecimal(string.charAt(7));
        } else {
            Matcher matcher = VERSION_PATTERN.matcher(string);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("invalid version format: " + string);
            }
            this.protocolName = matcher.group(1);
            this.majorVersion = Integer.parseInt(matcher.group(2));
            this.minorVersion = Integer.parseInt(matcher.group(3));
        }
        this.text = this.protocolName + '/' + this.majorVersion + '.' + this.minorVersion;
        this.keepAliveDefault = bl2;
        this.bytes = null;
    }

    private static int toDecimal(int n) {
        if (n < 48 || n > 57) {
            throw new IllegalArgumentException("Invalid version number, only 0-9 (0x30-0x39) allowed, but received a '" + (char)n + "' (0x" + Integer.toHexString(n) + ")");
        }
        return n - 48;
    }

    public HttpVersion(String string, int n, int n2, boolean bl) {
        this(string, n, n2, bl, false);
    }

    private HttpVersion(String string, int n, int n2, boolean bl, boolean bl2) {
        string = ObjectUtil.checkNonEmptyAfterTrim((String)string, (String)"protocolName").toUpperCase();
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isISOControl(string.charAt(i)) && !Character.isWhitespace(string.charAt(i))) continue;
            throw new IllegalArgumentException("invalid character in protocolName");
        }
        ObjectUtil.checkPositiveOrZero((int)n, (String)"majorVersion");
        ObjectUtil.checkPositiveOrZero((int)n2, (String)"minorVersion");
        this.protocolName = string;
        this.majorVersion = n;
        this.minorVersion = n2;
        this.text = string + '/' + n + '.' + n2;
        this.keepAliveDefault = bl;
        this.bytes = (byte[])(bl2 ? this.text.getBytes(CharsetUtil.US_ASCII) : null);
    }

    public String protocolName() {
        return this.protocolName;
    }

    public int majorVersion() {
        return this.majorVersion;
    }

    public int minorVersion() {
        return this.minorVersion;
    }

    public String text() {
        return this.text;
    }

    public boolean isKeepAliveDefault() {
        return this.keepAliveDefault;
    }

    public String toString() {
        return this.text();
    }

    public int hashCode() {
        return (this.protocolName().hashCode() * 31 + this.majorVersion()) * 31 + this.minorVersion();
    }

    public boolean equals(Object object) {
        if (!(object instanceof HttpVersion)) {
            return false;
        }
        HttpVersion httpVersion = (HttpVersion)object;
        return this.minorVersion() == httpVersion.minorVersion() && this.majorVersion() == httpVersion.majorVersion() && this.protocolName().equals(httpVersion.protocolName());
    }

    @Override
    public int compareTo(HttpVersion httpVersion) {
        int n = this.protocolName().compareTo(httpVersion.protocolName());
        if (n != 0) {
            return n;
        }
        n = this.majorVersion() - httpVersion.majorVersion();
        if (n != 0) {
            return n;
        }
        return this.minorVersion() - httpVersion.minorVersion();
    }

    void encode(ByteBuf byteBuf) {
        if (this.bytes == null) {
            byteBuf.writeCharSequence((CharSequence)this.text, CharsetUtil.US_ASCII);
        } else {
            byteBuf.writeBytes(this.bytes);
        }
    }
}

