/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CorruptedWebSocketFrameException;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.Utf8Validator;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;

public class Utf8FrameValidator
extends ChannelInboundHandlerAdapter {
    private final boolean closeOnProtocolViolation;
    private int fragmentedFramesCount;
    private Utf8Validator utf8Validator;

    public Utf8FrameValidator() {
        this(true);
    }

    public Utf8FrameValidator(boolean bl) {
        this.closeOnProtocolViolation = bl;
    }

    private static boolean isControlFrame(WebSocketFrame webSocketFrame) {
        return webSocketFrame instanceof CloseWebSocketFrame || webSocketFrame instanceof PingWebSocketFrame || webSocketFrame instanceof PongWebSocketFrame;
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof WebSocketFrame) {
            WebSocketFrame webSocketFrame = (WebSocketFrame)((Object)object);
            try {
                if (webSocketFrame.isFinalFragment()) {
                    if (!Utf8FrameValidator.isControlFrame(webSocketFrame)) {
                        this.fragmentedFramesCount = 0;
                        if (webSocketFrame instanceof TextWebSocketFrame || this.utf8Validator != null && this.utf8Validator.isChecking()) {
                            this.checkUTF8String(webSocketFrame.content());
                            this.utf8Validator.finish();
                        }
                    }
                } else {
                    if (this.fragmentedFramesCount == 0) {
                        if (webSocketFrame instanceof TextWebSocketFrame) {
                            this.checkUTF8String(webSocketFrame.content());
                        }
                    } else if (this.utf8Validator != null && this.utf8Validator.isChecking()) {
                        this.checkUTF8String(webSocketFrame.content());
                    }
                    ++this.fragmentedFramesCount;
                }
            }
            catch (CorruptedWebSocketFrameException corruptedWebSocketFrameException) {
                this.protocolViolation(channelHandlerContext, webSocketFrame, corruptedWebSocketFrameException);
            }
        }
        super.channelRead(channelHandlerContext, object);
    }

    private void checkUTF8String(ByteBuf byteBuf) {
        if (this.utf8Validator == null) {
            this.utf8Validator = new Utf8Validator();
        }
        this.utf8Validator.check(byteBuf);
    }

    private void protocolViolation(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, CorruptedWebSocketFrameException corruptedWebSocketFrameException) {
        webSocketFrame.release();
        if (this.closeOnProtocolViolation && channelHandlerContext.channel().isOpen()) {
            WebSocketCloseStatus webSocketCloseStatus = corruptedWebSocketFrameException.closeStatus();
            String string = corruptedWebSocketFrameException.getMessage();
            if (string == null) {
                string = webSocketCloseStatus.reasonText();
            }
            CloseWebSocketFrame closeWebSocketFrame = new CloseWebSocketFrame(webSocketCloseStatus.code(), string);
            channelHandlerContext.writeAndFlush((Object)closeWebSocketFrame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        throw corruptedWebSocketFrameException;
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        super.exceptionCaught(channelHandlerContext, throwable);
    }
}

