/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.AppenderModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.OptionHelper;
import java.util.Map;

public class AppenderModelHandler<E>
extends ModelHandlerBase {
    Appender<E> appender;
    private boolean inError = false;
    private boolean skipped = false;
    AppenderAttachable<E> appenderAttachable;

    public AppenderModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new AppenderModelHandler(context);
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        this.appender = null;
        this.inError = false;
        AppenderModel appenderModel = (AppenderModel)model;
        String string = modelInterpretationContext.subst(appenderModel.getName());
        if (!modelInterpretationContext.hasDependers(string)) {
            this.addWarn("Appender named [" + string + "] not referenced. Skipping further processing.");
            this.skipped = true;
            appenderModel.markAsSkipped();
            return;
        }
        this.addInfo("Processing appender named [" + string + "]");
        String string2 = appenderModel.getClassName();
        String string3 = modelInterpretationContext.getImport(string2);
        try {
            this.addInfo("About to instantiate appender of type [" + string3 + "]");
            this.appender = (Appender)OptionHelper.instantiateByClassName(string3, Appender.class, this.context);
            this.appender.setContext(this.context);
            this.appender.setName(string);
            modelInterpretationContext.pushObject(this.appender);
        }
        catch (Exception exception) {
            this.inError = true;
            this.addError("Could not create an Appender of type [" + string3 + "].", exception);
            throw new ModelHandlerException(exception);
        }
    }

    @Override
    public void postHandle(ModelInterpretationContext modelInterpretationContext, Model model) {
        if (this.inError || this.skipped) {
            return;
        }
        if (this.appender instanceof LifeCycle) {
            this.appender.start();
        }
        modelInterpretationContext.markStartOfNamedDependee(this.appender.getName());
        Object object = modelInterpretationContext.peekObject();
        Map map = (Map)modelInterpretationContext.getObjectMap().get("APPENDER_BAG");
        map.put(this.appender.getName(), this.appender);
        if (object != this.appender) {
            this.addWarn("The object at the of the stack is not the appender named [" + this.appender.getName() + "] pushed earlier.");
        } else {
            modelInterpretationContext.popObject();
        }
    }
}

