/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.model.DefineModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.spi.PropertyDefiner;
import ch.qos.logback.core.util.OptionHelper;

public class DefineModelHandler
extends ModelHandlerBase {
    boolean inError;
    PropertyDefiner definer;
    String propertyName;
    ActionUtil.Scope scope;

    public DefineModelHandler(Context context) {
        super(context);
    }

    public static DefineModelHandler makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new DefineModelHandler(context);
    }

    protected Class<DefineModel> getSupportedModelClass() {
        return DefineModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        String string;
        this.definer = null;
        this.inError = false;
        this.propertyName = null;
        DefineModel defineModel = (DefineModel)model;
        this.propertyName = defineModel.getName();
        String string2 = defineModel.getScopeStr();
        this.scope = ActionUtil.stringToScope(string2);
        if (OptionHelper.isNullOrEmptyOrAllSpaces(this.propertyName)) {
            this.addError("Missing property name for property definer. Near [" + model.getTag() + "] line " + model.getLineNumber());
            this.inError = true;
        }
        if (OptionHelper.isNullOrEmptyOrAllSpaces(string = defineModel.getClassName())) {
            this.addError("Missing class name for property definer. Near [" + model.getTag() + "] line " + model.getLineNumber());
            this.inError = true;
        } else {
            string = modelInterpretationContext.getImport(string);
        }
        if (this.inError) {
            return;
        }
        try {
            this.addInfo("About to instantiate property definer of type [" + string + "]");
            this.definer = (PropertyDefiner)OptionHelper.instantiateByClassName(string, PropertyDefiner.class, this.context);
            this.definer.setContext(this.context);
            modelInterpretationContext.pushObject(this.definer);
        }
        catch (Exception exception) {
            this.inError = true;
            this.addError("Could not create an PropertyDefiner of type [" + string + "].", exception);
            throw new ModelHandlerException(exception);
        }
    }

    @Override
    public void postHandle(ModelInterpretationContext modelInterpretationContext, Model model) {
        if (this.inError) {
            return;
        }
        Object object = modelInterpretationContext.peekObject();
        if (object != this.definer) {
            this.addWarn("The object at the of the stack is not the property definer for property named [" + this.propertyName + "] pushed earlier.");
        } else {
            String string;
            modelInterpretationContext.popObject();
            if (this.definer instanceof LifeCycle) {
                ((LifeCycle)((Object)this.definer)).start();
            }
            if ((string = this.definer.getPropertyValue()) != null) {
                this.addInfo("Setting property " + this.propertyName + "=" + string + " in scope " + String.valueOf((Object)this.scope));
                ActionUtil.setProperty(modelInterpretationContext, this.propertyName, string, this.scope);
            }
        }
    }
}

