/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.hook.DefaultShutdownHook;
import ch.qos.logback.core.hook.ShutdownHook;
import ch.qos.logback.core.hook.ShutdownHookBase;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ShutdownHookModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.DynamicClassLoadingException;
import ch.qos.logback.core.util.IncompatibleClassException;
import ch.qos.logback.core.util.OptionHelper;

public class ShutdownHookModelHandler
extends ModelHandlerBase {
    static final String OLD_SHUTDOWN_HOOK_CLASSNAME = "ch.qos.logback.core.hook.DelayingShutdownHook";
    static final String DEFAULT_SHUTDOWN_HOOK_CLASSNAME = DefaultShutdownHook.class.getName();
    public static final String RENAME_WARNING = "ch.qos.logback.core.hook.DelayingShutdownHook was renamed as " + DEFAULT_SHUTDOWN_HOOK_CLASSNAME;
    boolean inError = false;
    ShutdownHook hook = null;

    public ShutdownHookModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new ShutdownHookModelHandler(context);
    }

    protected Class<ShutdownHookModel> getSupportedModelClass() {
        return ShutdownHookModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        ShutdownHookModel shutdownHookModel = (ShutdownHookModel)model;
        String string = shutdownHookModel.getClassName();
        if (OptionHelper.isNullOrEmptyOrAllSpaces(string)) {
            string = DEFAULT_SHUTDOWN_HOOK_CLASSNAME;
            this.addInfo("Assuming className [" + string + "]");
        } else if ((string = modelInterpretationContext.getImport(string)).equals(OLD_SHUTDOWN_HOOK_CLASSNAME)) {
            string = DEFAULT_SHUTDOWN_HOOK_CLASSNAME;
            this.addWarn(RENAME_WARNING);
            this.addWarn("Please use the new class name");
        }
        this.addInfo("About to instantiate shutdown hook of type [" + string + "]");
        try {
            this.hook = (ShutdownHookBase)OptionHelper.instantiateByClassName(string, ShutdownHookBase.class, this.context);
            this.hook.setContext(this.context);
        }
        catch (DynamicClassLoadingException | IncompatibleClassException exception) {
            this.addError("Could not create a shutdown hook of type [" + string + "].", exception);
            this.inError = true;
            return;
        }
        modelInterpretationContext.pushObject(this.hook);
    }

    @Override
    public void postHandle(ModelInterpretationContext modelInterpretationContext, Model model) {
        if (this.inError) {
            return;
        }
        Object object = modelInterpretationContext.peekObject();
        if (object != this.hook) {
            this.addWarn("The object on the top the of the stack is not the hook object pushed earlier.");
        } else {
            Thread thread = new Thread((Runnable)this.hook, "Logback shutdown hook [" + this.context.getName() + "]");
            this.addInfo("Registering shutdown hook with JVM runtime.");
            this.context.putObject("SHUTDOWN_HOOK", thread);
            Runtime.getRuntime().addShutdownHook(thread);
            modelInterpretationContext.popObject();
        }
    }
}

