/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Compressor
extends ContextAwareBase {
    final CompressionMode compressionMode;
    static final int BUFFER_SIZE = 8192;

    public Compressor(CompressionMode compressionMode) {
        this.compressionMode = compressionMode;
    }

    public void compress(String string, String string2, String string3) {
        switch (this.compressionMode) {
            case GZ: {
                this.gzCompress(string, string2);
                break;
            }
            case ZIP: {
                this.zipCompress(string, string2, string3);
                break;
            }
            case NONE: {
                throw new UnsupportedOperationException("compress method called in NONE compression mode");
            }
        }
    }

    private void zipCompress(String string, String object, String string2) {
        File file;
        File file2 = new File(string);
        if (!file2.exists()) {
            this.addStatus(new WarnStatus("The file to compress named [" + string + "] does not exist.", this));
            return;
        }
        if (string2 == null) {
            this.addStatus(new WarnStatus("The innerEntryName parameter cannot be null", this));
            return;
        }
        if (!((String)object).endsWith(".zip")) {
            object = (String)object + ".zip";
        }
        if ((file = new File((String)object)).exists()) {
            this.addStatus(new WarnStatus("The target compressed file named [" + (String)object + "] exist already.", this));
            return;
        }
        this.addInfo("ZIP compressing [" + String.valueOf(file2) + "] as [" + String.valueOf(file) + "]");
        this.createMissingTargetDirsIfNecessary(file);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
             ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream((String)object));){
            int n;
            ZipEntry zipEntry = this.computeZipEntry(string2);
            zipOutputStream.putNextEntry(zipEntry);
            byte[] byArray = new byte[8192];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            this.addInfo("Done ZIP compressing [" + String.valueOf(file2) + "] as [" + String.valueOf(file) + "]");
        }
        catch (Exception exception) {
            this.addStatus(new ErrorStatus("Error occurred while compressing [" + string + "] into [" + (String)object + "].", this, exception));
        }
        if (!file2.delete()) {
            this.addStatus(new WarnStatus("Could not delete [" + string + "].", this));
        }
    }

    ZipEntry computeZipEntry(File file) {
        return this.computeZipEntry(file.getName());
    }

    ZipEntry computeZipEntry(String string) {
        String string2 = Compressor.computeFileNameStrWithoutCompSuffix(string, this.compressionMode);
        return new ZipEntry(string2);
    }

    private void gzCompress(String string, String object) {
        File file;
        File file2 = new File(string);
        if (!file2.exists()) {
            this.addStatus(new WarnStatus("The file to compress named [" + string + "] does not exist.", this));
            return;
        }
        if (!((String)object).endsWith(".gz")) {
            object = (String)object + ".gz";
        }
        if ((file = new File((String)object)).exists()) {
            this.addWarn("The target compressed file named [" + (String)object + "] exist already. Aborting file compression.");
            return;
        }
        this.addInfo("GZ compressing [" + String.valueOf(file2) + "] as [" + String.valueOf(file) + "]");
        this.createMissingTargetDirsIfNecessary(file);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
             GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new FileOutputStream((String)object));){
            int n;
            byte[] byArray = new byte[8192];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                gZIPOutputStream.write(byArray, 0, n);
            }
            this.addInfo("Done GZ compressing [" + String.valueOf(file2) + "] as [" + String.valueOf(file) + "]");
        }
        catch (Exception exception) {
            this.addStatus(new ErrorStatus("Error occurred while compressing [" + string + "] into [" + (String)object + "].", this, exception));
        }
        if (!file2.delete()) {
            this.addStatus(new WarnStatus("Could not delete [" + string + "].", this));
        }
    }

    public static String computeFileNameStrWithoutCompSuffix(String string, CompressionMode compressionMode) {
        int n = string.length();
        switch (compressionMode) {
            case GZ: {
                if (string.endsWith(".gz")) {
                    return string.substring(0, n - 3);
                }
                return string;
            }
            case ZIP: {
                if (string.endsWith(".zip")) {
                    return string.substring(0, n - 4);
                }
                return string;
            }
            case NONE: {
                return string;
            }
        }
        throw new IllegalStateException("Execution should not reach this point");
    }

    void createMissingTargetDirsIfNecessary(File file) {
        boolean bl = FileUtil.createMissingParentDirectories(file);
        if (!bl) {
            this.addError("Failed to create parent directories for [" + file.getAbsolutePath() + "]");
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    public Future<?> asyncCompress(String string, String string2, String string3) {
        CompressionRunnable compressionRunnable = new CompressionRunnable(string, string2, string3);
        ExecutorService executorService = this.context.getExecutorService();
        Future<?> future = executorService.submit(compressionRunnable);
        return future;
    }

    class CompressionRunnable
    implements Runnable {
        final String nameOfFile2Compress;
        final String nameOfCompressedFile;
        final String innerEntryName;

        public CompressionRunnable(String string, String string2, String string3) {
            this.nameOfFile2Compress = string;
            this.nameOfCompressedFile = string2;
            this.innerEntryName = string3;
        }

        @Override
        public void run() {
            Compressor.this.compress(this.nameOfFile2Compress, this.nameOfCompressedFile, this.innerEntryName);
        }
    }
}

