/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.helpers.ThrowableToStringArray;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.StatusUtil;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.io.PrintStream;
import java.util.List;

public class StatusPrinter2 {
    private PrintStream ps = System.out;
    static CachingDateFormatter cachingDateFormat = new CachingDateFormatter("HH:mm:ss,SSS");

    public void setPrintStream(PrintStream printStream) {
        this.ps = printStream;
    }

    public void printInCaseOfErrorsOrWarnings(Context context) {
        this.printInCaseOfErrorsOrWarnings(context, 0L);
    }

    public void printInCaseOfErrorsOrWarnings(Context context, long l) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager statusManager = context.getStatusManager();
        if (statusManager == null) {
            this.ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
        } else {
            StatusUtil statusUtil = new StatusUtil(context);
            if (statusUtil.getHighestLevel(l) >= 1) {
                this.print(statusManager, l);
            }
        }
    }

    public void printIfErrorsOccured(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager statusManager = context.getStatusManager();
        if (statusManager == null) {
            this.ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
        } else {
            StatusUtil statusUtil = new StatusUtil(context);
            if (statusUtil.getHighestLevel(0L) == 2) {
                this.print(statusManager);
            }
        }
    }

    public void print(Context context) {
        this.print(context, 0L);
    }

    public void print(Context context, long l) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager statusManager = context.getStatusManager();
        if (statusManager == null) {
            this.ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
        } else {
            this.print(statusManager, l);
        }
    }

    public void print(StatusManager statusManager) {
        this.print(statusManager, 0L);
    }

    public void print(StatusManager statusManager, long l) {
        StringBuilder stringBuilder = new StringBuilder();
        List<Status> list = StatusUtil.filterStatusListByTimeThreshold(statusManager.getCopyOfStatusList(), l);
        this.buildStrFromStatusList(stringBuilder, list);
        this.ps.println(stringBuilder.toString());
    }

    public void print(List<Status> list) {
        StringBuilder stringBuilder = new StringBuilder();
        this.buildStrFromStatusList(stringBuilder, list);
        this.ps.println(stringBuilder.toString());
    }

    private void buildStrFromStatusList(StringBuilder stringBuilder, List<Status> list) {
        if (list == null) {
            return;
        }
        for (Status status : list) {
            this.buildStr(stringBuilder, "", status);
        }
    }

    private void appendThrowable(StringBuilder stringBuilder, Throwable throwable) {
        String[] stringArray;
        for (String string : stringArray = ThrowableToStringArray.convert(throwable)) {
            if (!string.startsWith("Caused by: ")) {
                if (Character.isDigit(string.charAt(0))) {
                    stringBuilder.append("\t... ");
                } else {
                    stringBuilder.append("\tat ");
                }
            }
            stringBuilder.append(string).append(CoreConstants.LINE_SEPARATOR);
        }
    }

    public void buildStr(StringBuilder stringBuilder, String string, Status status) {
        Object object;
        String string2 = status.hasChildren() ? string + "+ " : string + "|-";
        if (cachingDateFormat != null) {
            object = cachingDateFormat.format(status.getTimestamp());
            stringBuilder.append((String)object).append(" ");
        }
        stringBuilder.append(string2).append(status).append(CoreConstants.LINE_SEPARATOR);
        if (status.getThrowable() != null) {
            this.appendThrowable(stringBuilder, status.getThrowable());
        }
        if (status.hasChildren()) {
            object = status.iterator();
            while (object.hasNext()) {
                Status status2 = (Status)object.next();
                this.buildStr(stringBuilder, string + "  ", status2);
            }
        }
    }
}

