/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.gestures.snapping;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.snapping.FinalSnappingItem;
import androidx.compose.foundation.gestures.snapping.LazyListSnapLayoutInfoProviderKt;
import androidx.compose.foundation.gestures.snapping.SnapLayoutInfoProvider;
import androidx.compose.foundation.gestures.snapping.SnapPosition;
import androidx.compose.foundation.gestures.snapping.SnapPositionKt;
import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.pager.PageInfo;
import androidx.compose.foundation.pager.PagerLayoutInfo;
import androidx.compose.foundation.pager.PagerLayoutInfoKt;
import androidx.compose.foundation.pager.PagerSnapDistance;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u001e\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\bH\u0002\u001a\f\u0010\f\u001a\u00020\b*\u00020\u0003H\u0002\u001a\u0017\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0082\b\u001a8\u0010\u0006\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0000\u00a8\u0006\u0018"}, d2={"SnapLayoutInfoProvider", "Landroidx/compose/foundation/gestures/snapping/SnapLayoutInfoProvider;", "pagerState", "Landroidx/compose/foundation/pager/PagerState;", "pagerSnapDistance", "Landroidx/compose/foundation/pager/PagerSnapDistance;", "calculateFinalSnappingBound", "Lkotlin/Function3;", "", "isScrollingForward", "", "velocity", "dragGestureDelta", "debugLog", "", "generateMsg", "Lkotlin/Function0;", "", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "snapPositionalThreshold", "flingVelocity", "lowerBoundOffset", "upperBoundOffset", "foundation"})
public final class PagerSnapLayoutInfoProviderKt {
    public static final SnapLayoutInfoProvider SnapLayoutInfoProvider(PagerState pagerState, PagerSnapDistance pagerSnapDistance, Function3<? super Float, ? super Float, ? super Float, Float> function3) {
        Intrinsics.checkNotNullParameter((Object)pagerState, (String)"");
        Intrinsics.checkNotNullParameter((Object)pagerSnapDistance, (String)"");
        Intrinsics.checkNotNullParameter(function3, (String)"");
        return new SnapLayoutInfoProvider(pagerState, function3, pagerSnapDistance){
            final /* synthetic */ PagerState $pagerState;
            final /* synthetic */ Function3<Float, Float, Float, Float> $calculateFinalSnappingBound;
            final /* synthetic */ PagerSnapDistance $pagerSnapDistance;
            {
                this.$pagerState = pagerState;
                this.$calculateFinalSnappingBound = function3;
                this.$pagerSnapDistance = pagerSnapDistance;
            }

            public final PagerLayoutInfo getLayoutInfo() {
                return this.$pagerState.getLayoutInfo();
            }

            public final boolean isValidDistance(float f2) {
                return !(f2 == Float.POSITIVE_INFINITY) && !(f2 == Float.NEGATIVE_INFINITY);
            }

            public float calculateSnapOffset(float f2) {
                SnapPosition snapPosition = this.$pagerState.getLayoutInfo().getSnapPosition();
                Pair<Float, Float> pair = this.searchForSnappingBounds(snapPosition, f2);
                float f3 = ((Number)pair.component1()).floatValue();
                float f4 = ((Number)pair.component2()).floatValue();
                float f5 = ((Number)this.$calculateFinalSnappingBound.invoke((Object)Float.valueOf(f2), (Object)Float.valueOf(f3), (Object)Float.valueOf(f4))).floatValue();
                boolean bl = f5 == f3 || f5 == f4 || f5 == 0.0f;
                boolean bl2 = false;
                if (!bl) {
                    boolean bl3 = false;
                    InlineClassHelperKt.throwIllegalStateException("Final Snapping Offset Should Be one of " + f3 + ", " + f4 + " or 0.0");
                }
                bl = false;
                return this.isValidDistance(f5) ? f5 : 0.0f;
            }

            public float calculateApproachOffset(float f2, float f3) {
                float f4;
                int n2 = 0;
                n2 = this.$pagerState.getPageSize$foundation() + this.$pagerState.getPageSpacing$foundation();
                if (n2 == 0) {
                    return 0.0f;
                }
                float f5 = f3;
                int n3 = f2 < 0.0f ? this.$pagerState.getFirstVisiblePage$foundation() + 1 : this.$pagerState.getFirstVisiblePage$foundation();
                boolean bl = false;
                float f6 = f5 / (float)n2;
                int n4 = 0;
                n4 = RangesKt.coerceIn((int)(n3 + (int)f6), (int)0, (int)this.$pagerState.getPageCount());
                int n5 = 0;
                n5 = RangesKt.coerceIn((int)this.$pagerSnapDistance.calculateTargetPage(n3, n4, f2, this.$pagerState.getPageSize$foundation(), this.$pagerState.getPageSpacing$foundation()), (int)0, (int)this.$pagerState.getPageCount());
                int n6 = 0;
                n6 = (n5 - n3) * n2;
                int n7 = 0;
                n7 = RangesKt.coerceAtLeast((int)(Math.abs(n6) - n2), (int)0);
                float f7 = f4 = n7 == 0 ? (float)n7 : (float)n7 * Math.signum(f2);
                boolean bl2 = false;
                boolean bl3 = false;
                return f4;
            }

            private final Pair<Float, Float> searchForSnappingBounds(SnapPosition snapPosition, float f2) {
                boolean bl = false;
                float f3 = 0.0f;
                f3 = Float.NEGATIVE_INFINITY;
                float f4 = 0.0f;
                f4 = Float.POSITIVE_INFINITY;
                List<PageInfo> list = this.getLayoutInfo().getVisiblePagesInfo();
                PagerState pagerState = this.$pagerState;
                boolean bl2 = false;
                int n2 = ((Collection)list).size();
                for (int k = 0; k < n2; ++k) {
                    PageInfo pageInfo;
                    PageInfo pageInfo2 = pageInfo = list.get(k);
                    boolean bl3 = false;
                    float f5 = SnapPositionKt.calculateDistanceToDesiredSnapPosition(PagerLayoutInfoKt.getMainAxisViewportSize(this.getLayoutInfo()), this.getLayoutInfo().getBeforeContentPadding(), this.getLayoutInfo().getAfterContentPadding(), this.getLayoutInfo().getPageSize(), pageInfo2.getOffset(), pageInfo2.getIndex(), snapPosition, pagerState.getPageCount());
                    if (f5 <= 0.0f && f5 > f3) {
                        f3 = f5;
                    }
                    if (!(f5 >= 0.0f) || !(f5 < f4)) continue;
                    f4 = f5;
                }
                if (f3 == Float.NEGATIVE_INFINITY) {
                    f3 = f4;
                }
                if (f4 == Float.POSITIVE_INFINITY) {
                    f4 = f3;
                }
                if (!this.$pagerState.getCanScrollForward()) {
                    f4 = 0.0f;
                    if (PagerSnapLayoutInfoProviderKt.access$isScrollingForward(this.$pagerState, f2)) {
                        f3 = 0.0f;
                    }
                }
                if (!this.$pagerState.getCanScrollBackward()) {
                    f3 = 0.0f;
                    if (!PagerSnapLayoutInfoProviderKt.access$isScrollingForward(this.$pagerState, f2)) {
                        f4 = 0.0f;
                    }
                }
                return TuplesKt.to((Object)Float.valueOf(f3), (Object)Float.valueOf(f4));
            }
        };
    }

    private static final boolean isScrollingForward(PagerState pagerState, float f2) {
        boolean bl = pagerState.getLayoutInfo().getReverseLayout();
        boolean bl2 = (pagerState.isNotGestureAction$foundation() ? -f2 : PagerSnapLayoutInfoProviderKt.dragGestureDelta(pagerState)) > 0.0f;
        return bl2 && bl || !bl2 && !bl;
    }

    private static final float dragGestureDelta(PagerState pagerState) {
        float f2;
        if (pagerState.getLayoutInfo().getOrientation() == Orientation.Horizontal) {
            long l = pagerState.getUpDownDifference-F1C5BW0$foundation();
            boolean bl = false;
            long l2 = l;
            boolean bl2 = false;
            int n2 = (int)(l2 >> 32);
            boolean bl3 = false;
            f2 = Float.intBitsToFloat(n2);
        } else {
            long l = pagerState.getUpDownDifference-F1C5BW0$foundation();
            boolean bl = false;
            long l3 = l;
            boolean bl4 = false;
            int n3 = (int)(l3 & 0xFFFFFFFFL);
            boolean bl5 = false;
            f2 = Float.intBitsToFloat(n3);
        }
        return f2;
    }

    private static final void debugLog(Function0<String> function0) {
        boolean bl = false;
    }

    public static final float calculateFinalSnappingBound(PagerState pagerState, LayoutDirection layoutDirection, float f2, float f3, float f4, float f5) {
        float f6;
        Intrinsics.checkNotNullParameter((Object)pagerState, (String)"");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"");
        boolean bl = PagerSnapLayoutInfoProviderKt.isScrollingForward(pagerState, f3);
        boolean bl2 = pagerState.getLayoutInfo().getOrientation() == Orientation.Vertical ? bl : (layoutDirection == LayoutDirection.Ltr ? bl : !bl);
        int n2 = 0;
        n2 = pagerState.getLayoutInfo().getPageSize();
        float f7 = n2 == 0 ? 0.0f : PagerSnapLayoutInfoProviderKt.dragGestureDelta(pagerState) / (float)n2;
        float f8 = f7 - (float)((int)f7);
        Density density = pagerState.getDensity$foundation();
        boolean bl3 = false;
        int n3 = LazyListSnapLayoutInfoProviderKt.calculateFinalSnappingItem(density, f3);
        int n4 = 0;
        n4 = n3;
        if (FinalSnappingItem.equals-impl0(n4, FinalSnappingItem.Companion.getClosestItem-bbeMdSM())) {
            if (Math.abs(f8) > f2) {
                boolean bl4 = false;
                f6 = bl2 ? f5 : f4;
            } else if (Math.abs(f7) >= Math.abs(pagerState.getPositionThresholdFraction$foundation())) {
                boolean bl5 = false;
                f6 = bl2 ? f4 : f5;
            } else {
                boolean bl6 = false;
                f6 = Math.abs(f4) < Math.abs(f5) ? f4 : f5;
            }
        } else {
            f6 = FinalSnappingItem.equals-impl0(n4, FinalSnappingItem.Companion.getNextItem-bbeMdSM()) ? f5 : (FinalSnappingItem.equals-impl0(n4, FinalSnappingItem.Companion.getPreviousItem-bbeMdSM()) ? f4 : 0.0f);
        }
        return f6;
    }

    public static final /* synthetic */ boolean access$isScrollingForward(PagerState pagerState, float f2) {
        return PagerSnapLayoutInfoProviderKt.isScrollingForward(pagerState, f2);
    }
}

