/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import androidx.compose.foundation.text.CoreTextFieldKt;
import androidx.compose.foundation.text.LegacyTextFieldState;
import androidx.compose.foundation.text.TextFieldDelegate;
import androidx.compose.foundation.text.TextLayoutResultProxy;
import androidx.compose.foundation.text.selection.TextFieldSelectionManager;
import androidx.compose.ui.autofill.ContentDataType;
import androidx.compose.ui.autofill.ContentType;
import androidx.compose.ui.autofill.FillableData;
import androidx.compose.ui.autofill.FillableDataKt;
import androidx.compose.ui.focus.FocusRequester;
import androidx.compose.ui.node.DelegatableNode;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.DelegatingNode;
import androidx.compose.ui.node.SemanticsModifierNode;
import androidx.compose.ui.node.SemanticsModifierNodeKt;
import androidx.compose.ui.semantics.SemanticsPropertiesKt;
import androidx.compose.ui.semantics.SemanticsPropertyReceiver;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.DeleteAllCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.FinishComposingTextCommand;
import androidx.compose.ui.text.input.ImeAction;
import androidx.compose.ui.text.input.ImeOptions;
import androidx.compose.ui.text.input.KeyboardType;
import androidx.compose.ui.text.input.OffsetMapping;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.input.TextInputSession;
import androidx.compose.ui.text.input.TransformedText;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b(\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002BW\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\f\u0010<\u001a\u00020=*\u00020>H\u0016JV\u0010?\u001a\u00020=2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J(\u0010@\u001a\u00020=2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010A\u001a\u00020B2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010\u000b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010$\"\u0004\b(\u0010&R\u001a\u0010\f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010$\"\u0004\b)\u0010&R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0014\u0010:\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010$\u00a8\u0006C"}, d2={"Landroidx/compose/foundation/text/input/internal/CoreTextFieldSemanticsModifierNode;", "Landroidx/compose/ui/node/DelegatingNode;", "Landroidx/compose/ui/node/SemanticsModifierNode;", "transformedText", "Landroidx/compose/ui/text/input/TransformedText;", "value", "Landroidx/compose/ui/text/input/TextFieldValue;", "state", "Landroidx/compose/foundation/text/LegacyTextFieldState;", "readOnly", "", "enabled", "isPassword", "offsetMapping", "Landroidx/compose/ui/text/input/OffsetMapping;", "manager", "Landroidx/compose/foundation/text/selection/TextFieldSelectionManager;", "imeOptions", "Landroidx/compose/ui/text/input/ImeOptions;", "focusRequester", "Landroidx/compose/ui/focus/FocusRequester;", "<init>", "(Landroidx/compose/ui/text/input/TransformedText;Landroidx/compose/ui/text/input/TextFieldValue;Landroidx/compose/foundation/text/LegacyTextFieldState;ZZZLandroidx/compose/ui/text/input/OffsetMapping;Landroidx/compose/foundation/text/selection/TextFieldSelectionManager;Landroidx/compose/ui/text/input/ImeOptions;Landroidx/compose/ui/focus/FocusRequester;)V", "getTransformedText", "()Landroidx/compose/ui/text/input/TransformedText;", "setTransformedText", "(Landroidx/compose/ui/text/input/TransformedText;)V", "getValue", "()Landroidx/compose/ui/text/input/TextFieldValue;", "setValue", "(Landroidx/compose/ui/text/input/TextFieldValue;)V", "getState", "()Landroidx/compose/foundation/text/LegacyTextFieldState;", "setState", "(Landroidx/compose/foundation/text/LegacyTextFieldState;)V", "getReadOnly", "()Z", "setReadOnly", "(Z)V", "getEnabled", "setEnabled", "setPassword", "getOffsetMapping", "()Landroidx/compose/ui/text/input/OffsetMapping;", "setOffsetMapping", "(Landroidx/compose/ui/text/input/OffsetMapping;)V", "getManager", "()Landroidx/compose/foundation/text/selection/TextFieldSelectionManager;", "setManager", "(Landroidx/compose/foundation/text/selection/TextFieldSelectionManager;)V", "getImeOptions", "()Landroidx/compose/ui/text/input/ImeOptions;", "setImeOptions", "(Landroidx/compose/ui/text/input/ImeOptions;)V", "getFocusRequester", "()Landroidx/compose/ui/focus/FocusRequester;", "setFocusRequester", "(Landroidx/compose/ui/focus/FocusRequester;)V", "shouldMergeDescendantSemantics", "getShouldMergeDescendantSemantics", "applySemantics", "", "Landroidx/compose/ui/semantics/SemanticsPropertyReceiver;", "updateNodeSemantics", "handleTextUpdateFromSemantics", "text", "", "foundation"})
public final class CoreTextFieldSemanticsModifierNode
extends DelegatingNode
implements SemanticsModifierNode {
    private TransformedText transformedText;
    private TextFieldValue value;
    private LegacyTextFieldState state;
    private boolean readOnly;
    private boolean enabled;
    private boolean isPassword;
    private OffsetMapping offsetMapping;
    private TextFieldSelectionManager manager;
    private ImeOptions imeOptions;
    private FocusRequester focusRequester;
    public static final int $stable = 8;

    public CoreTextFieldSemanticsModifierNode(TransformedText transformedText, TextFieldValue textFieldValue, LegacyTextFieldState legacyTextFieldState, boolean bl, boolean bl2, boolean bl3, OffsetMapping offsetMapping, TextFieldSelectionManager textFieldSelectionManager, ImeOptions imeOptions, FocusRequester focusRequester) {
        Intrinsics.checkNotNullParameter((Object)transformedText, (String)"");
        Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"");
        Intrinsics.checkNotNullParameter((Object)legacyTextFieldState, (String)"");
        Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"");
        Intrinsics.checkNotNullParameter((Object)textFieldSelectionManager, (String)"");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"");
        Intrinsics.checkNotNullParameter((Object)focusRequester, (String)"");
        this.transformedText = transformedText;
        this.value = textFieldValue;
        this.state = legacyTextFieldState;
        this.readOnly = bl;
        this.enabled = bl2;
        this.isPassword = bl3;
        this.offsetMapping = offsetMapping;
        this.manager = textFieldSelectionManager;
        this.imeOptions = imeOptions;
        this.focusRequester = focusRequester;
        this.manager.setRequestAutofillAction$foundation((Function0<Unit>)((Function0)() -> CoreTextFieldSemanticsModifierNode._init_$lambda$0(this)));
    }

    public final TransformedText getTransformedText() {
        return this.transformedText;
    }

    public final void setTransformedText(TransformedText transformedText) {
        Intrinsics.checkNotNullParameter((Object)transformedText, (String)"");
        this.transformedText = transformedText;
    }

    public final TextFieldValue getValue() {
        return this.value;
    }

    public final void setValue(TextFieldValue textFieldValue) {
        Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"");
        this.value = textFieldValue;
    }

    public final LegacyTextFieldState getState() {
        return this.state;
    }

    public final void setState(LegacyTextFieldState legacyTextFieldState) {
        Intrinsics.checkNotNullParameter((Object)legacyTextFieldState, (String)"");
        this.state = legacyTextFieldState;
    }

    public final boolean getReadOnly() {
        return this.readOnly;
    }

    public final void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final boolean isPassword() {
        return this.isPassword;
    }

    public final void setPassword(boolean bl) {
        this.isPassword = bl;
    }

    public final OffsetMapping getOffsetMapping() {
        return this.offsetMapping;
    }

    public final void setOffsetMapping(OffsetMapping offsetMapping) {
        Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"");
        this.offsetMapping = offsetMapping;
    }

    public final TextFieldSelectionManager getManager() {
        return this.manager;
    }

    public final void setManager(TextFieldSelectionManager textFieldSelectionManager) {
        Intrinsics.checkNotNullParameter((Object)textFieldSelectionManager, (String)"");
        this.manager = textFieldSelectionManager;
    }

    public final ImeOptions getImeOptions() {
        return this.imeOptions;
    }

    public final void setImeOptions(ImeOptions imeOptions) {
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"");
        this.imeOptions = imeOptions;
    }

    public final FocusRequester getFocusRequester() {
        return this.focusRequester;
    }

    public final void setFocusRequester(FocusRequester focusRequester) {
        Intrinsics.checkNotNullParameter((Object)focusRequester, (String)"");
        this.focusRequester = focusRequester;
    }

    public boolean getShouldMergeDescendantSemantics() {
        return true;
    }

    public void applySemantics(SemanticsPropertyReceiver semanticsPropertyReceiver) {
        Intrinsics.checkNotNullParameter((Object)semanticsPropertyReceiver, (String)"");
        SemanticsPropertiesKt.setInputText((SemanticsPropertyReceiver)semanticsPropertyReceiver, (AnnotatedString)this.value.getAnnotatedString());
        SemanticsPropertiesKt.setEditableText((SemanticsPropertyReceiver)semanticsPropertyReceiver, (AnnotatedString)this.transformedText.getText());
        SemanticsPropertiesKt.setTextSelectionRange-FDrldGo((SemanticsPropertyReceiver)semanticsPropertyReceiver, (long)this.value.getSelection-d9O1mEE());
        SemanticsPropertiesKt.setContentDataType((SemanticsPropertyReceiver)semanticsPropertyReceiver, (ContentDataType)ContentDataType.Companion.getText());
        FillableData fillableData = FillableDataKt.createFromText((FillableData.Companion)FillableData.Companion, (CharSequence)((CharSequence)this.value.getAnnotatedString()));
        if (fillableData != null) {
            FillableData fillableData2 = fillableData;
            boolean bl = false;
            SemanticsPropertiesKt.setFillableData((SemanticsPropertyReceiver)semanticsPropertyReceiver, (FillableData)fillableData2);
        }
        SemanticsPropertiesKt.onFillData$default((SemanticsPropertyReceiver)semanticsPropertyReceiver, null, arg_0 -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$1(this, arg_0), (int)1, null);
        int bl = this.imeOptions.getKeyboardType-PjHm6EE();
        if (KeyboardType.equals-impl0((int)bl, (int)KeyboardType.Companion.getEmail-PjHm6EE())) {
            SemanticsPropertiesKt.setContentType((SemanticsPropertyReceiver)semanticsPropertyReceiver, (ContentType)ContentType.Companion.getEmailAddress());
        } else if (KeyboardType.equals-impl0((int)bl, (int)KeyboardType.Companion.getPassword-PjHm6EE()) || KeyboardType.equals-impl0((int)bl, (int)KeyboardType.Companion.getNumberPassword-PjHm6EE())) {
            SemanticsPropertiesKt.setContentType((SemanticsPropertyReceiver)semanticsPropertyReceiver, (ContentType)ContentType.Companion.getPassword());
        } else if (KeyboardType.equals-impl0((int)bl, (int)KeyboardType.Companion.getPhone-PjHm6EE())) {
            SemanticsPropertiesKt.setContentType((SemanticsPropertyReceiver)semanticsPropertyReceiver, (ContentType)ContentType.Companion.getPhoneNumber());
        }
        if (!this.enabled) {
            SemanticsPropertiesKt.disabled((SemanticsPropertyReceiver)semanticsPropertyReceiver);
        }
        if (this.isPassword) {
            SemanticsPropertiesKt.password((SemanticsPropertyReceiver)semanticsPropertyReceiver);
        }
        boolean bl2 = this.enabled && !this.readOnly;
        SemanticsPropertiesKt.setEditable((SemanticsPropertyReceiver)semanticsPropertyReceiver, (boolean)bl2);
        SemanticsPropertiesKt.getTextLayoutResult$default((SemanticsPropertyReceiver)semanticsPropertyReceiver, null, arg_0 -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$2(this, arg_0), (int)1, null);
        if (bl2) {
            SemanticsPropertiesKt.setText$default((SemanticsPropertyReceiver)semanticsPropertyReceiver, null, arg_0 -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$3(this, arg_0), (int)1, null);
            SemanticsPropertiesKt.insertTextAtCursor$default((SemanticsPropertyReceiver)semanticsPropertyReceiver, null, arg_0 -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$4(this, semanticsPropertyReceiver, arg_0), (int)1, null);
        }
        SemanticsPropertiesKt.setSelection$default((SemanticsPropertyReceiver)semanticsPropertyReceiver, null, (arg_0, arg_1, arg_2) -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$5(this, arg_0, arg_1, arg_2), (int)1, null);
        SemanticsPropertiesKt.onImeAction-9UiTYpY$default((SemanticsPropertyReceiver)semanticsPropertyReceiver, (int)this.imeOptions.getImeAction-eUduSuo(), null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$6(this), (int)2, null);
        SemanticsPropertiesKt.onClick$default((SemanticsPropertyReceiver)semanticsPropertyReceiver, null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$7(this), (int)1, null);
        SemanticsPropertiesKt.onLongClick$default((SemanticsPropertyReceiver)semanticsPropertyReceiver, null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$8(this), (int)1, null);
        if (!TextRange.getCollapsed-impl((long)this.value.getSelection-d9O1mEE()) && !this.isPassword) {
            SemanticsPropertiesKt.copyText$default((SemanticsPropertyReceiver)semanticsPropertyReceiver, null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$9(this), (int)1, null);
            if (this.enabled && !this.readOnly) {
                SemanticsPropertiesKt.cutText$default((SemanticsPropertyReceiver)semanticsPropertyReceiver, null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$10(this), (int)1, null);
            }
        }
        if (this.enabled && !this.readOnly) {
            SemanticsPropertiesKt.pasteText$default((SemanticsPropertyReceiver)semanticsPropertyReceiver, null, () -> CoreTextFieldSemanticsModifierNode.applySemantics$lambda$11(this), (int)1, null);
        }
    }

    public final void updateNodeSemantics(TransformedText transformedText, TextFieldValue textFieldValue, LegacyTextFieldState legacyTextFieldState, boolean bl, boolean bl2, boolean bl3, OffsetMapping offsetMapping, TextFieldSelectionManager textFieldSelectionManager, ImeOptions imeOptions, FocusRequester focusRequester) {
        Intrinsics.checkNotNullParameter((Object)transformedText, (String)"");
        Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"");
        Intrinsics.checkNotNullParameter((Object)legacyTextFieldState, (String)"");
        Intrinsics.checkNotNullParameter((Object)offsetMapping, (String)"");
        Intrinsics.checkNotNullParameter((Object)textFieldSelectionManager, (String)"");
        Intrinsics.checkNotNullParameter((Object)imeOptions, (String)"");
        Intrinsics.checkNotNullParameter((Object)focusRequester, (String)"");
        boolean bl4 = this.enabled && !this.readOnly;
        boolean bl5 = this.enabled;
        boolean bl6 = this.isPassword;
        ImeOptions imeOptions2 = this.imeOptions;
        TextFieldSelectionManager textFieldSelectionManager2 = this.manager;
        boolean bl7 = bl2 && !bl;
        this.transformedText = transformedText;
        this.value = textFieldValue;
        this.state = legacyTextFieldState;
        this.readOnly = bl;
        this.enabled = bl2;
        this.offsetMapping = offsetMapping;
        this.manager = textFieldSelectionManager;
        this.imeOptions = imeOptions;
        this.focusRequester = focusRequester;
        if (bl2 != bl5 || bl7 != bl4 || !Intrinsics.areEqual((Object)imeOptions, (Object)imeOptions2) || bl3 != bl6 || !TextRange.getCollapsed-impl((long)textFieldValue.getSelection-d9O1mEE())) {
            SemanticsModifierNodeKt.invalidateSemantics((SemanticsModifierNode)this);
        }
        if (!Intrinsics.areEqual((Object)textFieldSelectionManager, (Object)textFieldSelectionManager2)) {
            textFieldSelectionManager.setRequestAutofillAction$foundation((Function0<Unit>)((Function0)() -> CoreTextFieldSemanticsModifierNode.updateNodeSemantics$lambda$0(this)));
        }
    }

    private final void handleTextUpdateFromSemantics(LegacyTextFieldState legacyTextFieldState, String string, boolean bl, boolean bl2) {
        if (bl || !bl2) {
            return;
        }
        TextInputSession textInputSession = legacyTextFieldState.getInputSession();
        if (textInputSession != null) {
            TextInputSession textInputSession2 = textInputSession;
            boolean bl3 = false;
            Object[] objectArray = new EditCommand[]{new DeleteAllCommand(), new CommitTextCommand(string, 1)};
            TextFieldDelegate.Companion.onEditCommand$foundation(CollectionsKt.listOf((Object[])objectArray), legacyTextFieldState.getProcessor(), legacyTextFieldState.getOnValueChange(), textInputSession2);
        } else {
            CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode = this;
            boolean bl4 = false;
            legacyTextFieldState.getOnValueChange().invoke((Object)new TextFieldValue(string, TextRangeKt.TextRange((int)string.length()), null, 4, null));
        }
    }

    private static final Unit _init_$lambda$0(CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode) {
        DelegatableNodeKt.requestAutofill((DelegatableNode)((DelegatableNode)coreTextFieldSemanticsModifierNode));
        return Unit.INSTANCE;
    }

    private static final boolean applySemantics$lambda$1(CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode, FillableData fillableData) {
        Intrinsics.checkNotNullParameter((Object)fillableData, (String)"");
        coreTextFieldSemanticsModifierNode.state.setJustAutofilled(true);
        coreTextFieldSemanticsModifierNode.state.setAutofillHighlightOn(true);
        LegacyTextFieldState legacyTextFieldState = coreTextFieldSemanticsModifierNode.state;
        CharSequence charSequence = fillableData.getTextValue();
        Intrinsics.checkNotNull((Object)charSequence);
        coreTextFieldSemanticsModifierNode.handleTextUpdateFromSemantics(legacyTextFieldState, (String)charSequence, coreTextFieldSemanticsModifierNode.readOnly, coreTextFieldSemanticsModifierNode.enabled);
        return true;
    }

    private static final boolean applySemantics$lambda$2(CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode, List list) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)list, (String)"");
        if (coreTextFieldSemanticsModifierNode.state.getLayoutResult() != null) {
            TextLayoutResultProxy textLayoutResultProxy = coreTextFieldSemanticsModifierNode.state.getLayoutResult();
            Intrinsics.checkNotNull((Object)textLayoutResultProxy);
            list.add(textLayoutResultProxy.getValue());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean applySemantics$lambda$3(CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode, AnnotatedString annotatedString) {
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"");
        coreTextFieldSemanticsModifierNode.handleTextUpdateFromSemantics(coreTextFieldSemanticsModifierNode.state, annotatedString.getText(), coreTextFieldSemanticsModifierNode.readOnly, coreTextFieldSemanticsModifierNode.enabled);
        return true;
    }

    private static final boolean applySemantics$lambda$4(CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode, SemanticsPropertyReceiver semanticsPropertyReceiver, AnnotatedString annotatedString) {
        Intrinsics.checkNotNullParameter((Object)annotatedString, (String)"");
        if (coreTextFieldSemanticsModifierNode.readOnly || !coreTextFieldSemanticsModifierNode.enabled) {
            return false;
        }
        TextInputSession textInputSession = coreTextFieldSemanticsModifierNode.state.getInputSession();
        if (textInputSession != null) {
            TextInputSession textInputSession2 = textInputSession;
            boolean bl = false;
            Object[] objectArray = new EditCommand[]{new FinishComposingTextCommand(), new CommitTextCommand(annotatedString, 1)};
            TextFieldDelegate.Companion.onEditCommand$foundation(CollectionsKt.listOf((Object[])objectArray), coreTextFieldSemanticsModifierNode.state.getProcessor(), coreTextFieldSemanticsModifierNode.state.getOnValueChange(), textInputSession2);
        } else {
            SemanticsPropertyReceiver semanticsPropertyReceiver2 = semanticsPropertyReceiver;
            boolean bl = false;
            String string = coreTextFieldSemanticsModifierNode.value.getText();
            int n2 = TextRange.getStart-impl((long)coreTextFieldSemanticsModifierNode.value.getSelection-d9O1mEE());
            int n3 = TextRange.getEnd-impl((long)coreTextFieldSemanticsModifierNode.value.getSelection-d9O1mEE());
            String string2 = ((Object)StringsKt.replaceRange((CharSequence)string, (int)n2, (int)n3, (CharSequence)((CharSequence)annotatedString))).toString();
            long l2 = TextRangeKt.TextRange((int)(TextRange.getStart-impl((long)coreTextFieldSemanticsModifierNode.value.getSelection-d9O1mEE()) + annotatedString.length()));
            coreTextFieldSemanticsModifierNode.state.getOnValueChange().invoke((Object)new TextFieldValue(string2, l2, null, 4, null));
        }
        return true;
    }

    private static final boolean applySemantics$lambda$5(CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode, int n2, int n3, boolean bl) {
        boolean bl2;
        int n4;
        int n5 = bl ? n2 : coreTextFieldSemanticsModifierNode.offsetMapping.transformedToOriginal(n2);
        int n6 = n4 = bl ? n3 : coreTextFieldSemanticsModifierNode.offsetMapping.transformedToOriginal(n3);
        if (!coreTextFieldSemanticsModifierNode.enabled) {
            bl2 = false;
        } else if (n5 == TextRange.getStart-impl((long)coreTextFieldSemanticsModifierNode.value.getSelection-d9O1mEE()) && n4 == TextRange.getEnd-impl((long)coreTextFieldSemanticsModifierNode.value.getSelection-d9O1mEE())) {
            bl2 = false;
        } else if (Math.min(n5, n4) >= 0 && Math.max(n5, n4) <= coreTextFieldSemanticsModifierNode.value.getAnnotatedString().length()) {
            if (bl || n5 == n4) {
                coreTextFieldSemanticsModifierNode.manager.exitSelectionMode$foundation();
            } else {
                TextFieldSelectionManager.enterSelectionMode$foundation$default(coreTextFieldSemanticsModifierNode.manager, false, 1, null);
            }
            coreTextFieldSemanticsModifierNode.state.getOnValueChange().invoke((Object)new TextFieldValue(coreTextFieldSemanticsModifierNode.value.getAnnotatedString(), TextRangeKt.TextRange((int)n5, (int)n4), null, 4, null));
            bl2 = true;
        } else {
            coreTextFieldSemanticsModifierNode.manager.exitSelectionMode$foundation();
            bl2 = false;
        }
        return bl2;
    }

    private static final boolean applySemantics$lambda$6(CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode) {
        coreTextFieldSemanticsModifierNode.state.getOnImeActionPerformed().invoke((Object)ImeAction.box-impl((int)coreTextFieldSemanticsModifierNode.imeOptions.getImeAction-eUduSuo()));
        return true;
    }

    private static final boolean applySemantics$lambda$7(CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode) {
        CoreTextFieldKt.requestFocusAndShowKeyboardIfNeeded(coreTextFieldSemanticsModifierNode.state, coreTextFieldSemanticsModifierNode.focusRequester, !coreTextFieldSemanticsModifierNode.readOnly);
        return true;
    }

    private static final boolean applySemantics$lambda$8(CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode) {
        TextFieldSelectionManager.enterSelectionMode$foundation$default(coreTextFieldSemanticsModifierNode.manager, false, 1, null);
        return true;
    }

    private static final boolean applySemantics$lambda$9(CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode) {
        TextFieldSelectionManager.copy$foundation$default(coreTextFieldSemanticsModifierNode.manager, false, 1, null);
        return true;
    }

    private static final boolean applySemantics$lambda$10(CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode) {
        coreTextFieldSemanticsModifierNode.manager.cut$foundation();
        return true;
    }

    private static final boolean applySemantics$lambda$11(CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode) {
        coreTextFieldSemanticsModifierNode.manager.paste$foundation();
        return true;
    }

    private static final Unit updateNodeSemantics$lambda$0(CoreTextFieldSemanticsModifierNode coreTextFieldSemanticsModifierNode) {
        DelegatableNodeKt.requestAutofill((DelegatableNode)((DelegatableNode)coreTextFieldSemanticsModifierNode));
        return Unit.INSTANCE;
    }
}

