/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.text.StringHelpers_skikoKt;
import androidx.compose.foundation.text.selection.BoundaryFunction;
import androidx.compose.foundation.text.selection.CrossStatus;
import androidx.compose.foundation.text.selection.SelectableInfo;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayout;
import androidx.compose.foundation.text.selection.SelectionLayoutKt;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\u0006\u001a\u00020\u0007*\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002\u001a4\u0010\u000b\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a,\u0010\u0015\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0014\u0010\u0017\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0000\u001a\u0014\u0010\u0018\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0002\u001a\u001c\u0010\u0019\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\tH\u0002\u00a8\u0006\u001b\u00b2\u0006\n\u0010\u001c\u001a\u00020\tX\u008a\u0084\u0002\u00b2\u0006\n\u0010\u001d\u001a\u00020\u0001X\u008a\u0084\u0002"}, d2={"updateSelectionBoundary", "Landroidx/compose/foundation/text/selection/Selection$AnchorInfo;", "Landroidx/compose/foundation/text/selection/SelectionLayout;", "info", "Landroidx/compose/foundation/text/selection/SelectableInfo;", "previousSelectionAnchor", "isExpanding", "", "currentRawOffset", "", "isStart", "snapToWordBoundary", "currentLine", "currentOffset", "otherOffset", "crossed", "adjustToBoundaries", "Landroidx/compose/foundation/text/selection/Selection;", "layout", "boundaryFunction", "Landroidx/compose/foundation/text/selection/BoundaryFunction;", "anchorOnBoundary", "slot", "ensureAtLeastOneChar", "expandOneChar", "changeOffset", "newOffset", "foundation", "currentRawLine", "anchorSnappedToWordBoundary"})
public final class SelectionAdjustmentKt {
    private static final Selection.AnchorInfo updateSelectionBoundary(SelectionLayout selectionLayout, SelectableInfo selectableInfo, Selection.AnchorInfo anchorInfo) {
        int n2;
        int n3 = selectionLayout.isStartHandle() ? selectableInfo.getRawStartHandleOffset() : selectableInfo.getRawEndHandleOffset();
        int n4 = n2 = selectionLayout.isStartHandle() ? selectionLayout.getStartSlot() : selectionLayout.getEndSlot();
        if (n2 != selectableInfo.getSlot()) {
            return selectableInfo.anchorForOffset(n3);
        }
        Lazy lazy = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> SelectionAdjustmentKt.updateSelectionBoundary$lambda$0(selectableInfo, n3));
        int n5 = selectionLayout.isStartHandle() ? selectableInfo.getRawEndHandleOffset() : selectableInfo.getRawStartHandleOffset();
        Lazy lazy2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> SelectionAdjustmentKt.updateSelectionBoundary$lambda$2(selectableInfo, n3, n5, selectionLayout, lazy));
        if (selectableInfo.getSelectableId() != anchorInfo.getSelectableId()) {
            return SelectionAdjustmentKt.updateSelectionBoundary$lambda$3((Lazy<Selection.AnchorInfo>)lazy2);
        }
        int n6 = selectableInfo.getRawPreviousHandleOffset();
        if (n3 == n6) {
            return anchorInfo;
        }
        int n7 = selectableInfo.getTextLayoutResult().getLineForOffset(n6);
        if (SelectionAdjustmentKt.updateSelectionBoundary$lambda$1((Lazy<Integer>)lazy) != n7) {
            return SelectionAdjustmentKt.updateSelectionBoundary$lambda$3((Lazy<Selection.AnchorInfo>)lazy2);
        }
        int n8 = anchorInfo.getOffset();
        long l2 = selectableInfo.getTextLayoutResult().getWordBoundary--jx7JFs(n8);
        if (!SelectionAdjustmentKt.isExpanding(selectableInfo, n3, selectionLayout.isStartHandle())) {
            return selectableInfo.anchorForOffset(n3);
        }
        if (n8 == TextRange.getStart-impl((long)l2) || n8 == TextRange.getEnd-impl((long)l2)) {
            return SelectionAdjustmentKt.updateSelectionBoundary$lambda$3((Lazy<Selection.AnchorInfo>)lazy2);
        }
        return selectableInfo.anchorForOffset(n3);
    }

    private static final boolean isExpanding(SelectableInfo selectableInfo, int n2, boolean bl) {
        boolean bl2;
        if (selectableInfo.getRawPreviousHandleOffset() == -1) {
            return true;
        }
        if (n2 == selectableInfo.getRawPreviousHandleOffset()) {
            return false;
        }
        boolean bl3 = bl2 = selectableInfo.getRawCrossStatus() == CrossStatus.CROSSED;
        return bl ^ bl2 ? n2 < selectableInfo.getRawPreviousHandleOffset() : n2 > selectableInfo.getRawPreviousHandleOffset();
    }

    private static final Selection.AnchorInfo snapToWordBoundary(SelectableInfo selectableInfo, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5;
        long l2 = selectableInfo.getTextLayoutResult().getWordBoundary--jx7JFs(n3);
        int n6 = selectableInfo.getTextLayoutResult().getLineForOffset(TextRange.getStart-impl((long)l2));
        int n7 = n6 == n2 ? TextRange.getStart-impl((long)l2) : (n2 >= selectableInfo.getTextLayoutResult().getLineCount() ? selectableInfo.getTextLayoutResult().getLineStart(selectableInfo.getTextLayoutResult().getLineCount() - 1) : selectableInfo.getTextLayoutResult().getLineStart(n2));
        int n8 = selectableInfo.getTextLayoutResult().getLineForOffset(TextRange.getEnd-impl((long)l2));
        int n9 = n8 == n2 ? TextRange.getEnd-impl((long)l2) : (n5 = n2 >= selectableInfo.getTextLayoutResult().getLineCount() ? TextLayoutResult.getLineEnd$default((TextLayoutResult)selectableInfo.getTextLayoutResult(), (int)(selectableInfo.getTextLayoutResult().getLineCount() - 1), (boolean)false, (int)2, null) : TextLayoutResult.getLineEnd$default((TextLayoutResult)selectableInfo.getTextLayoutResult(), (int)n2, (boolean)false, (int)2, null));
        if (n7 == n4) {
            return selectableInfo.anchorForOffset(n5);
        }
        if (n5 == n4) {
            return selectableInfo.anchorForOffset(n7);
        }
        int n10 = bl ^ bl2 ? (n3 <= n5 ? n7 : n5) : (n3 >= n7 ? n5 : n7);
        return selectableInfo.anchorForOffset(n10);
    }

    private static final Selection adjustToBoundaries(SelectionLayout selectionLayout, BoundaryFunction boundaryFunction) {
        boolean bl = selectionLayout.getCrossStatus() == CrossStatus.CROSSED;
        return new Selection(SelectionAdjustmentKt.anchorOnBoundary(selectionLayout.getStartInfo(), bl, true, selectionLayout.getStartSlot(), boundaryFunction), SelectionAdjustmentKt.anchorOnBoundary(selectionLayout.getEndInfo(), bl, false, selectionLayout.getEndSlot(), boundaryFunction), bl);
    }

    private static final Selection.AnchorInfo anchorOnBoundary(SelectableInfo selectableInfo, boolean bl, boolean bl2, int n2, BoundaryFunction boundaryFunction) {
        int n3;
        int n4 = n3 = bl2 ? selectableInfo.getRawStartHandleOffset() : selectableInfo.getRawEndHandleOffset();
        if (n2 != selectableInfo.getSlot()) {
            return selectableInfo.anchorForOffset(n3);
        }
        BoundaryFunction boundaryFunction2 = boundaryFunction;
        boolean bl3 = false;
        long l2 = boundaryFunction2.getBoundary-fzxv0v0(selectableInfo, n3);
        return selectableInfo.anchorForOffset(bl2 ^ bl ? TextRange.getStart-impl((long)l2) : TextRange.getEnd-impl((long)l2));
    }

    public static final Selection ensureAtLeastOneChar(Selection selection, SelectionLayout selectionLayout) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"");
        Intrinsics.checkNotNullParameter((Object)selectionLayout, (String)"");
        if (!SelectionLayoutKt.isCollapsed(selection, selectionLayout)) {
            return selection;
        }
        String string = selectionLayout.getCurrentInfo().getInputText();
        if (selectionLayout.getSize() > 1 || selectionLayout.getPreviousSelection() == null || ((CharSequence)string).length() == 0) {
            return selection;
        }
        return SelectionAdjustmentKt.expandOneChar(selection, selectionLayout);
    }

    private static final Selection expandOneChar(Selection selection, SelectionLayout selectionLayout) {
        Selection selection2;
        SelectableInfo selectableInfo = selectionLayout.getCurrentInfo();
        String string = selectableInfo.getInputText();
        int n2 = selectableInfo.getRawStartHandleOffset();
        int n3 = string.length();
        int n4 = n2;
        if (n4 == 0) {
            int n5 = StringHelpers_skikoKt.findFollowingBreak(string, 0);
            selection2 = selectionLayout.isStartHandle() ? Selection.copy$default(selection, SelectionAdjustmentKt.changeOffset(selection.getStart(), selectableInfo, n5), null, true, 2, null) : Selection.copy$default(selection, null, SelectionAdjustmentKt.changeOffset(selection.getEnd(), selectableInfo, n5), false, 1, null);
        } else if (n4 == n3) {
            int n6 = StringHelpers_skikoKt.findPrecedingBreak(string, n3);
            selection2 = selectionLayout.isStartHandle() ? Selection.copy$default(selection, SelectionAdjustmentKt.changeOffset(selection.getStart(), selectableInfo, n6), null, false, 2, null) : Selection.copy$default(selection, null, SelectionAdjustmentKt.changeOffset(selection.getEnd(), selectableInfo, n6), true, 1, null);
        } else {
            Selection selection3 = selectionLayout.getPreviousSelection();
            boolean bl = selection3 != null ? selection3.getHandlesCrossed() : false;
            int n7 = selectionLayout.isStartHandle() ^ bl ? StringHelpers_skikoKt.findPrecedingBreak(string, n2) : StringHelpers_skikoKt.findFollowingBreak(string, n2);
            selection2 = selectionLayout.isStartHandle() ? Selection.copy$default(selection, SelectionAdjustmentKt.changeOffset(selection.getStart(), selectableInfo, n7), null, bl, 2, null) : Selection.copy$default(selection, null, SelectionAdjustmentKt.changeOffset(selection.getEnd(), selectableInfo, n7), bl, 1, null);
        }
        return selection2;
    }

    private static final Selection.AnchorInfo changeOffset(Selection.AnchorInfo anchorInfo, SelectableInfo selectableInfo, int n2) {
        return Selection.AnchorInfo.copy$default(anchorInfo, selectableInfo.getTextLayoutResult().getBidiRunDirection(n2), n2, 0L, 4, null);
    }

    private static final int updateSelectionBoundary$lambda$0(SelectableInfo selectableInfo, int n2) {
        return selectableInfo.getTextLayoutResult().getLineForOffset(n2);
    }

    private static final int updateSelectionBoundary$lambda$1(Lazy<Integer> lazy) {
        Lazy<Integer> lazy2 = lazy;
        return ((Number)lazy2.getValue()).intValue();
    }

    private static final Selection.AnchorInfo updateSelectionBoundary$lambda$2(SelectableInfo selectableInfo, int n2, int n3, SelectionLayout selectionLayout, Lazy lazy) {
        return SelectionAdjustmentKt.snapToWordBoundary(selectableInfo, SelectionAdjustmentKt.updateSelectionBoundary$lambda$1((Lazy<Integer>)lazy), n2, n3, selectionLayout.isStartHandle(), selectionLayout.getCrossStatus() == CrossStatus.CROSSED);
    }

    private static final Selection.AnchorInfo updateSelectionBoundary$lambda$3(Lazy<Selection.AnchorInfo> lazy) {
        Lazy<Selection.AnchorInfo> lazy2 = lazy;
        return (Selection.AnchorInfo)lazy2.getValue();
    }

    public static final /* synthetic */ Selection access$adjustToBoundaries(SelectionLayout selectionLayout, BoundaryFunction boundaryFunction) {
        return SelectionAdjustmentKt.adjustToBoundaries(selectionLayout, boundaryFunction);
    }

    public static final /* synthetic */ Selection.AnchorInfo access$updateSelectionBoundary(SelectionLayout selectionLayout, SelectableInfo selectableInfo, Selection.AnchorInfo anchorInfo) {
        return SelectionAdjustmentKt.updateSelectionBoundary(selectionLayout, selectableInfo, anchorInfo);
    }
}

