/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0019\u0010\u0003\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0011\u0010\u0005\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u001f\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0003\u0010\b\u001a\u0013\u0010\t\u001a\u00020\u0000*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\t\u0010\u0006\u001a\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0013\u0010\u0010\u001a\u00020\u000f*\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u0013\u0010\u0012\u001a\u00020\u000f*\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0011\u001a\u0013\u0010\f\u001a\u00020\u0000*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\f\u0010\u0006\u00a8\u0006\u0013"}, d2={"Ljava/io/File;", "", "relativePath", "combineSafe", "(Ljava/io/File;Ljava/lang/String;)Ljava/io/File;", "normalizeAndRelativize", "(Ljava/io/File;)Ljava/io/File;", "dir", "(Ljava/io/File;Ljava/io/File;)Ljava/io/File;", "notRooted", "path", "", "dropLeadingTopDirs", "(Ljava/lang/String;)I", "", "", "isPathSeparator", "(C)Z", "isPathSeparatorOrDot", "ktor-utils"})
public final class PathKt {
    public static final File combineSafe(File file, String string) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        return PathKt.combineSafe(file, new File(string));
    }

    public static final File normalizeAndRelativize(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"");
        return PathKt.dropLeadingTopDirs(PathKt.notRooted(FilesKt.normalize((File)file)));
    }

    private static final File combineSafe(File file, File file2) {
        File file3 = PathKt.normalizeAndRelativize(file2);
        if (FilesKt.startsWith((File)file3, (String)"..")) {
            throw new IllegalArgumentException("Bad relative path " + file2);
        }
        if (!(!file3.isAbsolute())) {
            boolean bl = false;
            String string = "Bad relative path " + file2;
            throw new IllegalStateException(string.toString());
        }
        return new File(file, file3.getPath());
    }

    private static final File notRooted(File file) {
        String string;
        block3: {
            String string2;
            if (!FilesKt.isRooted((File)file)) {
                return file;
            }
            File file2 = file;
            while (file2.getParentFile() != null) {
                file2 = string2;
            }
            String string3 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
            string2 = StringsKt.drop((String)string3, (int)file2.getName().length());
            boolean bl = false;
            int n = ((CharSequence)string2).length();
            for (int k = 0; k < n; ++k) {
                char c = string2.charAt(k);
                boolean bl2 = false;
                if (c == '\\' || c == '/') continue;
                String string4 = string2.substring(k);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
                break block3;
            }
            string = "";
        }
        String string5 = string;
        return new File(string5);
    }

    public static final int dropLeadingTopDirs(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        int n = 0;
        int n2 = string.length() - 1;
        while (n <= n2) {
            int n3;
            char c = string.charAt(n);
            if (PathKt.isPathSeparator(c)) {
                ++n;
                continue;
            }
            if (c != '.') break;
            if (n == n2) {
                ++n;
                break;
            }
            char c2 = string.charAt(n + 1);
            if (PathKt.isPathSeparator(c2)) {
                n3 = 2;
            } else {
                if (c2 != '.') break;
                if (n + 2 == string.length()) {
                    n3 = 2;
                } else {
                    if (!PathKt.isPathSeparator(string.charAt(n + 2))) break;
                    n3 = 3;
                }
            }
            n = n + n3;
        }
        return n;
    }

    private static final boolean isPathSeparator(char c) {
        return c == '\\' || c == '/';
    }

    private static final boolean isPathSeparatorOrDot(char c) {
        return c == '.' || PathKt.isPathSeparator(c);
    }

    private static final File dropLeadingTopDirs(File file) {
        int n;
        String string = file.getPath();
        if (string == null) {
            string = "";
        }
        if ((n = PathKt.dropLeadingTopDirs(string)) == 0) {
            return file;
        }
        if (n >= file.getPath().length()) {
            return new File(".");
        }
        String string2 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
        return new File(string3);
    }
}

