/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.utils.CollectionsKt;

public final class StandardNames {
    public static final StandardNames INSTANCE = new StandardNames();
    public static final Name BACKING_FIELD;
    public static final Name DEFAULT_VALUE_PARAMETER;
    public static final Name ENUM_VALUES;
    public static final Name ENUM_ENTRIES;
    public static final Name ENUM_VALUE_OF;
    public static final Name DATA_CLASS_COPY;
    public static final String DATA_CLASS_COMPONENT_PREFIX;
    public static final Name HASHCODE_NAME;
    public static final Name TO_STRING_NAME;
    public static final Name EQUALS_NAME;
    public static final Name CHAR_CODE;
    public static final Name NAME;
    public static final Name MAIN;
    public static final Name NEXT_CHAR;
    public static final Name IMPLICIT_LAMBDA_PARAMETER_NAME;
    public static final Name CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME;
    public static final FqName DYNAMIC_FQ_NAME;
    public static final FqName COROUTINES_PACKAGE_FQ_NAME;
    public static final FqName COROUTINES_JVM_INTERNAL_PACKAGE_FQ_NAME;
    public static final FqName COROUTINES_INTRINSICS_PACKAGE_FQ_NAME;
    public static final FqName CONTINUATION_INTERFACE_FQ_NAME;
    public static final FqName RESULT_FQ_NAME;
    public static final FqName KOTLIN_REFLECT_FQ_NAME;
    public static final List<String> PREFIXES;
    public static final Name BUILT_INS_PACKAGE_NAME;
    public static final FqName BUILT_INS_PACKAGE_FQ_NAME;
    public static final FqName ANNOTATION_PACKAGE_FQ_NAME;
    public static final FqName COLLECTIONS_PACKAGE_FQ_NAME;
    public static final FqName RANGES_PACKAGE_FQ_NAME;
    public static final FqName TEXT_PACKAGE_FQ_NAME;
    public static final FqName KOTLIN_INTERNAL_FQ_NAME;
    private static final FqName NON_EXISTENT_CLASS;
    public static final Set<FqName> BUILT_INS_PACKAGE_FQ_NAMES;

    private StandardNames() {
    }

    @JvmStatic
    public static final String getFunctionName(int n) {
        return "Function" + n;
    }

    @JvmStatic
    public static final ClassId getFunctionClassId(int n) {
        Name name = Name.identifier(StandardNames.getFunctionName(n));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        return new ClassId(BUILT_INS_PACKAGE_FQ_NAME, name);
    }

    @JvmStatic
    public static final String getSuspendFunctionName(int n) {
        return FunctionTypeKind.SuspendFunction.INSTANCE.getClassNamePrefix() + n;
    }

    @JvmStatic
    public static final boolean isPrimitiveArray(FqNameUnsafe fqNameUnsafe) {
        Intrinsics.checkNotNullParameter((Object)fqNameUnsafe, (String)"");
        return FqNames.arrayClassFqNameToPrimitiveType.get(fqNameUnsafe) != null;
    }

    @JvmStatic
    public static final FqName getPrimitiveFqName(PrimitiveType primitiveType) {
        Intrinsics.checkNotNullParameter((Object)((Object)primitiveType), (String)"");
        return BUILT_INS_PACKAGE_FQ_NAME.child(primitiveType.getTypeName());
    }

    static {
        Name name = Name.identifier("field");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        BACKING_FIELD = name;
        Name name2 = Name.identifier("value");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"");
        DEFAULT_VALUE_PARAMETER = name2;
        Name name3 = Name.identifier("values");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"");
        ENUM_VALUES = name3;
        Name name4 = Name.identifier("entries");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"");
        ENUM_ENTRIES = name4;
        Name name5 = Name.identifier("valueOf");
        Intrinsics.checkNotNullExpressionValue((Object)name5, (String)"");
        ENUM_VALUE_OF = name5;
        Name name6 = Name.identifier("copy");
        Intrinsics.checkNotNullExpressionValue((Object)name6, (String)"");
        DATA_CLASS_COPY = name6;
        DATA_CLASS_COMPONENT_PREFIX = "component";
        Name name7 = Name.identifier("hashCode");
        Intrinsics.checkNotNullExpressionValue((Object)name7, (String)"");
        HASHCODE_NAME = name7;
        Name name8 = Name.identifier("toString");
        Intrinsics.checkNotNullExpressionValue((Object)name8, (String)"");
        TO_STRING_NAME = name8;
        Name name9 = Name.identifier("equals");
        Intrinsics.checkNotNullExpressionValue((Object)name9, (String)"");
        EQUALS_NAME = name9;
        Name name10 = Name.identifier("code");
        Intrinsics.checkNotNullExpressionValue((Object)name10, (String)"");
        CHAR_CODE = name10;
        Name name11 = Name.identifier("name");
        Intrinsics.checkNotNullExpressionValue((Object)name11, (String)"");
        NAME = name11;
        Name name12 = Name.identifier("main");
        Intrinsics.checkNotNullExpressionValue((Object)name12, (String)"");
        MAIN = name12;
        Name name13 = Name.identifier("nextChar");
        Intrinsics.checkNotNullExpressionValue((Object)name13, (String)"");
        NEXT_CHAR = name13;
        Name name14 = Name.identifier("it");
        Intrinsics.checkNotNullExpressionValue((Object)name14, (String)"");
        IMPLICIT_LAMBDA_PARAMETER_NAME = name14;
        Name name15 = Name.identifier("count");
        Intrinsics.checkNotNullExpressionValue((Object)name15, (String)"");
        CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME = name15;
        DYNAMIC_FQ_NAME = new FqName("<dynamic>");
        COROUTINES_PACKAGE_FQ_NAME = new FqName("kotlin.coroutines");
        COROUTINES_JVM_INTERNAL_PACKAGE_FQ_NAME = new FqName("kotlin.coroutines.jvm.internal");
        COROUTINES_INTRINSICS_PACKAGE_FQ_NAME = new FqName("kotlin.coroutines.intrinsics");
        Name name16 = Name.identifier("Continuation");
        Intrinsics.checkNotNullExpressionValue((Object)name16, (String)"");
        CONTINUATION_INTERFACE_FQ_NAME = COROUTINES_PACKAGE_FQ_NAME.child(name16);
        RESULT_FQ_NAME = new FqName("kotlin.Result");
        KOTLIN_REFLECT_FQ_NAME = new FqName("kotlin.reflect");
        Object[] objectArray = new String[]{"KProperty", "KMutableProperty", "KFunction", "KSuspendFunction"};
        PREFIXES = kotlin.collections.CollectionsKt.listOf((Object[])objectArray);
        Name name17 = Name.identifier("kotlin");
        Intrinsics.checkNotNullExpressionValue((Object)name17, (String)"");
        BUILT_INS_PACKAGE_NAME = name17;
        BUILT_INS_PACKAGE_FQ_NAME = FqName.Companion.topLevel(BUILT_INS_PACKAGE_NAME);
        Name name18 = Name.identifier("annotation");
        Intrinsics.checkNotNullExpressionValue((Object)name18, (String)"");
        ANNOTATION_PACKAGE_FQ_NAME = BUILT_INS_PACKAGE_FQ_NAME.child(name18);
        Name name19 = Name.identifier("collections");
        Intrinsics.checkNotNullExpressionValue((Object)name19, (String)"");
        COLLECTIONS_PACKAGE_FQ_NAME = BUILT_INS_PACKAGE_FQ_NAME.child(name19);
        Name name20 = Name.identifier("ranges");
        Intrinsics.checkNotNullExpressionValue((Object)name20, (String)"");
        RANGES_PACKAGE_FQ_NAME = BUILT_INS_PACKAGE_FQ_NAME.child(name20);
        Name name21 = Name.identifier("text");
        Intrinsics.checkNotNullExpressionValue((Object)name21, (String)"");
        TEXT_PACKAGE_FQ_NAME = BUILT_INS_PACKAGE_FQ_NAME.child(name21);
        Name name22 = Name.identifier("internal");
        Intrinsics.checkNotNullExpressionValue((Object)name22, (String)"");
        KOTLIN_INTERNAL_FQ_NAME = BUILT_INS_PACKAGE_FQ_NAME.child(name22);
        NON_EXISTENT_CLASS = new FqName("error.NonExistentClass");
        objectArray = new FqName[]{BUILT_INS_PACKAGE_FQ_NAME, COLLECTIONS_PACKAGE_FQ_NAME, RANGES_PACKAGE_FQ_NAME, ANNOTATION_PACKAGE_FQ_NAME, KOTLIN_REFLECT_FQ_NAME, KOTLIN_INTERNAL_FQ_NAME, COROUTINES_PACKAGE_FQ_NAME};
        BUILT_INS_PACKAGE_FQ_NAMES = SetsKt.setOf((Object[])objectArray);
    }

    public static final class FqNames {
        public static final FqNames INSTANCE;
        public static final FqNameUnsafe any;
        public static final FqNameUnsafe nothing;
        public static final FqNameUnsafe cloneable;
        public static final FqName suppress;
        public static final FqNameUnsafe unit;
        public static final FqNameUnsafe charSequence;
        public static final FqNameUnsafe string;
        public static final FqNameUnsafe array;
        public static final FqNameUnsafe _boolean;
        public static final FqNameUnsafe _char;
        public static final FqNameUnsafe _byte;
        public static final FqNameUnsafe _short;
        public static final FqNameUnsafe _int;
        public static final FqNameUnsafe _long;
        public static final FqNameUnsafe _float;
        public static final FqNameUnsafe _double;
        public static final FqNameUnsafe number;
        public static final FqNameUnsafe _enum;
        public static final FqNameUnsafe functionSupertype;
        public static final FqName throwable;
        public static final FqName comparable;
        public static final FqNameUnsafe intRange;
        public static final FqNameUnsafe longRange;
        public static final FqName deprecated;
        public static final FqName deprecatedSinceKotlin;
        public static final FqName deprecationLevel;
        public static final FqName replaceWith;
        public static final FqName extensionFunctionType;
        public static final FqName contextFunctionTypeParams;
        public static final FqName parameterName;
        public static final ClassId parameterNameClassId;
        public static final FqName annotation;
        public static final FqName target;
        public static final ClassId targetClassId;
        public static final FqName annotationTarget;
        public static final FqName annotationRetention;
        public static final FqName retention;
        public static final ClassId retentionClassId;
        public static final FqName repeatable;
        public static final ClassId repeatableClassId;
        public static final FqName mustBeDocumented;
        public static final FqName unsafeVariance;
        public static final FqName publishedApi;
        public static final FqName accessibleLateinitPropertyLiteral;
        public static final FqName platformDependent;
        public static final ClassId platformDependentClassId;
        public static final FqName iterator;
        public static final FqName iterable;
        public static final FqName collection;
        public static final FqName list;
        public static final FqName listIterator;
        public static final FqName set;
        public static final FqName map;
        public static final FqName mapEntry;
        public static final FqName mutableIterator;
        public static final FqName mutableIterable;
        public static final FqName mutableCollection;
        public static final FqName mutableList;
        public static final FqName mutableListIterator;
        public static final FqName mutableSet;
        public static final FqName mutableMap;
        public static final FqName mutableMapEntry;
        public static final FqNameUnsafe kClass;
        public static final FqNameUnsafe kType;
        public static final FqNameUnsafe kCallable;
        public static final FqNameUnsafe kProperty0;
        public static final FqNameUnsafe kProperty1;
        public static final FqNameUnsafe kProperty2;
        public static final FqNameUnsafe kMutableProperty0;
        public static final FqNameUnsafe kMutableProperty1;
        public static final FqNameUnsafe kMutableProperty2;
        public static final FqNameUnsafe kPropertyFqName;
        public static final FqNameUnsafe kMutablePropertyFqName;
        public static final ClassId kProperty;
        public static final FqNameUnsafe kDeclarationContainer;
        public static final FqNameUnsafe findAssociatedObject;
        public static final FqName uByteFqName;
        public static final FqName uShortFqName;
        public static final FqName uIntFqName;
        public static final FqName uLongFqName;
        public static final ClassId uByte;
        public static final ClassId uShort;
        public static final ClassId uInt;
        public static final ClassId uLong;
        public static final FqName uByteArrayFqName;
        public static final FqName uShortArrayFqName;
        public static final FqName uIntArrayFqName;
        public static final FqName uLongArrayFqName;
        public static final Set<Name> primitiveTypeShortNames;
        public static final Set<Name> primitiveArrayTypeShortNames;
        public static final Map<FqNameUnsafe, PrimitiveType> fqNameToPrimitiveType;
        public static final Map<FqNameUnsafe, PrimitiveType> arrayClassFqNameToPrimitiveType;

        private FqNames() {
        }

        private final FqNameUnsafe fqNameUnsafe(String string) {
            return this.fqName(string).toUnsafe();
        }

        private final FqName fqName(String string) {
            Name name = Name.identifier(string);
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            return BUILT_INS_PACKAGE_FQ_NAME.child(name);
        }

        private final FqName collectionsFqName(String string) {
            Name name = Name.identifier(string);
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            return COLLECTIONS_PACKAGE_FQ_NAME.child(name);
        }

        private final FqNameUnsafe rangesFqName(String string) {
            Name name = Name.identifier(string);
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            return RANGES_PACKAGE_FQ_NAME.child(name).toUnsafe();
        }

        @JvmStatic
        public static final FqNameUnsafe reflect(String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            Name name = Name.identifier(string);
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            return KOTLIN_REFLECT_FQ_NAME.child(name).toUnsafe();
        }

        private final FqName annotationName(String string) {
            Name name = Name.identifier(string);
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            return ANNOTATION_PACKAGE_FQ_NAME.child(name);
        }

        private final FqName internalName(String string) {
            Name name = Name.identifier(string);
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            return KOTLIN_INTERNAL_FQ_NAME.child(name);
        }

        static {
            boolean bl;
            Collection collection;
            PrimitiveType primitiveType;
            int n;
            Cloneable cloneable;
            INSTANCE = new FqNames();
            any = INSTANCE.fqNameUnsafe("Any");
            nothing = INSTANCE.fqNameUnsafe("Nothing");
            FqNames.cloneable = INSTANCE.fqNameUnsafe("Cloneable");
            suppress = INSTANCE.fqName("Suppress");
            unit = INSTANCE.fqNameUnsafe("Unit");
            charSequence = INSTANCE.fqNameUnsafe("CharSequence");
            string = INSTANCE.fqNameUnsafe("String");
            array = INSTANCE.fqNameUnsafe("Array");
            _boolean = INSTANCE.fqNameUnsafe("Boolean");
            _char = INSTANCE.fqNameUnsafe("Char");
            _byte = INSTANCE.fqNameUnsafe("Byte");
            _short = INSTANCE.fqNameUnsafe("Short");
            _int = INSTANCE.fqNameUnsafe("Int");
            _long = INSTANCE.fqNameUnsafe("Long");
            _float = INSTANCE.fqNameUnsafe("Float");
            _double = INSTANCE.fqNameUnsafe("Double");
            number = INSTANCE.fqNameUnsafe("Number");
            _enum = INSTANCE.fqNameUnsafe("Enum");
            functionSupertype = INSTANCE.fqNameUnsafe("Function");
            throwable = INSTANCE.fqName("Throwable");
            comparable = INSTANCE.fqName("Comparable");
            intRange = INSTANCE.rangesFqName("IntRange");
            longRange = INSTANCE.rangesFqName("LongRange");
            deprecated = INSTANCE.fqName("Deprecated");
            deprecatedSinceKotlin = INSTANCE.fqName("DeprecatedSinceKotlin");
            deprecationLevel = INSTANCE.fqName("DeprecationLevel");
            replaceWith = INSTANCE.fqName("ReplaceWith");
            extensionFunctionType = INSTANCE.fqName("ExtensionFunctionType");
            contextFunctionTypeParams = INSTANCE.fqName("ContextFunctionTypeParams");
            parameterName = INSTANCE.fqName("ParameterName");
            parameterNameClassId = ClassId.Companion.topLevel(parameterName);
            annotation = INSTANCE.fqName("Annotation");
            target = INSTANCE.annotationName("Target");
            targetClassId = ClassId.Companion.topLevel(target);
            annotationTarget = INSTANCE.annotationName("AnnotationTarget");
            annotationRetention = INSTANCE.annotationName("AnnotationRetention");
            retention = INSTANCE.annotationName("Retention");
            retentionClassId = ClassId.Companion.topLevel(retention);
            repeatable = INSTANCE.annotationName("Repeatable");
            repeatableClassId = ClassId.Companion.topLevel(repeatable);
            mustBeDocumented = INSTANCE.annotationName("MustBeDocumented");
            unsafeVariance = INSTANCE.fqName("UnsafeVariance");
            publishedApi = INSTANCE.fqName("PublishedApi");
            accessibleLateinitPropertyLiteral = INSTANCE.internalName("AccessibleLateinitPropertyLiteral");
            platformDependent = new FqName("kotlin.internal.PlatformDependent");
            platformDependentClassId = ClassId.Companion.topLevel(platformDependent);
            iterator = INSTANCE.collectionsFqName("Iterator");
            iterable = INSTANCE.collectionsFqName("Iterable");
            FqNames.collection = INSTANCE.collectionsFqName("Collection");
            list = INSTANCE.collectionsFqName("List");
            listIterator = INSTANCE.collectionsFqName("ListIterator");
            set = INSTANCE.collectionsFqName("Set");
            map = INSTANCE.collectionsFqName("Map");
            Name name = Name.identifier("Entry");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            mapEntry = map.child(name);
            mutableIterator = INSTANCE.collectionsFqName("MutableIterator");
            mutableIterable = INSTANCE.collectionsFqName("MutableIterable");
            mutableCollection = INSTANCE.collectionsFqName("MutableCollection");
            mutableList = INSTANCE.collectionsFqName("MutableList");
            mutableListIterator = INSTANCE.collectionsFqName("MutableListIterator");
            mutableSet = INSTANCE.collectionsFqName("MutableSet");
            mutableMap = INSTANCE.collectionsFqName("MutableMap");
            Name name2 = Name.identifier("MutableEntry");
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"");
            mutableMapEntry = mutableMap.child(name2);
            kClass = FqNames.reflect("KClass");
            kType = FqNames.reflect("KType");
            kCallable = FqNames.reflect("KCallable");
            kProperty0 = FqNames.reflect("KProperty0");
            kProperty1 = FqNames.reflect("KProperty1");
            kProperty2 = FqNames.reflect("KProperty2");
            kMutableProperty0 = FqNames.reflect("KMutableProperty0");
            kMutableProperty1 = FqNames.reflect("KMutableProperty1");
            kMutableProperty2 = FqNames.reflect("KMutableProperty2");
            kPropertyFqName = FqNames.reflect("KProperty");
            kMutablePropertyFqName = FqNames.reflect("KMutableProperty");
            kProperty = ClassId.Companion.topLevel(kPropertyFqName.toSafe());
            kDeclarationContainer = FqNames.reflect("KDeclarationContainer");
            findAssociatedObject = FqNames.reflect("findAssociatedObject");
            uByteFqName = INSTANCE.fqName("UByte");
            uShortFqName = INSTANCE.fqName("UShort");
            uIntFqName = INSTANCE.fqName("UInt");
            uLongFqName = INSTANCE.fqName("ULong");
            uByte = ClassId.Companion.topLevel(uByteFqName);
            uShort = ClassId.Companion.topLevel(uShortFqName);
            uInt = ClassId.Companion.topLevel(uIntFqName);
            uLong = ClassId.Companion.topLevel(uLongFqName);
            uByteArrayFqName = INSTANCE.fqName("UByteArray");
            uShortArrayFqName = INSTANCE.fqName("UShortArray");
            uIntArrayFqName = INSTANCE.fqName("UIntArray");
            uLongArrayFqName = INSTANCE.fqName("ULongArray");
            HashSet hashSet = cloneable = CollectionsKt.newHashSetWithExpectedSize(PrimitiveType.values().length);
            boolean bl2 = false;
            PrimitiveType[] primitiveTypeArray = PrimitiveType.values();
            int n2 = 0;
            int n3 = primitiveTypeArray.length;
            for (n = 0; n < n3; ++n) {
                PrimitiveType object2;
                primitiveType = object2 = primitiveTypeArray[n];
                collection = hashSet;
                bl = false;
                collection.add(primitiveType.getTypeName());
            }
            primitiveTypeShortNames = cloneable;
            hashSet = cloneable = CollectionsKt.newHashSetWithExpectedSize(PrimitiveType.values().length);
            bl2 = false;
            primitiveTypeArray = PrimitiveType.values();
            n2 = 0;
            n3 = primitiveTypeArray.length;
            for (n = 0; n < n3; ++n) {
                PrimitiveType primitiveType2;
                primitiveType = primitiveType2 = primitiveTypeArray[n];
                collection = hashSet;
                bl = false;
                collection.add(primitiveType.getArrayTypeName());
            }
            primitiveArrayTypeShortNames = cloneable;
            hashSet = cloneable = CollectionsKt.newHashMapWithExpectedSize(PrimitiveType.values().length);
            bl2 = false;
            for (PrimitiveType primitiveType2 : PrimitiveType.values()) {
                Map map = (Map)((Object)hashSet);
                String string = primitiveType2.getTypeName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                map.put(INSTANCE.fqNameUnsafe(string), primitiveType2);
            }
            fqNameToPrimitiveType = (Map)((Object)cloneable);
            hashSet = cloneable = CollectionsKt.newHashMapWithExpectedSize(PrimitiveType.values().length);
            bl2 = false;
            for (PrimitiveType primitiveType3 : PrimitiveType.values()) {
                Map map = (Map)((Object)hashSet);
                String string = primitiveType3.getArrayTypeName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                map.put(INSTANCE.fqNameUnsafe(string), primitiveType3);
            }
            arrayClassFqNameToPrimitiveType = (Map)((Object)cloneable);
        }
    }
}

