/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.UnsignedArrayType;
import kotlin.reflect.jvm.internal.impl.builtins.UnsignedType;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;

public final class UnsignedTypes {
    public static final UnsignedTypes INSTANCE;
    private static final Set<Name> unsignedTypeNames;
    private static final Set<Name> unsignedArrayTypeNames;
    private static final HashMap<ClassId, ClassId> arrayClassIdToUnsignedClassId;
    private static final HashMap<ClassId, ClassId> unsignedClassIdToArrayClassId;
    private static final HashMap<UnsignedArrayType, Name> unsignedArrayTypeToArrayCall;
    private static final Set<Name> arrayClassesShortNames;

    private UnsignedTypes() {
    }

    public final boolean isShortNameOfUnsignedArray(Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        return arrayClassesShortNames.contains(name);
    }

    public final ClassId getUnsignedClassIdByArrayClassId(ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        return arrayClassIdToUnsignedClassId.get(classId);
    }

    @JvmStatic
    public static final boolean isUnsignedType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        if (TypeUtils.noExpectedType(kotlinType)) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
        return INSTANCE.isUnsignedClass(classifierDescriptor2);
    }

    public final boolean isUnsignedClass(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor.getContainingDeclaration();
        return declarationDescriptor2 instanceof PackageFragmentDescriptor && Intrinsics.areEqual((Object)((PackageFragmentDescriptor)declarationDescriptor2).getFqName(), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME) && unsignedTypeNames.contains(declarationDescriptor.getName());
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_9;
        boolean bl;
        Collection collection;
        Enum enum_;
        Enum enum_2;
        int n;
        INSTANCE = new UnsignedTypes();
        Enum[] enumArray = UnsignedType.values();
        boolean bl2 = false;
        Enum[] enumArray2 = enumArray;
        Collection collection2 = new ArrayList(enumArray.length);
        int n2 = 0;
        int n3 = enumArray2.length;
        for (n = 0; n < n3; ++n) {
            enum_ = enum_2 = enumArray2[n];
            collection = collection2;
            bl = false;
            collection.add(((UnsignedType)enum_).getTypeName());
        }
        unsignedTypeNames = CollectionsKt.toSet((Iterable)((List)collection2));
        enumArray = UnsignedArrayType.values();
        bl2 = false;
        enumArray2 = enumArray;
        Collection i = new ArrayList(enumArray.length);
        n2 = 0;
        n3 = enumArray2.length;
        for (n = 0; n < n3; ++n) {
            enum_ = enum_2 = enumArray2[n];
            collection = i;
            bl = false;
            collection.add(((UnsignedArrayType)enum_).getTypeName());
        }
        unsignedArrayTypeNames = CollectionsKt.toSet((Iterable)((List)i));
        arrayClassIdToUnsignedClassId = new HashMap();
        unsignedClassIdToArrayClassId = new HashMap();
        enumArray = new Pair[]{TuplesKt.to((Object)((Object)UnsignedArrayType.UBYTEARRAY), (Object)Name.identifier("ubyteArrayOf")), TuplesKt.to((Object)((Object)UnsignedArrayType.USHORTARRAY), (Object)Name.identifier("ushortArrayOf")), TuplesKt.to((Object)((Object)UnsignedArrayType.UINTARRAY), (Object)Name.identifier("uintArrayOf")), TuplesKt.to((Object)((Object)UnsignedArrayType.ULONGARRAY), (Object)Name.identifier("ulongArrayOf"))};
        unsignedArrayTypeToArrayCall = MapsKt.hashMapOf((Pair[])enumArray);
        enumArray = UnsignedType.values();
        Collection collection3 = new LinkedHashSet();
        int n4 = 0;
        boolean enum_5 = false;
        n2 = enumArray.length;
        while (var3_9 < n2) {
            Enum enum_3;
            Enum enum_4 = enum_3 = enumArray[var3_9];
            collection = collection3;
            boolean bl3 = false;
            collection.add(((UnsignedType)enum_4).getArrayClassId().getShortClassName());
            ++var3_9;
        }
        arrayClassesShortNames = (Set)collection3;
        for (Enum enum_6 : UnsignedType.values()) {
            ((Map)arrayClassIdToUnsignedClassId).put(((UnsignedType)enum_6).getArrayClassId(), ((UnsignedType)enum_6).getClassId());
            ((Map)unsignedClassIdToArrayClassId).put(((UnsignedType)enum_6).getClassId(), ((UnsignedType)enum_6).getArrayClassId());
        }
    }
}

