/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.InvalidModuleExceptionKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleCapability;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.CompositePackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.DeclarationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDependencies;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDependenciesImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDescriptorImpl$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDescriptorImpl$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.PackageViewDescriptorFactory;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.platform.TargetPlatform;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNotNull;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;

public final class ModuleDescriptorImpl
extends DeclarationDescriptorImpl
implements ModuleDescriptor {
    private final StorageManager storageManager;
    private final KotlinBuiltIns builtIns;
    private final TargetPlatform platform;
    private final Name stableName;
    private final Map<ModuleCapability<?>, Object> capabilities;
    private final PackageViewDescriptorFactory packageViewDescriptorFactory;
    private ModuleDependencies dependencies;
    private PackageFragmentProvider packageFragmentProviderForModuleContent;
    private boolean isValid;
    private final MemoizedFunctionToNotNull<FqName, PackageViewDescriptor> packages;
    private final Lazy packageFragmentProviderForWholeModuleWithDependencies$delegate;

    public ModuleDescriptorImpl(Name name, StorageManager storageManager, KotlinBuiltIns kotlinBuiltIns, TargetPlatform targetPlatform, Map<ModuleCapability<?>, ? extends Object> map, Name name2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"");
        Intrinsics.checkNotNullParameter(map, (String)"");
        super(Annotations.Companion.getEMPTY(), name);
        this.storageManager = storageManager;
        this.builtIns = kotlinBuiltIns;
        this.platform = targetPlatform;
        this.stableName = name2;
        if (!name.isSpecial()) {
            throw new IllegalArgumentException("Module name must be special: " + name);
        }
        this.capabilities = map;
        PackageViewDescriptorFactory packageViewDescriptorFactory = this.getCapability(PackageViewDescriptorFactory.Companion.getCAPABILITY());
        if (packageViewDescriptorFactory == null) {
            packageViewDescriptorFactory = PackageViewDescriptorFactory.Default.INSTANCE;
        }
        this.packageViewDescriptorFactory = packageViewDescriptorFactory;
        this.isValid = true;
        ModuleDescriptorImpl moduleDescriptorImpl = this;
        this.packages = this.storageManager.createMemoizedFunction(new ModuleDescriptorImpl$$Lambda$0(moduleDescriptorImpl));
        moduleDescriptorImpl = this;
        this.packageFragmentProviderForWholeModuleWithDependencies$delegate = LazyKt.lazy((Function0)new ModuleDescriptorImpl$$Lambda$1(moduleDescriptorImpl));
    }

    public /* synthetic */ ModuleDescriptorImpl(Name name, StorageManager storageManager, KotlinBuiltIns kotlinBuiltIns, TargetPlatform targetPlatform, Map map, Name name2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            targetPlatform = null;
        }
        if ((n & 0x10) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            name2 = null;
        }
        this(name, storageManager, kotlinBuiltIns, targetPlatform, map, name2);
    }

    @Override
    public KotlinBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void assertValid() {
        if (!this.isValid()) {
            InvalidModuleExceptionKt.moduleInvalidated(this);
        }
    }

    @Override
    public List<ModuleDescriptor> getExpectedByModules() {
        ModuleDependencies moduleDependencies = this.dependencies;
        boolean bl = false;
        ModuleDependencies moduleDependencies2 = moduleDependencies;
        if (moduleDependencies2 == null) {
            boolean bl2 = false;
            String string = "Dependencies of module " + this.getId() + " were not set";
            throw new AssertionError((Object)string);
        }
        return moduleDependencies2.getDirectExpectedByDependencies();
    }

    @Override
    public PackageViewDescriptor getPackage(FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        this.assertValid();
        return (PackageViewDescriptor)this.packages.invoke(fqName);
    }

    @Override
    public Collection<FqName> getSubPackagesOf(FqName fqName, Function1<? super Name, Boolean> function1) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.assertValid();
        return this.getPackageFragmentProvider().getSubPackagesOf(fqName, function1);
    }

    private final CompositePackageFragmentProvider getPackageFragmentProviderForWholeModuleWithDependencies() {
        Lazy lazy = this.packageFragmentProviderForWholeModuleWithDependencies$delegate;
        return (CompositePackageFragmentProvider)lazy.getValue();
    }

    private final boolean isInitialized() {
        return this.packageFragmentProviderForModuleContent != null;
    }

    public final void setDependencies(ModuleDependencies moduleDependencies) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)moduleDependencies, (String)"");
        boolean bl2 = bl = this.dependencies == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Dependencies of " + this.getId() + " were already set";
            throw new AssertionError((Object)string);
        }
        this.dependencies = moduleDependencies;
    }

    public final void setDependencies(ModuleDescriptorImpl ... moduleDescriptorImplArray) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptorImplArray, (String)"");
        this.setDependencies(ArraysKt.toList((Object[])moduleDescriptorImplArray));
    }

    public final void setDependencies(List<ModuleDescriptorImpl> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        this.setDependencies(list, SetsKt.emptySet());
    }

    public final void setDependencies(List<ModuleDescriptorImpl> list, Set<ModuleDescriptorImpl> set) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter(set, (String)"");
        this.setDependencies(new ModuleDependenciesImpl(list, set, CollectionsKt.emptyList(), SetsKt.emptySet()));
    }

    @Override
    public boolean shouldSeeInternalsOf(ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        if (Intrinsics.areEqual((Object)this, (Object)moduleDescriptor)) {
            return true;
        }
        ModuleDependencies moduleDependencies = this.dependencies;
        Intrinsics.checkNotNull((Object)moduleDependencies);
        if (CollectionsKt.contains((Iterable)moduleDependencies.getModulesWhoseInternalsAreVisible(), (Object)moduleDescriptor)) {
            return true;
        }
        if (this.getExpectedByModules().contains(moduleDescriptor)) {
            return true;
        }
        return moduleDescriptor.getExpectedByModules().contains(this);
    }

    private final String getId() {
        String string = this.getName().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public final void initialize(PackageFragmentProvider packageFragmentProvider) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)packageFragmentProvider, (String)"");
        boolean bl2 = bl = !this.isInitialized();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Attempt to initialize module " + this.getId() + " twice";
            throw new AssertionError((Object)string);
        }
        this.packageFragmentProviderForModuleContent = packageFragmentProvider;
    }

    public final PackageFragmentProvider getPackageFragmentProvider() {
        this.assertValid();
        return this.getPackageFragmentProviderForWholeModuleWithDependencies();
    }

    @Override
    public <T> T getCapability(ModuleCapability<T> moduleCapability) {
        Intrinsics.checkNotNullParameter(moduleCapability, (String)"");
        Object object = this.capabilities.get(moduleCapability);
        if (object == null) {
            object = null;
        }
        return (T)object;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        stringBuilder2.append(super.toString());
        if (!this.isValid()) {
            stringBuilder2.append(" !isValid");
        }
        stringBuilder2.append(" packageFragmentProvider: ");
        Object object = this.packageFragmentProviderForModuleContent;
        stringBuilder2.append(object != null && (object = object.getClass()) != null ? ((Class)object).getSimpleName() : null);
        return stringBuilder.toString();
    }

    @Override
    public DeclarationDescriptor getContainingDeclaration() {
        return ModuleDescriptor.DefaultImpls.getContainingDeclaration(this);
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> declarationDescriptorVisitor, D d) {
        return ModuleDescriptor.DefaultImpls.accept(this, declarationDescriptorVisitor, d);
    }

    public ModuleDescriptorImpl(Name name, StorageManager storageManager, KotlinBuiltIns kotlinBuiltIns, TargetPlatform targetPlatform) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinBuiltIns, (String)"");
        this(name, storageManager, kotlinBuiltIns, targetPlatform, null, null, 48, null);
    }

    private static final PackageViewDescriptor packages$lambda$0(ModuleDescriptorImpl moduleDescriptorImpl, FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        return moduleDescriptorImpl.packageViewDescriptorFactory.compute(moduleDescriptorImpl, fqName, moduleDescriptorImpl.storageManager);
    }

    private static final CompositePackageFragmentProvider packageFragmentProviderForWholeModuleWithDependencies_delegate$lambda$10(ModuleDescriptorImpl moduleDescriptorImpl) {
        Object object3;
        Object object2 = moduleDescriptorImpl.dependencies;
        boolean bl = false;
        ModuleDependencies moduleDependencies = object2;
        if (moduleDependencies == null) {
            boolean bl2 = false;
            String string = "Dependencies of module " + moduleDescriptorImpl.getId() + " were not set before querying module content";
            throw new AssertionError((Object)string);
        }
        ModuleDependencies moduleDependencies2 = moduleDependencies;
        object2 = moduleDependencies2.getAllDependencies();
        moduleDescriptorImpl.assertValid();
        bl = object2.contains(moduleDescriptorImpl);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Module " + moduleDescriptorImpl.getId() + " is not contained in its own dependencies, this is probably a misconfiguration";
            throw new AssertionError((Object)string);
        }
        Iterable iterable = (Iterable)object2;
        boolean bl4 = false;
        for (Object object3 : iterable) {
            ModuleDescriptorImpl moduleDescriptorImpl2 = (ModuleDescriptorImpl)object3;
            boolean bl5 = false;
            boolean bl6 = moduleDescriptorImpl2.isInitialized();
            if (!_Assertions.ENABLED || bl6) continue;
            boolean bl7 = false;
            String string = "Dependency module " + moduleDescriptorImpl2.getId() + " was not initialized by the time contents of dependent module " + moduleDescriptorImpl.getId() + " were queried";
            throw new AssertionError((Object)string);
        }
        iterable = (Iterable)object2;
        bl4 = false;
        Iterable iterable2 = iterable;
        object3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl8 = false;
        Iterator iterator2 = iterable2.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            ModuleDescriptorImpl moduleDescriptorImpl3 = (ModuleDescriptorImpl)t;
            Object object4 = object3;
            boolean bl9 = false;
            PackageFragmentProvider packageFragmentProvider = moduleDescriptorImpl3.packageFragmentProviderForModuleContent;
            Intrinsics.checkNotNull((Object)packageFragmentProvider);
            object4.add((PackageFragmentProvider)packageFragmentProvider);
        }
        String string = "CompositeProvider@ModuleDescriptor for " + moduleDescriptorImpl.getName();
        List list = (List)object3;
        return new CompositePackageFragmentProvider(list, string);
    }

    static /* synthetic */ PackageViewDescriptor accessor$ModuleDescriptorImpl$lambda0(ModuleDescriptorImpl moduleDescriptorImpl, FqName fqName) {
        return ModuleDescriptorImpl.packages$lambda$0(moduleDescriptorImpl, fqName);
    }

    static /* synthetic */ CompositePackageFragmentProvider accessor$ModuleDescriptorImpl$lambda1(ModuleDescriptorImpl moduleDescriptorImpl) {
        return ModuleDescriptorImpl.packageFragmentProviderForWholeModuleWithDependencies_delegate$lambda$10(moduleDescriptorImpl);
    }
}

