/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectAnnotationSource;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClassKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.SignatureSerializer;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;

final class ReflectClassStructure {
    public static final ReflectClassStructure INSTANCE = new ReflectClassStructure();

    private ReflectClassStructure() {
    }

    public final void loadClassAnnotations(Class<?> clazz, KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Intrinsics.checkNotNullParameter((Object)annotationVisitor, (String)"");
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])clazz.getDeclaredAnnotations());
        while (iterator2.hasNext()) {
            Annotation annotation = (Annotation)iterator2.next();
            Intrinsics.checkNotNull((Object)annotation);
            this.processAnnotation(annotationVisitor, annotation);
        }
        annotationVisitor.visitEnd();
    }

    public final void visitMembers(Class<?> clazz, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        Intrinsics.checkNotNullParameter((Object)memberVisitor, (String)"");
        this.loadMethodAnnotations(clazz, memberVisitor);
        this.loadConstructorAnnotations(clazz, memberVisitor);
        this.loadFieldAnnotations(clazz, memberVisitor);
    }

    private final void loadMethodAnnotations(Class<?> clazz, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])clazz.getDeclaredMethods());
        while (iterator2.hasNext()) {
            KotlinJvmBinaryClass.MethodAnnotationVisitor methodAnnotationVisitor;
            Method method = (Method)iterator2.next();
            Name name = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            Intrinsics.checkNotNull((Object)method);
            if (memberVisitor.visitMethod(name, SignatureSerializer.INSTANCE.methodDesc(method)) == null) continue;
            Annotation[][] annotationArray = ArrayIteratorKt.iterator((Object[])method.getDeclaredAnnotations());
            while (annotationArray.hasNext()) {
                Annotation annotation = (Annotation)annotationArray.next();
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = methodAnnotationVisitor;
                Intrinsics.checkNotNull((Object)annotation);
                this.processAnnotation(annotationVisitor, annotation);
            }
            Annotation[][] annotationArray2 = method.getParameterAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)annotationArray2, (String)"");
            annotationArray = annotationArray2;
            int n = ((Object[])annotationArray).length;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                Object[] objectArray = annotationArray[i];
                Iterator iterator3 = ArrayIteratorKt.iterator((Object[])objectArray);
                while (iterator3.hasNext()) {
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor;
                    Annotation annotation = (Annotation)iterator3.next();
                    Class clazz2 = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
                    ClassId classId = ReflectClassUtilKt.getClassId(clazz2);
                    Intrinsics.checkNotNull((Object)annotation);
                    if (methodAnnotationVisitor.visitParameterAnnotation(n2, classId, new ReflectAnnotationSource(annotation)) == null) continue;
                    boolean bl = false;
                    INSTANCE.processAnnotationArguments(annotationArgumentVisitor, annotation, clazz2);
                }
            }
            methodAnnotationVisitor.visitEnd();
        }
    }

    private final void loadConstructorAnnotations(Class<?> clazz, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])clazz.getDeclaredConstructors());
        while (iterator2.hasNext()) {
            KotlinJvmBinaryClass.MethodAnnotationVisitor methodAnnotationVisitor;
            Constructor constructor = (Constructor)iterator2.next();
            Intrinsics.checkNotNull((Object)constructor);
            if (memberVisitor.visitMethod(SpecialNames.INIT, SignatureSerializer.INSTANCE.constructorDesc(constructor)) == null) continue;
            Annotation[][] annotationArray = ArrayIteratorKt.iterator((Object[])constructor.getDeclaredAnnotations());
            while (annotationArray.hasNext()) {
                Annotation annotation = (Annotation)annotationArray.next();
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = methodAnnotationVisitor;
                Intrinsics.checkNotNull((Object)annotation);
                this.processAnnotation(annotationVisitor, annotation);
            }
            annotationArray = constructor.getParameterAnnotations();
            Intrinsics.checkNotNull((Object)annotationArray);
            if (!(((Object[])annotationArray).length == 0)) {
                int n = constructor.getParameterTypes().length - ((Object[])annotationArray).length;
                Annotation[][] annotationArray2 = annotationArray;
                int n2 = ((Object[])annotationArray2).length;
                for (int i = 0; i < n2; ++i) {
                    int n3 = i;
                    Object[] objectArray = annotationArray2[i];
                    Iterator iterator3 = ArrayIteratorKt.iterator((Object[])objectArray);
                    while (iterator3.hasNext()) {
                        Annotation annotation = (Annotation)iterator3.next();
                        Class clazz2 = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
                        ClassId classId = ReflectClassUtilKt.getClassId(clazz2);
                        Intrinsics.checkNotNull((Object)annotation);
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = methodAnnotationVisitor.visitParameterAnnotation(n3 + n, classId, new ReflectAnnotationSource(annotation));
                        if (annotationArgumentVisitor == null) continue;
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = annotationArgumentVisitor;
                        boolean bl = false;
                        INSTANCE.processAnnotationArguments(annotationArgumentVisitor2, annotation, clazz2);
                    }
                }
            }
            methodAnnotationVisitor.visitEnd();
        }
    }

    private final void loadFieldAnnotations(Class<?> clazz, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])clazz.getDeclaredFields());
        while (iterator2.hasNext()) {
            KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor;
            Field field = (Field)iterator2.next();
            Name name = Name.identifier(field.getName());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            Intrinsics.checkNotNull((Object)field);
            if (memberVisitor.visitField(name, SignatureSerializer.INSTANCE.fieldDesc(field), null) == null) continue;
            Iterator iterator3 = ArrayIteratorKt.iterator((Object[])field.getDeclaredAnnotations());
            while (iterator3.hasNext()) {
                Annotation annotation = (Annotation)iterator3.next();
                Intrinsics.checkNotNull((Object)annotation);
                this.processAnnotation(annotationVisitor, annotation);
            }
            annotationVisitor.visitEnd();
        }
    }

    private final void processAnnotation(KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor, Annotation annotation) {
        block0: {
            Class clazz = JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = annotationVisitor.visitAnnotation(ReflectClassUtilKt.getClassId(clazz), new ReflectAnnotationSource(annotation));
            if (annotationArgumentVisitor == null) break block0;
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = annotationArgumentVisitor;
            boolean bl = false;
            INSTANCE.processAnnotationArguments(annotationArgumentVisitor2, annotation, clazz);
        }
    }

    private final void processAnnotationArguments(KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor, Annotation annotation, Class<?> clazz) {
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])clazz.getDeclaredMethods());
        while (iterator2.hasNext()) {
            Object object;
            Method method = (Method)iterator2.next();
            try {
                Intrinsics.checkNotNull((Object)method.invoke((Object)annotation, new Object[0]));
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            Object object2 = object;
            Name name = Name.identifier(method.getName());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            this.processAnnotationArgumentValue(annotationArgumentVisitor, name, object2);
        }
        annotationArgumentVisitor.visitEnd();
    }

    private final ClassLiteralValue classLiteralValue(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        int n = 0;
        while (clazz2.isArray()) {
            ++n;
            clazz2 = clazz2.getComponentType();
        }
        if (clazz2.isPrimitive()) {
            if (Intrinsics.areEqual(clazz2, Void.TYPE)) {
                return new ClassLiteralValue(ClassId.Companion.topLevel(StandardNames.FqNames.unit.toSafe()), n);
            }
            PrimitiveType primitiveType = JvmPrimitiveType.get(clazz2.getName()).getPrimitiveType();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)primitiveType), (String)"");
            PrimitiveType primitiveType2 = primitiveType;
            if (n > 0) {
                return new ClassLiteralValue(ClassId.Companion.topLevel(primitiveType2.getArrayTypeFqName()), n - 1);
            }
            return new ClassLiteralValue(ClassId.Companion.topLevel(primitiveType2.getTypeFqName()), n);
        }
        ClassId classId = ReflectClassUtilKt.getClassId(clazz2);
        ClassId classId2 = JavaToKotlinClassMap.INSTANCE.mapJavaToKotlin(classId.asSingleFqName());
        if (classId2 == null) {
            classId2 = classId;
        }
        ClassId classId3 = classId2;
        return new ClassLiteralValue(classId3, n);
    }

    private final void processAnnotationArgumentValue(KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor, Name name, Object object) {
        Class<?> clazz = object.getClass();
        if (Intrinsics.areEqual(clazz, Class.class)) {
            Intrinsics.checkNotNull((Object)object);
            annotationArgumentVisitor.visitClassLiteral(name, this.classLiteralValue((Class)object));
        } else if (ReflectKotlinClassKt.access$getTYPES_ELIGIBLE_FOR_SIMPLE_VISIT$p().contains(clazz)) {
            annotationArgumentVisitor.visit(name, object);
        } else if (ReflectClassUtilKt.isEnumClassOrSpecializedEnumEntryClass(clazz)) {
            Class<?> clazz2 = clazz.isEnum() ? clazz : clazz.getEnclosingClass();
            Intrinsics.checkNotNull(clazz2);
            ClassId classId = ReflectClassUtilKt.getClassId(clazz2);
            Intrinsics.checkNotNull((Object)object);
            Name name2 = Name.identifier(((Enum)object).name());
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"");
            annotationArgumentVisitor.visitEnum(name, classId, name2);
        } else if (Annotation.class.isAssignableFrom(clazz)) {
            Class<?>[] classArray = clazz.getInterfaces();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"");
            Class clazz3 = (Class)ArraysKt.single((Object[])classArray);
            Intrinsics.checkNotNull((Object)clazz3);
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = annotationArgumentVisitor.visitAnnotation(name, ReflectClassUtilKt.getClassId(clazz3));
            if (annotationArgumentVisitor2 == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor3 = annotationArgumentVisitor2;
            Intrinsics.checkNotNull((Object)object);
            this.processAnnotationArguments(annotationArgumentVisitor3, (Annotation)object, clazz3);
        } else if (clazz.isArray()) {
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor annotationArrayArgumentVisitor = annotationArgumentVisitor.visitArray(name);
            if (annotationArrayArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor annotationArrayArgumentVisitor2 = annotationArrayArgumentVisitor;
            Class<?> clazz4 = clazz.getComponentType();
            if (clazz4.isEnum()) {
                Intrinsics.checkNotNull(clazz4);
                ClassId classId = ReflectClassUtilKt.getClassId(clazz4);
                Intrinsics.checkNotNull((Object)object);
                for (Object object2 : (Object[])object) {
                    Intrinsics.checkNotNull((Object)object2);
                    Name name3 = Name.identifier(((Enum)object2).name());
                    Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"");
                    annotationArrayArgumentVisitor2.visitEnum(classId, name3);
                }
            } else if (Intrinsics.areEqual(clazz4, Class.class)) {
                Intrinsics.checkNotNull((Object)object);
                for (Object object3 : (Object[])object) {
                    Intrinsics.checkNotNull((Object)object3);
                    annotationArrayArgumentVisitor2.visitClassLiteral(this.classLiteralValue((Class)object3));
                }
            } else if (Annotation.class.isAssignableFrom(clazz4)) {
                Intrinsics.checkNotNull((Object)object);
                for (Object object4 : (Object[])object) {
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor4;
                    Intrinsics.checkNotNull(clazz4);
                    if (annotationArrayArgumentVisitor2.visitAnnotation(ReflectClassUtilKt.getClassId(clazz4)) == null) continue;
                    Intrinsics.checkNotNull((Object)object4);
                    this.processAnnotationArguments(annotationArgumentVisitor4, (Annotation)object4, clazz4);
                }
            } else {
                Intrinsics.checkNotNull((Object)object);
                for (Object object5 : (Object[])object) {
                    annotationArrayArgumentVisitor2.visit(object5);
                }
            }
            annotationArrayArgumentVisitor2.visitEnd();
        } else {
            throw new UnsupportedOperationException("Unsupported annotation argument value (" + clazz + "): " + object);
        }
    }
}

