/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Function;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function10;
import kotlin.jvm.functions.Function11;
import kotlin.jvm.functions.Function12;
import kotlin.jvm.functions.Function13;
import kotlin.jvm.functions.Function14;
import kotlin.jvm.functions.Function15;
import kotlin.jvm.functions.Function16;
import kotlin.jvm.functions.Function17;
import kotlin.jvm.functions.Function18;
import kotlin.jvm.functions.Function19;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function20;
import kotlin.jvm.functions.Function21;
import kotlin.jvm.functions.Function22;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.functions.Function7;
import kotlin.jvm.functions.Function8;
import kotlin.jvm.functions.Function9;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;

public final class ReflectClassUtilKt {
    private static final List<KClass<? extends Object>> PRIMITIVE_CLASSES;
    private static final Map<Class<? extends Object>, Class<? extends Object>> WRAPPER_TO_PRIMITIVE;
    private static final Map<Class<? extends Object>, Class<? extends Object>> PRIMITIVE_TO_WRAPPER;
    private static final Map<Class<? extends Function<?>>, Integer> FUNCTION_CLASSES;

    public static final ClassLoader getSafeClassLoader(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            classLoader = classLoader2;
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"");
        }
        return classLoader;
    }

    public static final boolean isEnumClassOrSpecializedEnumEntryClass(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        return Enum.class.isAssignableFrom(clazz);
    }

    public static final Class<?> getPrimitiveByWrapper(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        return WRAPPER_TO_PRIMITIVE.get(clazz);
    }

    public static final Class<?> getWrapperByPrimitive(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        return PRIMITIVE_TO_WRAPPER.get(clazz);
    }

    public static final Integer getFunctionClassArity(Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"");
        return FUNCTION_CLASSES.get(clazz);
    }

    public static final ClassId getClassId(Class<?> clazz) {
        Class<?> clazz2;
        block7: {
            block8: {
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter(clazz, (String)"");
                        if (clazz.isPrimitive()) {
                            throw new IllegalArgumentException("Can't compute ClassId for primitive type: " + clazz);
                        }
                        if (clazz.isArray()) {
                            throw new IllegalArgumentException("Can't compute ClassId for array type: " + clazz);
                        }
                        if (clazz.getEnclosingMethod() != null || clazz.getEnclosingConstructor() != null) break block5;
                        String string = clazz.getSimpleName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                        if (!(((CharSequence)string).length() == 0)) break block6;
                    }
                    String string = clazz.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                    FqName fqName = new FqName(string);
                    clazz2 = new ClassId(fqName.parent(), FqName.Companion.topLevel(fqName.shortName()), true);
                    break block7;
                }
                clazz2 = clazz.getDeclaringClass();
                if (clazz2 == null || (clazz2 = ReflectClassUtilKt.getClassId(clazz2)) == null) break block8;
                Name name = Name.identifier(clazz.getSimpleName());
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                if ((clazz2 = ((ClassId)((Object)clazz2)).createNestedClassId(name)) != null) break block7;
            }
            String string = clazz.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
            clazz2 = ClassId.Companion.topLevel(new FqName(string));
        }
        return clazz2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String getDesc(Class<?> clazz) {
        String string;
        block33: {
            Intrinsics.checkNotNullParameter(clazz, (String)"");
            if (!clazz.isPrimitive()) break block33;
            String string2 = clazz.getName();
            if (string2 == null) throw new IllegalArgumentException("Unsupported primitive type: " + clazz);
            int n = -1;
            switch (string2.hashCode()) {
                case 64711720: {
                    if (string2.equals("boolean")) {
                        n = 1;
                    }
                    break;
                }
                case 3625364: {
                    if (string2.equals("void")) {
                        n = 2;
                    }
                    break;
                }
                case 3039496: {
                    if (string2.equals("byte")) {
                        n = 3;
                    }
                    break;
                }
                case -1325958191: {
                    if (string2.equals("double")) {
                        n = 4;
                    }
                    break;
                }
                case 3052374: {
                    if (string2.equals("char")) {
                        n = 5;
                    }
                    break;
                }
                case 109413500: {
                    if (string2.equals("short")) {
                        n = 6;
                    }
                    break;
                }
                case 97526364: {
                    if (string2.equals("float")) {
                        n = 7;
                    }
                    break;
                }
                case 104431: {
                    if (string2.equals("int")) {
                        n = 8;
                    }
                    break;
                }
                case 3327612: {
                    if (string2.equals("long")) {
                        n = 9;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    return "Z";
                }
                case 5: {
                    return "C";
                }
                case 3: {
                    return "B";
                }
                case 6: {
                    return "S";
                }
                case 8: {
                    return "I";
                }
                case 7: {
                    return "F";
                }
                case 9: {
                    return "J";
                }
                case 4: {
                    return "D";
                }
                case 2: {
                    return "V";
                }
                default: {
                    throw new IllegalArgumentException("Unsupported primitive type: " + clazz);
                }
            }
        }
        if (clazz.isArray()) {
            String string3 = clazz.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
            string = StringsKt.replace$default((String)string3, (char)'.', (char)'/', (boolean)false, (int)4, null);
            return string;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append('L');
            String string4 = clazz.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
            string = stringBuilder.append(StringsKt.replace$default((String)string4, (char)'.', (char)'/', (boolean)false, (int)4, null)).append(';').toString();
        }
        return string;
    }

    public static final List<Type> getParameterizedTypeArguments(Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        if (!(type instanceof ParameterizedType)) {
            return CollectionsKt.emptyList();
        }
        if (((ParameterizedType)type).getOwnerType() == null) {
            Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"");
            return ArraysKt.toList((Object[])typeArray);
        }
        return SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.generateSequence((Object)type, (Function1)ReflectClassUtilKt$$Lambda$0.INSTANCE), (Function1)ReflectClassUtilKt$$Lambda$1.INSTANCE));
    }

    private static final ParameterizedType _get_parameterizedTypeArguments_$lambda$3(ParameterizedType parameterizedType) {
        Intrinsics.checkNotNullParameter((Object)parameterizedType, (String)"");
        Type type = parameterizedType.getOwnerType();
        return type instanceof ParameterizedType ? (ParameterizedType)type : null;
    }

    private static final Sequence _get_parameterizedTypeArguments_$lambda$4(ParameterizedType parameterizedType) {
        Intrinsics.checkNotNullParameter((Object)parameterizedType, (String)"");
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"");
        return ArraysKt.asSequence((Object[])typeArray);
    }

    static {
        int n;
        Collection collection;
        Object object;
        Object object2;
        Object object3 = new KClass[]{Reflection.getOrCreateKotlinClass(Boolean.TYPE), Reflection.getOrCreateKotlinClass(Byte.TYPE), Reflection.getOrCreateKotlinClass(Character.TYPE), Reflection.getOrCreateKotlinClass(Double.TYPE), Reflection.getOrCreateKotlinClass(Float.TYPE), Reflection.getOrCreateKotlinClass(Integer.TYPE), Reflection.getOrCreateKotlinClass(Long.TYPE), Reflection.getOrCreateKotlinClass(Short.TYPE)};
        PRIMITIVE_CLASSES = CollectionsKt.listOf((Object[])object3);
        object3 = PRIMITIVE_CLASSES;
        boolean bl = false;
        Object object4 = object3;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object3, (int)10));
        boolean bl2 = false;
        Iterator iterator2 = object4.iterator();
        while (iterator2.hasNext()) {
            object2 = iterator2.next();
            object = (KClass)object2;
            collection = collection2;
            n = 0;
            collection.add(TuplesKt.to((Object)JvmClassMappingKt.getJavaObjectType((KClass)object), (Object)JvmClassMappingKt.getJavaPrimitiveType((KClass)object)));
        }
        WRAPPER_TO_PRIMITIVE = MapsKt.toMap((Iterable)((List)collection2));
        object3 = PRIMITIVE_CLASSES;
        bl = false;
        object4 = object3;
        collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object3, (int)10));
        bl2 = false;
        iterator2 = object4.iterator();
        while (iterator2.hasNext()) {
            object2 = iterator2.next();
            object = (KClass)object2;
            collection = collection2;
            n = 0;
            collection.add(TuplesKt.to((Object)JvmClassMappingKt.getJavaPrimitiveType((KClass)object), (Object)JvmClassMappingKt.getJavaObjectType((KClass)object)));
        }
        PRIMITIVE_TO_WRAPPER = MapsKt.toMap((Iterable)((List)collection2));
        object3 = new Class[]{Function0.class, Function1.class, Function2.class, Function3.class, Function4.class, Function5.class, Function6.class, Function7.class, Function8.class, Function9.class, Function10.class, Function11.class, Function12.class, Function13.class, Function14.class, Function15.class, Function16.class, Function17.class, Function18.class, Function19.class, Function20.class, Function21.class, Function22.class};
        object3 = CollectionsKt.listOf((Object[])object3);
        bl = false;
        object4 = object3;
        collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object3, (int)10));
        bl2 = false;
        int n2 = 0;
        object2 = object4.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if ((n = n2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Class clazz = (Class)object;
            int n3 = n;
            collection = collection2;
            boolean bl3 = false;
            collection.add(TuplesKt.to((Object)clazz, (Object)n3));
        }
        FUNCTION_CLASSES = MapsKt.toMap((Iterable)((List)collection2));
    }

    static /* synthetic */ ParameterizedType accessor$ReflectClassUtilKt$lambda0(ParameterizedType parameterizedType) {
        return ReflectClassUtilKt._get_parameterizedTypeArguments_$lambda$3(parameterizedType);
    }

    static /* synthetic */ Sequence accessor$ReflectClassUtilKt$lambda1(ParameterizedType parameterizedType) {
        return ReflectClassUtilKt._get_parameterizedTypeArguments_$lambda$4(parameterizedType);
    }
}

