/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMapper;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.CompositeAnnotations;
import kotlin.reflect.jvm.internal.impl.load.java.UtilsKt;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaAnnotations;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.TypeParameterResolver;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeAttributes;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeFlexibility;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeResolver$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeResolverKt;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawProjectionComputer;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawTypeImpl;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaArrayType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifier;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifierType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaPrimitiveType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaTypesKt;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaWildcardType;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.LazyWrappedType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeParameterUpperBoundEraser;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeUsage;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class JavaTypeResolver {
    private final LazyJavaResolverContext c;
    private final TypeParameterResolver typeParameterResolver;
    private final RawProjectionComputer projectionComputer;
    private final TypeParameterUpperBoundEraser typeParameterUpperBoundEraser;

    public JavaTypeResolver(LazyJavaResolverContext lazyJavaResolverContext, TypeParameterResolver typeParameterResolver) {
        Intrinsics.checkNotNullParameter((Object)lazyJavaResolverContext, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeParameterResolver, (String)"");
        this.c = lazyJavaResolverContext;
        this.typeParameterResolver = typeParameterResolver;
        this.projectionComputer = new RawProjectionComputer();
        this.typeParameterUpperBoundEraser = new TypeParameterUpperBoundEraser(this.projectionComputer, null, 2, null);
    }

    public final KotlinType transformJavaType(JavaType javaType, JavaTypeAttributes javaTypeAttributes) {
        Object object;
        block5: {
            JavaType javaType2;
            block8: {
                block9: {
                    block7: {
                        block6: {
                            block4: {
                                Intrinsics.checkNotNullParameter((Object)javaTypeAttributes, (String)"");
                                javaType2 = javaType;
                                if (!(javaType2 instanceof JavaPrimitiveType)) break block4;
                                PrimitiveType primitiveType = ((JavaPrimitiveType)javaType).getType();
                                SimpleType simpleType = primitiveType != null ? this.c.getModule().getBuiltIns().getPrimitiveKotlinType(primitiveType) : this.c.getModule().getBuiltIns().getUnitType();
                                Intrinsics.checkNotNull((Object)simpleType);
                                object = simpleType;
                                break block5;
                            }
                            if (!(javaType2 instanceof JavaClassifierType)) break block6;
                            object = this.transformJavaClassifierType((JavaClassifierType)javaType, javaTypeAttributes);
                            break block5;
                        }
                        if (!(javaType2 instanceof JavaArrayType)) break block7;
                        object = JavaTypeResolver.transformArrayType$default(this, (JavaArrayType)javaType, javaTypeAttributes, false, 4, null);
                        break block5;
                    }
                    if (!(javaType2 instanceof JavaWildcardType)) break block8;
                    object = ((JavaWildcardType)javaType).getBound();
                    if (object == null) break block9;
                    Object object2 = object;
                    boolean bl = false;
                    KotlinType kotlinType = this.transformJavaType((JavaType)object2, javaTypeAttributes);
                    object = kotlinType;
                    if (kotlinType != null) break block5;
                }
                SimpleType simpleType = this.c.getModule().getBuiltIns().getDefaultBound();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
                object = simpleType;
                break block5;
            }
            if (javaType2 == null) {
                SimpleType simpleType = this.c.getModule().getBuiltIns().getDefaultBound();
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
                object = simpleType;
            } else {
                throw new UnsupportedOperationException("Unsupported type: " + javaType);
            }
        }
        return object;
    }

    public final KotlinType transformArrayType(JavaArrayType javaArrayType, JavaTypeAttributes javaTypeAttributes, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)javaArrayType, (String)"");
        Intrinsics.checkNotNullParameter((Object)javaTypeAttributes, (String)"");
        JavaType javaType = javaArrayType.getComponentType();
        JavaPrimitiveType javaPrimitiveType = javaType instanceof JavaPrimitiveType ? (JavaPrimitiveType)javaType : null;
        PrimitiveType primitiveType = javaPrimitiveType != null ? javaPrimitiveType.getType() : null;
        LazyJavaAnnotations lazyJavaAnnotations = new LazyJavaAnnotations(this.c, javaArrayType, true);
        if (primitiveType != null) {
            SimpleType simpleType = this.c.getModule().getBuiltIns().getPrimitiveArrayKotlinType(primitiveType);
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)simpleType);
            Annotations[] annotationsArray = new Annotations[]{simpleType.getAnnotations(), lazyJavaAnnotations};
            KotlinType kotlinType = TypeUtilsKt.replaceAnnotations(simpleType, new CompositeAnnotations(annotationsArray));
            Intrinsics.checkNotNull((Object)kotlinType);
            SimpleType simpleType2 = (SimpleType)kotlinType;
            return javaTypeAttributes.isForAnnotationParameter() ? (KotlinType)simpleType2 : (KotlinType)KotlinTypeFactory.flexibleType(simpleType2, simpleType2.makeNullableAsSpecified(true));
        }
        KotlinType kotlinType = this.transformJavaType(javaType, JavaTypeAttributesKt.toAttributes$default(TypeUsage.COMMON, javaTypeAttributes.isForAnnotationParameter(), false, null, 6, null));
        if (javaTypeAttributes.isForAnnotationParameter()) {
            Variance variance = bl ? Variance.OUT_VARIANCE : Variance.INVARIANT;
            SimpleType simpleType = this.c.getModule().getBuiltIns().getArrayType(variance, kotlinType, lazyJavaAnnotations);
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
            return simpleType;
        }
        SimpleType simpleType = this.c.getModule().getBuiltIns().getArrayType(Variance.INVARIANT, kotlinType, lazyJavaAnnotations);
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
        return KotlinTypeFactory.flexibleType(simpleType, this.c.getModule().getBuiltIns().getArrayType(Variance.OUT_VARIANCE, kotlinType, lazyJavaAnnotations).makeNullableAsSpecified(true));
    }

    public static /* synthetic */ KotlinType transformArrayType$default(JavaTypeResolver javaTypeResolver, JavaArrayType javaArrayType, JavaTypeAttributes javaTypeAttributes, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return javaTypeResolver.transformArrayType(javaArrayType, javaTypeAttributes, bl);
    }

    private final KotlinType transformJavaClassifierType(JavaClassifierType javaClassifierType, JavaTypeAttributes javaTypeAttributes) {
        boolean bl = !javaTypeAttributes.isForAnnotationParameter() && javaTypeAttributes.getHowThisTypeIsUsed() != TypeUsage.SUPERTYPE;
        boolean bl2 = javaClassifierType.isRaw();
        if (!bl2 && !bl) {
            SimpleType simpleType = this.computeSimpleJavaClassifierType(javaClassifierType, javaTypeAttributes, null);
            return simpleType != null ? (KotlinType)simpleType : (KotlinType)JavaTypeResolver.transformJavaClassifierType$errorType(javaClassifierType);
        }
        SimpleType simpleType = this.computeSimpleJavaClassifierType(javaClassifierType, javaTypeAttributes.withFlexibility(JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND), null);
        if (simpleType == null) {
            return JavaTypeResolver.transformJavaClassifierType$errorType(javaClassifierType);
        }
        SimpleType simpleType2 = simpleType;
        SimpleType simpleType3 = this.computeSimpleJavaClassifierType(javaClassifierType, javaTypeAttributes.withFlexibility(JavaTypeFlexibility.FLEXIBLE_UPPER_BOUND), simpleType2);
        if (simpleType3 == null) {
            return JavaTypeResolver.transformJavaClassifierType$errorType(javaClassifierType);
        }
        SimpleType simpleType4 = simpleType3;
        return bl2 ? (KotlinType)new RawTypeImpl(simpleType2, simpleType4) : (KotlinType)KotlinTypeFactory.flexibleType(simpleType2, simpleType4);
    }

    private final SimpleType computeSimpleJavaClassifierType(JavaClassifierType javaClassifierType, JavaTypeAttributes javaTypeAttributes, SimpleType simpleType) {
        Object object = simpleType;
        if (object == null || (object = ((KotlinType)object).getAttributes()) == null) {
            object = TypeAttributesKt.toDefaultAttributes(new LazyJavaAnnotations(this.c, javaClassifierType, false, 4, null));
        }
        Object object2 = object;
        TypeConstructor typeConstructor2 = this.computeTypeConstructor(javaClassifierType, javaTypeAttributes);
        if (typeConstructor2 == null) {
            return null;
        }
        TypeConstructor typeConstructor3 = typeConstructor2;
        boolean bl = this.isNullable(javaTypeAttributes);
        SimpleType simpleType2 = simpleType;
        if (Intrinsics.areEqual((Object)(simpleType2 != null ? simpleType2.getConstructor() : null), (Object)typeConstructor3) && !javaClassifierType.isRaw() && bl) {
            return simpleType.makeNullableAsSpecified(true);
        }
        List<TypeProjection> list = this.computeArguments(javaClassifierType, javaTypeAttributes, typeConstructor3);
        return KotlinTypeFactory.simpleType$default((TypeAttributes)object2, typeConstructor3, list, bl, null, 16, null);
    }

    private final TypeConstructor computeTypeConstructor(JavaClassifierType javaClassifierType, JavaTypeAttributes javaTypeAttributes) {
        Object object;
        JavaClassifier javaClassifier = javaClassifierType.getClassifier();
        if (javaClassifier == null) {
            return this.createNotFoundClass(javaClassifierType);
        }
        JavaClassifier javaClassifier2 = javaClassifier;
        JavaClassifier javaClassifier3 = javaClassifier2;
        if (javaClassifier3 instanceof JavaClass) {
            Object object2 = ((JavaClass)javaClassifier2).getFqName();
            boolean bl = false;
            FqName fqName = object2;
            if (fqName == null) {
                boolean bl2 = false;
                String string = "Class type should have a FQ name: " + javaClassifier2;
                throw new AssertionError((Object)string);
            }
            FqName fqName2 = fqName;
            ClassDescriptor classDescriptor = this.mapKotlinClass(javaClassifierType, javaTypeAttributes, fqName2);
            if (classDescriptor == null) {
                classDescriptor = this.c.getComponents().getModuleClassResolver().resolveClass((JavaClass)javaClassifier2);
            }
            if ((object = (object2 = classDescriptor)) == null || (object = object.getTypeConstructor()) == null) {
                object = this.createNotFoundClass(javaClassifierType);
            }
        } else if (javaClassifier3 instanceof JavaTypeParameter) {
            TypeParameterDescriptor typeParameterDescriptor = this.typeParameterResolver.resolveTypeParameter((JavaTypeParameter)javaClassifier2);
            object = typeParameterDescriptor != null ? typeParameterDescriptor.getTypeConstructor() : null;
        } else {
            throw new IllegalStateException("Unknown classifier kind: " + javaClassifier2);
        }
        return object;
    }

    private final TypeConstructor createNotFoundClass(JavaClassifierType javaClassifierType) {
        ClassId classId = ClassId.Companion.topLevel(new FqName(javaClassifierType.getClassifierQualifiedName()));
        TypeConstructor typeConstructor2 = this.c.getComponents().getDeserializedDescriptorResolver().getComponents().getNotFoundClasses().getClass(classId, CollectionsKt.listOf((Object)0)).getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"");
        return typeConstructor2;
    }

    private final ClassDescriptor mapKotlinClass(JavaClassifierType javaClassifierType, JavaTypeAttributes javaTypeAttributes, FqName fqName) {
        if (javaTypeAttributes.isForAnnotationParameter() && Intrinsics.areEqual((Object)fqName, (Object)JavaTypeResolverKt.access$getJAVA_LANG_CLASS_FQ_NAME$p())) {
            return this.c.getComponents().getReflectionTypes().getKClass();
        }
        JavaToKotlinClassMapper javaToKotlinClassMapper = JavaToKotlinClassMapper.INSTANCE;
        ClassDescriptor classDescriptor = JavaToKotlinClassMapper.mapJavaToKotlin$default(javaToKotlinClassMapper, fqName, this.c.getModule().getBuiltIns(), null, 4, null);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (javaToKotlinClassMapper.isReadOnly(classDescriptor2) && (javaTypeAttributes.getFlexibility() == JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND || javaTypeAttributes.getHowThisTypeIsUsed() == TypeUsage.SUPERTYPE || this.argumentsMakeSenseOnlyForMutableContainer(javaClassifierType, classDescriptor2))) {
            return javaToKotlinClassMapper.convertReadOnlyToMutable(classDescriptor2);
        }
        return classDescriptor2;
    }

    private final boolean argumentsMakeSenseOnlyForMutableContainer(JavaClassifierType javaClassifierType, ClassDescriptor classDescriptor) {
        Variance variance;
        if (!JavaTypesKt.isSuperWildcard((JavaType)CollectionsKt.lastOrNull(javaClassifierType.getTypeArguments()))) {
            return false;
        }
        List<TypeParameterDescriptor> list = JavaToKotlinClassMapper.INSTANCE.convertReadOnlyToMutable(classDescriptor).getTypeConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)CollectionsKt.lastOrNull(list);
        if (typeParameterDescriptor == null || (variance = typeParameterDescriptor.getVariance()) == null) {
            return false;
        }
        Variance variance2 = variance;
        return variance2 != Variance.OUT_VARIANCE;
    }

    private final List<TypeProjection> computeRawTypeArguments(JavaClassifierType javaClassifierType, List<? extends TypeParameterDescriptor> list, TypeConstructor typeConstructor2, JavaTypeAttributes javaTypeAttributes) {
        Iterable iterable = list;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            TypeProjection typeProjection;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            if (TypeUtilsKt.hasTypeParameterRecursiveBounds(typeParameterDescriptor, null, javaTypeAttributes.getVisitedTypeParameters())) {
                typeProjection = TypeUtils.makeStarProjection(typeParameterDescriptor, javaTypeAttributes);
            } else {
                JavaClassifierType javaClassifierType2 = javaClassifierType;
                TypeConstructor typeConstructor3 = typeConstructor2;
                JavaTypeAttributes javaTypeAttributes2 = javaTypeAttributes;
                TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
                JavaTypeResolver javaTypeResolver = this;
                LazyWrappedType lazyWrappedType = new LazyWrappedType(this.c.getStorageManager(), new JavaTypeResolver$$Lambda$0(javaTypeResolver, typeParameterDescriptor2, javaTypeAttributes2, typeConstructor3, javaClassifierType2));
                typeProjection = this.projectionComputer.computeProjection(typeParameterDescriptor, javaTypeAttributes.markIsRaw(javaClassifierType.isRaw()), this.typeParameterUpperBoundEraser, lazyWrappedType);
            }
            collection2.add(typeProjection);
        }
        return (List)collection;
    }

    /*
     * Unable to fully structure code
     */
    private final List<TypeProjection> computeArguments(JavaClassifierType var1_1, JavaTypeAttributes var2_2, TypeConstructor var3_3) {
        var4_4 = var1_1.isRaw();
        if (var4_4) ** GOTO lbl-1000
        if (var1_1.getTypeArguments().isEmpty()) {
            v0 = var3_3.getParameters();
            Intrinsics.checkNotNullExpressionValue(v0, (String)"");
            ** if (!(((Collection)v0).isEmpty() == false)) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v1 = true;
            ** GOTO lbl11
        }
lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
lbl11:
        // 2 sources

        var5_5 = v1;
        v2 = var3_3.getParameters();
        Intrinsics.checkNotNullExpressionValue(v2, (String)"");
        var6_6 = v2;
        if (var5_5) {
            return this.computeRawTypeArguments(var1_1, var6_6, var3_3, var2_2);
        }
        if (var6_6.size() != var1_1.getTypeArguments().size()) {
            var7_7 = var6_6;
            var8_9 = false;
            var9_11 = var7_7;
            var10_13 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)var7_7, (int)10));
            var11_15 = false;
            for (T var13_19 : var9_11) {
                var14_21 = (TypeParameterDescriptor)var13_19;
                var20_27 = var10_13;
                var15_23 = false;
                var16_25 = new String[]{var14_21.getName().asString()};
                var20_27.add(new TypeProjectionImpl(ErrorUtils.createErrorType(ErrorTypeKind.MISSED_TYPE_ARGUMENT_FOR_TYPE_PARAMETER, var16_25)));
            }
            return CollectionsKt.toList((Iterable)((List)var10_13));
        }
        var7_8 = CollectionsKt.withIndex((Iterable)var1_1.getTypeArguments());
        var8_10 = false;
        var9_12 = var7_8;
        var10_14 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)var7_8, (int)10));
        var11_16 = false;
        for (T var13_20 : var9_12) {
            var14_22 = (IndexedValue)var13_20;
            var20_28 = var10_14;
            var15_24 = false;
            var16_26 = var14_22.component1();
            var17_29 = (JavaType)var14_22.component2();
            v3 = var18_31 = var16_26 < var6_6.size();
            if (_Assertions.ENABLED && !var18_31) {
                var19_32 = false;
                var19_33 = "Argument index should be less then type parameters count, but " + var16_26 + " > " + var6_6.size();
                throw new AssertionError((Object)var19_33);
            }
            var18_30 = var6_6.get(var16_26);
            v4 = JavaTypeAttributesKt.toAttributes$default(TypeUsage.COMMON, false, false, null, 7, null);
            Intrinsics.checkNotNull((Object)var18_30);
            var20_28.add(this.transformToTypeProjection(var17_29, v4, var18_30));
        }
        return CollectionsKt.toList((Iterable)((List)var10_14));
    }

    private final TypeProjection transformToTypeProjection(JavaType javaType, JavaTypeAttributes javaTypeAttributes, TypeParameterDescriptor typeParameterDescriptor) {
        TypeProjection typeProjection;
        if (javaType instanceof JavaWildcardType) {
            Variance variance;
            JavaType javaType2 = ((JavaWildcardType)javaType).getBound();
            Variance variance2 = variance = ((JavaWildcardType)javaType).isExtends() ? Variance.OUT_VARIANCE : Variance.IN_VARIANCE;
            if (javaType2 == null || this.isConflictingArgumentFor(variance, typeParameterDescriptor)) {
                TypeProjection typeProjection2 = TypeUtils.makeStarProjection(typeParameterDescriptor, javaTypeAttributes);
                typeProjection = typeProjection2;
                Intrinsics.checkNotNullExpressionValue((Object)typeProjection2, (String)"");
            } else {
                AnnotationDescriptor annotationDescriptor = UtilsKt.extractNullabilityAnnotationOnBoundedWildcard(this.c, (JavaWildcardType)javaType);
                KotlinType kotlinType = this.transformJavaType(javaType2, JavaTypeAttributesKt.toAttributes$default(TypeUsage.COMMON, false, false, null, 7, null));
                boolean bl = false;
                KotlinType kotlinType2 = annotationDescriptor != null ? TypeUtilsKt.replaceAnnotations(kotlinType, Annotations.Companion.create(CollectionsKt.plus((Iterable)kotlinType.getAnnotations(), (Object)annotationDescriptor))) : kotlinType;
                typeProjection = TypeUtilsKt.createProjection(kotlinType2, variance, typeParameterDescriptor);
            }
        } else {
            typeProjection = new TypeProjectionImpl(Variance.INVARIANT, this.transformJavaType(javaType, javaTypeAttributes));
        }
        return typeProjection;
    }

    private final boolean isConflictingArgumentFor(Variance variance, TypeParameterDescriptor typeParameterDescriptor) {
        if (typeParameterDescriptor.getVariance() == Variance.INVARIANT) {
            return false;
        }
        return variance != typeParameterDescriptor.getVariance();
    }

    private final boolean isNullable(JavaTypeAttributes javaTypeAttributes) {
        if (javaTypeAttributes.getFlexibility() == JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND) {
            return false;
        }
        return !javaTypeAttributes.isForAnnotationParameter() && javaTypeAttributes.getHowThisTypeIsUsed() != TypeUsage.SUPERTYPE;
    }

    private static final ErrorType transformJavaClassifierType$errorType(JavaClassifierType javaClassifierType) {
        String[] stringArray = new String[]{javaClassifierType.getPresentableText()};
        return ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_JAVA_CLASS, stringArray);
    }

    private static final KotlinType computeRawTypeArguments$lambda$4$lambda$3(JavaTypeResolver javaTypeResolver, TypeParameterDescriptor typeParameterDescriptor, JavaTypeAttributes javaTypeAttributes, TypeConstructor typeConstructor2, JavaClassifierType javaClassifierType) {
        ClassifierDescriptor classifierDescriptor = typeConstructor2.getDeclarationDescriptor();
        return javaTypeResolver.typeParameterUpperBoundEraser.getErasedUpperBound(typeParameterDescriptor, javaTypeAttributes.withDefaultType(classifierDescriptor != null ? classifierDescriptor.getDefaultType() : null).markIsRaw(javaClassifierType.isRaw()));
    }

    static /* synthetic */ KotlinType accessor$JavaTypeResolver$lambda0(JavaTypeResolver javaTypeResolver, TypeParameterDescriptor typeParameterDescriptor, JavaTypeAttributes javaTypeAttributes, TypeConstructor typeConstructor2, JavaClassifierType javaClassifierType) {
        return JavaTypeResolver.computeRawTypeArguments$lambda$4$lambda$3(javaTypeResolver, typeParameterDescriptor, javaTypeAttributes, typeConstructor2, javaClassifierType);
    }
}

