/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.Collection;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeEnhancementUtilsKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingMode;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.reflect.jvm.internal.impl.types.TypeSystemCommonBackendContext;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeConstructorMarker;

public final class TypeSignatureMappingKt {
    public static final <T> T boxTypeIfNeeded(JvmTypeFactory<T> jvmTypeFactory, T t, boolean bl) {
        Intrinsics.checkNotNullParameter(jvmTypeFactory, (String)"");
        Intrinsics.checkNotNullParameter(t, (String)"");
        return bl ? jvmTypeFactory.boxType(t) : t;
    }

    public static final <T> T mapBuiltInType(TypeSystemCommonBackendContext typeSystemCommonBackendContext, KotlinTypeMarker kotlinTypeMarker, JvmTypeFactory<T> jvmTypeFactory, TypeMappingMode typeMappingMode) {
        Intrinsics.checkNotNullParameter((Object)typeSystemCommonBackendContext, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinTypeMarker, (String)"");
        Intrinsics.checkNotNullParameter(jvmTypeFactory, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeMappingMode, (String)"");
        TypeConstructorMarker typeConstructorMarker = typeSystemCommonBackendContext.typeConstructor(kotlinTypeMarker);
        if (!typeSystemCommonBackendContext.isClassTypeConstructor(typeConstructorMarker)) {
            return null;
        }
        PrimitiveType primitiveType = typeSystemCommonBackendContext.getPrimitiveType(typeConstructorMarker);
        if (primitiveType != null) {
            T t = jvmTypeFactory.createPrimitiveType(primitiveType);
            boolean bl = typeSystemCommonBackendContext.isNullableType(kotlinTypeMarker) || TypeEnhancementUtilsKt.hasEnhancedNullability(typeSystemCommonBackendContext, kotlinTypeMarker);
            return TypeSignatureMappingKt.boxTypeIfNeeded(jvmTypeFactory, t, bl);
        }
        PrimitiveType primitiveType2 = typeSystemCommonBackendContext.getPrimitiveArrayType(typeConstructorMarker);
        if (primitiveType2 != null) {
            return jvmTypeFactory.createFromString('[' + JvmPrimitiveType.get(primitiveType2).getDesc());
        }
        if (typeSystemCommonBackendContext.isUnderKotlinPackage(typeConstructorMarker)) {
            ClassId classId;
            ClassId classId2;
            FqNameUnsafe fqNameUnsafe = typeSystemCommonBackendContext.getClassFqNameUnsafe(typeConstructorMarker);
            if (fqNameUnsafe != null) {
                FqNameUnsafe fqNameUnsafe2 = fqNameUnsafe;
                JavaToKotlinClassMap javaToKotlinClassMap = JavaToKotlinClassMap.INSTANCE;
                FqNameUnsafe fqNameUnsafe3 = fqNameUnsafe2;
                boolean bl = false;
                classId2 = javaToKotlinClassMap.mapKotlinToJava(fqNameUnsafe3);
            } else {
                classId2 = classId = null;
            }
            if (classId != null) {
                if (!typeMappingMode.getKotlinCollectionsToJavaCollections()) {
                    boolean bl;
                    block12: {
                        Iterable iterable = JavaToKotlinClassMap.INSTANCE.getMutabilityMappings();
                        boolean bl2 = false;
                        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                            bl = false;
                        } else {
                            for (FqNameUnsafe fqNameUnsafe3 : iterable) {
                                JavaToKotlinClassMap.PlatformMutabilityMapping platformMutabilityMapping = (JavaToKotlinClassMap.PlatformMutabilityMapping)((Object)fqNameUnsafe3);
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)platformMutabilityMapping.getJavaClass(), (Object)classId)) continue;
                                bl = true;
                                break block12;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        return null;
                    }
                }
                String string = JvmClassName.internalNameByClassId(classId);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                return jvmTypeFactory.createObjectType(string);
            }
        }
        return null;
    }
}

