/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.text.StringsKt;

public final class ClassId {
    public static final Companion Companion = new Companion(null);
    private final FqName packageFqName;
    private final FqName relativeClassName;
    private final boolean isLocal;

    public ClassId(FqName fqName, FqName fqName2, boolean bl) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"");
        this.packageFqName = fqName;
        this.relativeClassName = fqName2;
        this.isLocal = bl;
        boolean bl3 = bl2 = !this.relativeClassName.isRoot();
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string = "Class name must not be root: " + this.packageFqName + (this.isLocal ? " (local)" : "");
            throw new AssertionError((Object)string);
        }
    }

    public final FqName getPackageFqName() {
        return this.packageFqName;
    }

    public final FqName getRelativeClassName() {
        return this.relativeClassName;
    }

    public final boolean isLocal() {
        return this.isLocal;
    }

    public ClassId(FqName fqName, Name name) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        this(fqName, FqName.Companion.topLevel(name), false);
    }

    public final Name getShortClassName() {
        return this.relativeClassName.shortName();
    }

    public final ClassId getOuterClassId() {
        ClassId classId;
        FqName fqName = this.relativeClassName.parent();
        boolean bl = !fqName.isRoot();
        boolean bl2 = false;
        if (bl) {
            boolean bl3 = false;
            classId = new ClassId(this.packageFqName, fqName, this.isLocal);
        } else {
            classId = null;
        }
        return classId;
    }

    public final boolean isNestedClass() {
        return !this.relativeClassName.parent().isRoot();
    }

    public final ClassId createNestedClassId(Name name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        return new ClassId(this.packageFqName, this.relativeClassName.child(name), this.isLocal);
    }

    public final FqName asSingleFqName() {
        return this.packageFqName.isRoot() ? this.relativeClassName : new FqName(this.packageFqName.asString() + '.' + this.relativeClassName.asString());
    }

    public final String asString() {
        String string;
        if (this.packageFqName.isRoot()) {
            string = ClassId.asString$escapeSlashes(this.relativeClassName);
        } else {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            boolean bl = false;
            stringBuilder2.append(StringsKt.replace$default((String)this.packageFqName.asString(), (char)'.', (char)'/', (boolean)false, (int)4, null));
            stringBuilder2.append("/");
            stringBuilder2.append(ClassId.asString$escapeSlashes(this.relativeClassName));
            string = stringBuilder.toString();
        }
        return string;
    }

    public String toString() {
        return this.packageFqName.isRoot() ? '/' + this.asString() : this.asString();
    }

    public int hashCode() {
        int n = this.packageFqName.hashCode();
        n = n * 31 + this.relativeClassName.hashCode();
        n = n * 31 + Boolean.hashCode(this.isLocal);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ClassId)) {
            return false;
        }
        ClassId classId = (ClassId)object;
        if (!Intrinsics.areEqual((Object)this.packageFqName, (Object)classId.packageFqName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.relativeClassName, (Object)classId.relativeClassName)) {
            return false;
        }
        return this.isLocal == classId.isLocal;
    }

    private static final String asString$escapeSlashes(FqName fqName) {
        String string = fqName.asString();
        if (StringsKt.contains$default((CharSequence)string, (char)'/', (boolean)false, (int)2, null)) {
            return '`' + string + '`';
        }
        return string;
    }

    @JvmStatic
    public static final ClassId topLevel(FqName fqName) {
        return Companion.topLevel(fqName);
    }

    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final ClassId topLevel(FqName fqName) {
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
            return new ClassId(fqName.parent(), fqName.shortName());
        }

        @JvmStatic
        public final ClassId fromString(String string, boolean bl) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            int n = StringsKt.indexOf$default((CharSequence)string, (char)'`', (int)0, (boolean)false, (int)6, null);
            int n2 = StringsKt.lastIndexOf$default((CharSequence)string, (String)"/", (int)(n == -1 ? string.length() : n), (boolean)false, (int)4, null);
            String string2 = null;
            String string3 = null;
            if (n2 == -1) {
                string2 = "";
                string3 = StringsKt.replace$default((String)string, (String)"`", (String)"", (boolean)false, (int)4, null);
            } else {
                String string4 = string.substring(0, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"");
                string2 = StringsKt.replace$default((String)string4, (char)'/', (char)'.', (boolean)false, (int)4, null);
                String string5 = string.substring(n2 + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"");
                string3 = StringsKt.replace$default((String)string5, (String)"`", (String)"", (boolean)false, (int)4, null);
            }
            return new ClassId(new FqName(string2), new FqName(string3), bl);
        }

        public static /* synthetic */ ClassId fromString$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.fromString(string, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

