/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedInputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedOutputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.ExtensionRegistryLite;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.UninitializedMessageException;

public abstract class AbstractMessageLite
implements MessageLite {
    protected int memoizedHashCode = 0;

    public void writeDelimitedTo(OutputStream outputStream) {
        int n = this.getSerializedSize();
        int n2 = CodedOutputStream.computePreferredBufferSize(CodedOutputStream.computeRawVarint32Size(n) + n);
        CodedOutputStream codedOutputStream = CodedOutputStream.newInstance(outputStream, n2);
        codedOutputStream.writeRawVarint32(n);
        this.writeTo(codedOutputStream);
        codedOutputStream.flush();
    }

    UninitializedMessageException newUninitializedMessageException() {
        return new UninitializedMessageException(this);
    }

    public static abstract class Builder<BuilderType extends Builder>
    implements MessageLite.Builder {
        public abstract BuilderType clone();

        public abstract BuilderType mergeFrom(CodedInputStream var1, ExtensionRegistryLite var2);

        protected static UninitializedMessageException newUninitializedMessageException(MessageLite messageLite) {
            return new UninitializedMessageException(messageLite);
        }

        static final class LimitedInputStream
        extends FilterInputStream {
            private int limit;

            LimitedInputStream(InputStream inputStream, int n) {
                super(inputStream);
                this.limit = n;
            }

            @Override
            public int available() {
                return Math.min(super.available(), this.limit);
            }

            @Override
            public int read() {
                if (this.limit <= 0) {
                    return -1;
                }
                int n = super.read();
                if (n >= 0) {
                    --this.limit;
                }
                return n;
            }

            @Override
            public int read(byte[] byArray, int n, int n2) {
                if (this.limit <= 0) {
                    return -1;
                }
                int n3 = super.read(byArray, n, n2 = Math.min(n2, this.limit));
                if (n3 >= 0) {
                    this.limit -= n3;
                }
                return n3;
            }

            @Override
            public long skip(long l) {
                long l2 = super.skip(Math.min(l, (long)this.limit));
                if (l2 >= 0L) {
                    this.limit = (int)((long)this.limit - l2);
                }
                return l2;
            }
        }
    }
}

