/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.UnsignedTypes;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithSource;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertySetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceFile;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

public class DescriptorUtils {
    public static final FqName JVM_NAME = new FqName("kotlin.jvm.JvmName");

    private DescriptorUtils() {
    }

    public static ReceiverParameterDescriptor getDispatchReceiverParameterIfNeeded(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(0);
        }
        if (declarationDescriptor instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
            return classDescriptor.getThisAsReceiverParameter();
        }
        return null;
    }

    public static boolean isLocal(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(1);
        }
        for (DeclarationDescriptor declarationDescriptor2 = declarationDescriptor; declarationDescriptor2 != null; declarationDescriptor2 = declarationDescriptor2.getContainingDeclaration()) {
            if (!DescriptorUtils.isAnonymousObject(declarationDescriptor2) && !DescriptorUtils.isDescriptorWithLocalVisibility(declarationDescriptor2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDescriptorWithLocalVisibility(DeclarationDescriptor declarationDescriptor) {
        return declarationDescriptor instanceof DeclarationDescriptorWithVisibility && ((DeclarationDescriptorWithVisibility)declarationDescriptor).getVisibility() == DescriptorVisibilities.LOCAL;
    }

    public static FqNameUnsafe getFqName(DeclarationDescriptor declarationDescriptor) {
        FqName fqName;
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(2);
        }
        return (fqName = DescriptorUtils.getFqNameSafeIfPossible(declarationDescriptor)) != null ? fqName.toUnsafe() : DescriptorUtils.getFqNameUnsafe(declarationDescriptor);
    }

    public static FqName getFqNameSafe(DeclarationDescriptor declarationDescriptor) {
        FqName fqName;
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(3);
        }
        FqName fqName2 = (fqName = DescriptorUtils.getFqNameSafeIfPossible(declarationDescriptor)) != null ? fqName : DescriptorUtils.getFqNameUnsafe(declarationDescriptor).toSafe();
        if (fqName2 == null) {
            DescriptorUtils.$$$reportNull$$$0(4);
        }
        return fqName2;
    }

    private static FqName getFqNameSafeIfPossible(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(5);
        }
        if (declarationDescriptor instanceof ModuleDescriptor || ErrorUtils.isError(declarationDescriptor)) {
            return FqName.ROOT;
        }
        if (declarationDescriptor instanceof PackageViewDescriptor) {
            return ((PackageViewDescriptor)declarationDescriptor).getFqName();
        }
        if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            return ((PackageFragmentDescriptor)declarationDescriptor).getFqName();
        }
        return null;
    }

    private static FqNameUnsafe getFqNameUnsafe(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(6);
        }
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor.getContainingDeclaration();
        assert (declarationDescriptor2 != null) : "Not package/module descriptor doesn't have containing declaration: " + declarationDescriptor;
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(declarationDescriptor2).child(declarationDescriptor.getName());
        if (fqNameUnsafe == null) {
            DescriptorUtils.$$$reportNull$$$0(7);
        }
        return fqNameUnsafe;
    }

    public static boolean isTopLevelDeclaration(DeclarationDescriptor declarationDescriptor) {
        return declarationDescriptor != null && declarationDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor;
    }

    public static boolean areInSameModule(DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2) {
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(16);
        }
        if (declarationDescriptor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(17);
        }
        return DescriptorUtils.getContainingModule(declarationDescriptor).equals(DescriptorUtils.getContainingModule(declarationDescriptor2));
    }

    public static <D extends DeclarationDescriptor> D getParentOfType(DeclarationDescriptor declarationDescriptor, Class<D> clazz) {
        if (clazz == null) {
            DescriptorUtils.$$$reportNull$$$0(18);
        }
        return DescriptorUtils.getParentOfType(declarationDescriptor, clazz, true);
    }

    public static <D extends DeclarationDescriptor> D getParentOfType(DeclarationDescriptor declarationDescriptor, Class<D> clazz, boolean bl) {
        if (clazz == null) {
            DescriptorUtils.$$$reportNull$$$0(19);
        }
        if (declarationDescriptor == null) {
            return null;
        }
        if (bl) {
            declarationDescriptor = declarationDescriptor.getContainingDeclaration();
        }
        while (declarationDescriptor != null) {
            if (clazz.isInstance(declarationDescriptor)) {
                return (D)declarationDescriptor;
            }
            declarationDescriptor = declarationDescriptor.getContainingDeclaration();
        }
        return null;
    }

    public static ModuleDescriptor getContainingModuleOrNull(KotlinType kotlinType) {
        ClassifierDescriptor classifierDescriptor;
        if (kotlinType == null) {
            DescriptorUtils.$$$reportNull$$$0(20);
        }
        if ((classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor()) == null) {
            return null;
        }
        return DescriptorUtils.getContainingModuleOrNull(classifierDescriptor);
    }

    public static ModuleDescriptor getContainingModule(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(21);
        }
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModuleOrNull(declarationDescriptor);
        assert (moduleDescriptor != null) : "Descriptor without a containing module: " + declarationDescriptor;
        ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
        if (moduleDescriptor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(22);
        }
        return moduleDescriptor2;
    }

    public static ModuleDescriptor getContainingModuleOrNull(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(23);
        }
        while (declarationDescriptor != null) {
            if (declarationDescriptor instanceof ModuleDescriptor) {
                return (ModuleDescriptor)declarationDescriptor;
            }
            if (declarationDescriptor instanceof PackageViewDescriptor) {
                return ((PackageViewDescriptor)declarationDescriptor).getModule();
            }
            declarationDescriptor = declarationDescriptor.getContainingDeclaration();
        }
        return null;
    }

    public static boolean isDirectSubclass(ClassDescriptor classDescriptor, ClassDescriptor classDescriptor2) {
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(26);
        }
        if (classDescriptor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(27);
        }
        for (KotlinType kotlinType : classDescriptor.getTypeConstructor().getSupertypes()) {
            if (!DescriptorUtils.isSameClass(kotlinType, classDescriptor2.getOriginal())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubclass(ClassDescriptor classDescriptor, ClassDescriptor classDescriptor2) {
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(28);
        }
        if (classDescriptor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(29);
        }
        return DescriptorUtils.isSubtypeOfClass(classDescriptor.getDefaultType(), classDescriptor2.getOriginal());
    }

    private static boolean isSameClass(KotlinType kotlinType, DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor declarationDescriptor2;
        ClassifierDescriptor classifierDescriptor;
        if (kotlinType == null) {
            DescriptorUtils.$$$reportNull$$$0(30);
        }
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(31);
        }
        return (classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor()) != null && (declarationDescriptor2 = classifierDescriptor.getOriginal()) instanceof ClassifierDescriptor && declarationDescriptor instanceof ClassifierDescriptor && ((ClassifierDescriptor)declarationDescriptor).getTypeConstructor().equals(((ClassifierDescriptor)declarationDescriptor2).getTypeConstructor());
    }

    public static boolean isSubtypeOfClass(KotlinType kotlinType, DeclarationDescriptor declarationDescriptor) {
        if (kotlinType == null) {
            DescriptorUtils.$$$reportNull$$$0(32);
        }
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(33);
        }
        if (DescriptorUtils.isSameClass(kotlinType, declarationDescriptor)) {
            return true;
        }
        for (KotlinType kotlinType2 : kotlinType.getConstructor().getSupertypes()) {
            if (!DescriptorUtils.isSubtypeOfClass(kotlinType2, declarationDescriptor)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompanionObject(DeclarationDescriptor declarationDescriptor) {
        return DescriptorUtils.isKindOf(declarationDescriptor, ClassKind.OBJECT) && ((ClassDescriptor)declarationDescriptor).isCompanionObject();
    }

    public static boolean isSealedClass(DeclarationDescriptor declarationDescriptor) {
        return (DescriptorUtils.isKindOf(declarationDescriptor, ClassKind.CLASS) || DescriptorUtils.isKindOf(declarationDescriptor, ClassKind.INTERFACE)) && ((ClassDescriptor)declarationDescriptor).getModality() == Modality.SEALED;
    }

    public static boolean isAnonymousObject(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(34);
        }
        return DescriptorUtils.isClass(declarationDescriptor) && declarationDescriptor.getName().equals(SpecialNames.NO_NAME_PROVIDED);
    }

    public static boolean isEnumEntry(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(36);
        }
        return DescriptorUtils.isKindOf(declarationDescriptor, ClassKind.ENUM_ENTRY);
    }

    public static boolean isEnumClass(DeclarationDescriptor declarationDescriptor) {
        return DescriptorUtils.isKindOf(declarationDescriptor, ClassKind.ENUM_CLASS);
    }

    public static boolean isAnnotationClass(DeclarationDescriptor declarationDescriptor) {
        return DescriptorUtils.isKindOf(declarationDescriptor, ClassKind.ANNOTATION_CLASS);
    }

    public static boolean isInterface(DeclarationDescriptor declarationDescriptor) {
        return DescriptorUtils.isKindOf(declarationDescriptor, ClassKind.INTERFACE);
    }

    public static boolean isClass(DeclarationDescriptor declarationDescriptor) {
        return DescriptorUtils.isKindOf(declarationDescriptor, ClassKind.CLASS);
    }

    public static boolean isClassOrEnumClass(DeclarationDescriptor declarationDescriptor) {
        return DescriptorUtils.isClass(declarationDescriptor) || DescriptorUtils.isEnumClass(declarationDescriptor);
    }

    private static boolean isKindOf(DeclarationDescriptor declarationDescriptor, ClassKind classKind) {
        if (classKind == null) {
            DescriptorUtils.$$$reportNull$$$0(37);
        }
        return declarationDescriptor instanceof ClassDescriptor && ((ClassDescriptor)declarationDescriptor).getKind() == classKind;
    }

    public static ClassDescriptor getSuperClassDescriptor(ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(44);
        }
        Collection<KotlinType> collection = classDescriptor.getTypeConstructor().getSupertypes();
        for (KotlinType kotlinType : collection) {
            ClassDescriptor classDescriptor2 = DescriptorUtils.getClassDescriptorForType(kotlinType);
            if (classDescriptor2.getKind() == ClassKind.INTERFACE) continue;
            return classDescriptor2;
        }
        return null;
    }

    public static ClassDescriptor getClassDescriptorForType(KotlinType kotlinType) {
        if (kotlinType == null) {
            DescriptorUtils.$$$reportNull$$$0(45);
        }
        return DescriptorUtils.getClassDescriptorForTypeConstructor(kotlinType.getConstructor());
    }

    public static ClassDescriptor getClassDescriptorForTypeConstructor(TypeConstructor typeConstructor2) {
        if (typeConstructor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(46);
        }
        ClassifierDescriptor classifierDescriptor = typeConstructor2.getDeclarationDescriptor();
        assert (classifierDescriptor instanceof ClassDescriptor) : "Classifier descriptor of a type should be of type ClassDescriptor: " + typeConstructor2;
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(47);
        }
        return classDescriptor;
    }

    public static DescriptorVisibility getDefaultConstructorVisibility(ClassDescriptor classDescriptor, boolean bl) {
        ClassKind classKind;
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(48);
        }
        if ((classKind = classDescriptor.getKind()) == ClassKind.ENUM_CLASS || classKind.isSingleton()) {
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            if (descriptorVisibility == null) {
                DescriptorUtils.$$$reportNull$$$0(49);
            }
            return descriptorVisibility;
        }
        if (DescriptorUtils.isSealedClass(classDescriptor)) {
            if (bl) {
                DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PROTECTED;
                if (descriptorVisibility == null) {
                    DescriptorUtils.$$$reportNull$$$0(50);
                }
                return descriptorVisibility;
            }
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
            if (descriptorVisibility == null) {
                DescriptorUtils.$$$reportNull$$$0(51);
            }
            return descriptorVisibility;
        }
        if (DescriptorUtils.isAnonymousObject(classDescriptor)) {
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.DEFAULT_VISIBILITY;
            if (descriptorVisibility == null) {
                DescriptorUtils.$$$reportNull$$$0(52);
            }
            return descriptorVisibility;
        }
        assert (classKind == ClassKind.CLASS || classKind == ClassKind.INTERFACE || classKind == ClassKind.ANNOTATION_CLASS);
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
        if (descriptorVisibility == null) {
            DescriptorUtils.$$$reportNull$$$0(53);
        }
        return descriptorVisibility;
    }

    public static <D extends CallableMemberDescriptor> D unwrapFakeOverride(D object) {
        if (object == null) {
            DescriptorUtils.$$$reportNull$$$0(59);
        }
        while (object.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            Collection<? extends CallableMemberDescriptor> collection = object.getOverriddenDescriptors();
            if (collection.isEmpty()) {
                throw new IllegalStateException("Fake override should have at least one overridden descriptor: " + object);
            }
            object = collection.iterator().next();
        }
        D d = object;
        if (d == null) {
            DescriptorUtils.$$$reportNull$$$0(60);
        }
        return d;
    }

    public static <D extends DeclarationDescriptorWithVisibility> D unwrapFakeOverrideToAnyDeclaration(D d) {
        if (d == null) {
            DescriptorUtils.$$$reportNull$$$0(64);
        }
        if (d instanceof CallableMemberDescriptor) {
            return (D)DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)d);
        }
        D d2 = d;
        if (d2 == null) {
            DescriptorUtils.$$$reportNull$$$0(65);
        }
        return d2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean shouldRecordInitializerForProperty(VariableDescriptor variableDescriptor, KotlinType kotlinType) {
        if (variableDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(66);
        }
        if (kotlinType == null) {
            DescriptorUtils.$$$reportNull$$$0(67);
        }
        if (variableDescriptor.isVar()) return false;
        if (KotlinTypeKt.isError(kotlinType)) {
            return false;
        }
        if (TypeUtils.acceptsNullable(kotlinType)) {
            return true;
        }
        KotlinBuiltIns kotlinBuiltIns = DescriptorUtilsKt.getBuiltIns(variableDescriptor);
        if (KotlinBuiltIns.isPrimitiveType(kotlinType)) return true;
        if (KotlinTypeChecker.DEFAULT.equalTypes(kotlinBuiltIns.getStringType(), kotlinType)) return true;
        if (KotlinTypeChecker.DEFAULT.equalTypes(kotlinBuiltIns.getNumber().getDefaultType(), kotlinType)) return true;
        if (KotlinTypeChecker.DEFAULT.equalTypes(kotlinBuiltIns.getAnyType(), kotlinType)) return true;
        if (!UnsignedTypes.isUnsignedType(kotlinType)) return false;
        return true;
    }

    public static <D extends CallableDescriptor> Set<D> getAllOverriddenDescriptors(D d) {
        if (d == null) {
            DescriptorUtils.$$$reportNull$$$0(71);
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        DescriptorUtils.collectAllOverriddenDescriptors(d.getOriginal(), linkedHashSet);
        LinkedHashSet linkedHashSet2 = linkedHashSet;
        if (linkedHashSet2 == null) {
            DescriptorUtils.$$$reportNull$$$0(72);
        }
        return linkedHashSet2;
    }

    private static <D extends CallableDescriptor> void collectAllOverriddenDescriptors(D d, Set<D> set) {
        if (d == null) {
            DescriptorUtils.$$$reportNull$$$0(73);
        }
        if (set == null) {
            DescriptorUtils.$$$reportNull$$$0(74);
        }
        if (set.contains(d)) {
            return;
        }
        for (CallableDescriptor callableDescriptor : d.getOriginal().getOverriddenDescriptors()) {
            CallableDescriptor callableDescriptor2 = callableDescriptor.getOriginal();
            DescriptorUtils.collectAllOverriddenDescriptors(callableDescriptor2, set);
            set.add(callableDescriptor2);
        }
    }

    public static SourceFile getContainingSourceFile(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(82);
        }
        if (declarationDescriptor instanceof PropertySetterDescriptor) {
            declarationDescriptor = ((PropertySetterDescriptor)declarationDescriptor).getCorrespondingProperty();
        }
        if (declarationDescriptor instanceof DeclarationDescriptorWithSource) {
            SourceFile sourceFile = ((DeclarationDescriptorWithSource)declarationDescriptor).getSource().getContainingFile();
            if (sourceFile == null) {
                DescriptorUtils.$$$reportNull$$$0(83);
            }
            return sourceFile;
        }
        SourceFile sourceFile = SourceFile.NO_SOURCE_FILE;
        if (sourceFile == null) {
            DescriptorUtils.$$$reportNull$$$0(84);
        }
        return sourceFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 72: 
            case 76: 
            case 83: 
            case 84: 
            case 86: 
            case 89: 
            case 94: 
            case 96: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 72: 
            case 76: 
            case 83: 
            case 84: 
            case 86: 
            case 89: 
            case 94: 
            case 96: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingDeclaration";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 24: 
            case 34: 
            case 35: 
            case 36: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 64: 
            case 82: 
            case 95: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 72: 
            case 76: 
            case 83: 
            case 84: 
            case 86: 
            case 89: 
            case 94: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlin/reflect/jvm/internal/impl/resolve/DescriptorUtils";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinType";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationDescriptor";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClass";
                break;
            }
            case 27: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 30: 
            case 32: 
            case 45: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classKind";
                break;
            }
            case 38: 
            case 39: 
            case 41: 
            case 44: 
            case 48: 
            case 54: 
            case 68: 
            case 69: 
            case 70: 
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeConstructor";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClassName";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberDescriptor";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotated";
                break;
            }
            case 85: 
            case 87: 
            case 90: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 88: 
            case 91: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlin/reflect/jvm/internal/impl/resolve/DescriptorUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqNameSafe";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqNameUnsafe";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqNameFromTopLevelClass";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassIdForNonLocalClass";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingModule";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperclassDescriptors";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassType";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDescriptorForTypeConstructor";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConstructorVisibility";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapFakeOverride";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapSubstitutionOverride";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapFakeOverrideToAnyDeclaration";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOverriddenDescriptors";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOverriddenDeclarations";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingSourceFile";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDescriptors";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionByName";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyByName";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectMember";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDispatchReceiverParameterIfNeeded";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isLocal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFqName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFqNameSafe";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 72: 
            case 76: 
            case 83: 
            case 84: 
            case 86: 
            case 89: 
            case 94: 
            case 96: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFqNameSafeIfPossible";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFqNameUnsafe";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFqNameFromTopLevelClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getClassIdForNonLocalClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isExtension";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isOverride";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isStaticDeclaration";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "areInSameModule";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 20: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getContainingModuleOrNull";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getContainingModule";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClass";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isDirectSubclass";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isSubclass";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isSameClass";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isSubtypeOfClass";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isAnonymousObject";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isAnonymousFunction";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isEnumEntry";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isKindOf";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "hasAbstractMembers";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getSuperclassDescriptors";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassType";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassDescriptor";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getClassDescriptorForType";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getClassDescriptorForTypeConstructor";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConstructorVisibility";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getInnerClassByName";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isStaticNestedClass";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelOrInnerClass";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "unwrapFakeOverride";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "unwrapSubstitutionOverride";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "unwrapFakeOverrideToAnyDeclaration";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "shouldRecordInitializerForProperty";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "classCanHaveAbstractFakeOverride";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "classCanHaveAbstractDeclaration";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "classCanHaveOpenMembers";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getAllOverriddenDescriptors";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "collectAllOverriddenDescriptors";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getAllOverriddenDeclarations";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isSingletonOrAnonymousObject";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "canHaveDeclaredConstructors";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getJvmName";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "findJvmNameAnnotation";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "hasJvmNameAnnotation";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getContainingSourceFile";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getAllDescriptors";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionByName";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionByNameOrNull";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyByName";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getDirectMember";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isMethodOfAny";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 72: 
            case 76: 
            case 83: 
            case 84: 
            case 86: 
            case 89: 
            case 94: 
            case 96: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

