/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.Arrays;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueConstant;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;

public final class CharValue
extends IntegerValueConstant<Character> {
    public CharValue(char c) {
        super(Character.valueOf(c));
    }

    @Override
    public SimpleType getType(ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        SimpleType simpleType = moduleDescriptor.getBuiltIns().getCharType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
        return simpleType;
    }

    @Override
    public String toString() {
        String string = "\\u%04X ('%s')";
        Object[] objectArray = new Object[]{(int)((Character)this.getValue()).charValue(), this.getPrintablePart(((Character)this.getValue()).charValue())};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        return string2;
    }

    private final String getPrintablePart(char c) {
        String string;
        switch (c) {
            case '\b': {
                string = "\\b";
                break;
            }
            case '\t': {
                string = "\\t";
                break;
            }
            case '\n': {
                string = "\\n";
                break;
            }
            case '\f': {
                string = "\\f";
                break;
            }
            case '\r': {
                string = "\\r";
                break;
            }
            default: {
                string = this.isPrintableUnicode(c) ? String.valueOf(c) : "?";
            }
        }
        return string;
    }

    private final boolean isPrintableUnicode(char c) {
        byte by = (byte)Character.getType(c);
        return by != 0 && by != 13 && by != 14 && by != 15 && by != 16 && by != 18 && by != 19;
    }
}

