/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.InlineClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.MultiFieldValueClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt$$Lambda$2;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt$$Lambda$3;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefinerKt;
import kotlin.reflect.jvm.internal.impl.types.checker.Ref;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeRefinementSupport;
import kotlin.reflect.jvm.internal.impl.utils.DFS;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;

public final class DescriptorUtilsKt {
    private static final Name RETENTION_PARAMETER_NAME;

    public static final FqNameUnsafe getFqNameUnsafe(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(declarationDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"");
        return fqNameUnsafe;
    }

    public static final FqName getFqNameSafe(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        FqName fqName = DescriptorUtils.getFqNameSafe(declarationDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"");
        return fqName;
    }

    public static final ModuleDescriptor getModule(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule(declarationDescriptor);
        Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptor, (String)"");
        return moduleDescriptor;
    }

    public static final ClassDescriptor resolveTopLevelClass(ModuleDescriptor moduleDescriptor, FqName fqName, LookupLocation lookupLocation) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        boolean bl2 = bl = !fqName.isRoot();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ClassifierDescriptor classifierDescriptor = moduleDescriptor.getPackage(fqName.parent()).getMemberScope().getContributedClassifier(fqName.shortName(), lookupLocation);
        return classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
    }

    public static final ClassId getClassId(ClassifierDescriptor classifierDescriptor) {
        ClassId classId;
        DeclarationDescriptor declarationDescriptor = classifierDescriptor;
        if (declarationDescriptor != null && (declarationDescriptor = declarationDescriptor.getContainingDeclaration()) != null) {
            DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
            boolean bl = false;
            DeclarationDescriptor declarationDescriptor3 = declarationDescriptor2;
            if (declarationDescriptor3 instanceof PackageFragmentDescriptor) {
                FqName fqName = ((PackageFragmentDescriptor)declarationDescriptor2).getFqName();
                Name name = classifierDescriptor.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                classId = new ClassId(fqName, name);
            } else if (declarationDescriptor3 instanceof ClassifierDescriptorWithTypeParameters) {
                ClassId classId2 = DescriptorUtilsKt.getClassId(declarationDescriptor2);
                if (classId2 != null) {
                    Name name = classifierDescriptor.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                    classId = classId2.createNestedClassId(name);
                } else {
                    classId = null;
                }
            } else {
                classId = null;
            }
        } else {
            classId = null;
        }
        return classId;
    }

    public static final ClassDescriptor getSuperClassNotAny(ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
        for (KotlinType kotlinType : classDescriptor.getDefaultType().getConstructor().getSupertypes()) {
            ClassifierDescriptor classifierDescriptor;
            if (KotlinBuiltIns.isAnyOrNullableAny(kotlinType) || !DescriptorUtils.isClassOrEnumClass(classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor())) continue;
            Intrinsics.checkNotNull((Object)classifierDescriptor);
            return (ClassDescriptor)classifierDescriptor;
        }
        return null;
    }

    public static final KotlinBuiltIns getBuiltIns(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        return DescriptorUtilsKt.getModule(declarationDescriptor).getBuiltIns();
    }

    public static final boolean declaresOrInheritsDefaultValue(ValueParameterDescriptor valueParameterDescriptor) {
        Intrinsics.checkNotNullParameter((Object)valueParameterDescriptor, (String)"");
        Boolean bl = DFS.ifAny(CollectionsKt.listOf((Object)valueParameterDescriptor), DescriptorUtilsKt$$Lambda$0.INSTANCE, declaresOrInheritsDefaultValue.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"");
        return bl;
    }

    public static final Sequence<DeclarationDescriptor> getParentsWithSelf(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        return SequencesKt.generateSequence((Object)declarationDescriptor, (Function1)DescriptorUtilsKt$$Lambda$1.INSTANCE);
    }

    public static final Sequence<DeclarationDescriptor> getParents(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        return SequencesKt.drop(DescriptorUtilsKt.getParentsWithSelf(declarationDescriptor), (int)1);
    }

    public static final CallableMemberDescriptor getPropertyIfAccessor(CallableMemberDescriptor callableMemberDescriptor) {
        CallableMemberDescriptor callableMemberDescriptor2;
        Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
        if (callableMemberDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)callableMemberDescriptor).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"");
            callableMemberDescriptor2 = propertyDescriptor;
        } else {
            callableMemberDescriptor2 = callableMemberDescriptor;
        }
        return callableMemberDescriptor2;
    }

    public static final FqName fqNameOrNull(DeclarationDescriptor declarationDescriptor) {
        FqNameUnsafe fqNameUnsafe;
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        FqNameUnsafe fqNameUnsafe2 = fqNameUnsafe = DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor);
        boolean bl = false;
        FqNameUnsafe fqNameUnsafe3 = fqNameUnsafe2.isSafe() ? fqNameUnsafe : null;
        return fqNameUnsafe3 != null ? fqNameUnsafe3.toSafe() : null;
    }

    public static final CallableMemberDescriptor firstOverridden(CallableMemberDescriptor callableMemberDescriptor, boolean bl, Function1<? super CallableMemberDescriptor, Boolean> function1) {
        Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        boolean bl2 = bl;
        return (CallableMemberDescriptor)DFS.dfs(CollectionsKt.listOf((Object)callableMemberDescriptor), new DescriptorUtilsKt$$Lambda$2(bl2), new DFS.AbstractNodeHandler<CallableMemberDescriptor, CallableMemberDescriptor>((Ref.ObjectRef<CallableMemberDescriptor>)objectRef, function1){
            final /* synthetic */ Ref.ObjectRef<CallableMemberDescriptor> $result;
            final /* synthetic */ Function1<CallableMemberDescriptor, Boolean> $predicate;
            {
                this.$result = objectRef;
                this.$predicate = function1;
            }

            public boolean beforeChildren(CallableMemberDescriptor callableMemberDescriptor) {
                Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
                return this.$result.element == null;
            }

            public void afterChildren(CallableMemberDescriptor callableMemberDescriptor) {
                Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
                if (this.$result.element == null && ((Boolean)this.$predicate.invoke((Object)callableMemberDescriptor)).booleanValue()) {
                    this.$result.element = callableMemberDescriptor;
                }
            }

            public CallableMemberDescriptor result() {
                return (CallableMemberDescriptor)this.$result.element;
            }
        });
    }

    public static /* synthetic */ CallableMemberDescriptor firstOverridden$default(CallableMemberDescriptor callableMemberDescriptor, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return DescriptorUtilsKt.firstOverridden(callableMemberDescriptor, bl, (Function1<? super CallableMemberDescriptor, Boolean>)function1);
    }

    public static final Sequence<CallableMemberDescriptor> overriddenTreeAsSequence(CallableMemberDescriptor callableMemberDescriptor, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
        CallableMemberDescriptor callableMemberDescriptor2 = bl ? callableMemberDescriptor.getOriginal() : callableMemberDescriptor;
        boolean bl2 = false;
        Object[] objectArray = new CallableMemberDescriptor[]{callableMemberDescriptor2};
        Sequence sequence = SequencesKt.sequenceOf((Object[])objectArray);
        Collection<? extends CallableMemberDescriptor> collection = callableMemberDescriptor2.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"");
        boolean bl3 = bl;
        return SequencesKt.plus((Sequence)sequence, (Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)new DescriptorUtilsKt$$Lambda$3(bl3)));
    }

    public static final ClassDescriptor getAnnotationClass(AnnotationDescriptor annotationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)annotationDescriptor, (String)"");
        ClassifierDescriptor classifierDescriptor = annotationDescriptor.getType().getConstructor().getDeclarationDescriptor();
        return classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
    }

    public static final KotlinTypeRefiner getKotlinTypeRefiner(ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        Ref<TypeRefinementSupport> ref = moduleDescriptor.getCapability(KotlinTypeRefinerKt.getREFINER_CAPABILITY());
        TypeRefinementSupport typeRefinementSupport = ref != null ? ref.getValue() : null;
        return typeRefinementSupport instanceof TypeRefinementSupport.Enabled ? ((TypeRefinementSupport.Enabled)typeRefinementSupport).getTypeRefiner() : (KotlinTypeRefiner)KotlinTypeRefiner.Default.INSTANCE;
    }

    public static final boolean isTypeRefinementEnabled(ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        Ref<TypeRefinementSupport> ref = moduleDescriptor.getCapability(KotlinTypeRefinerKt.getREFINER_CAPABILITY());
        return ref != null && (ref = ref.getValue()) != null ? ((TypeRefinementSupport)((Object)ref)).isEnabled() : false;
    }

    public static final InlineClassRepresentation<SimpleType> getInlineClassRepresentation(ClassDescriptor classDescriptor) {
        ClassDescriptor classDescriptor2 = classDescriptor;
        ValueClassRepresentation<SimpleType> valueClassRepresentation = classDescriptor2 != null ? classDescriptor2.getValueClassRepresentation() : null;
        return valueClassRepresentation instanceof InlineClassRepresentation ? (InlineClassRepresentation)valueClassRepresentation : null;
    }

    public static final MultiFieldValueClassRepresentation<SimpleType> getMultiFieldValueClassRepresentation(ClassDescriptor classDescriptor) {
        ClassDescriptor classDescriptor2 = classDescriptor;
        ValueClassRepresentation<SimpleType> valueClassRepresentation = classDescriptor2 != null ? classDescriptor2.getValueClassRepresentation() : null;
        return valueClassRepresentation instanceof MultiFieldValueClassRepresentation ? (MultiFieldValueClassRepresentation)valueClassRepresentation : null;
    }

    private static final Iterable declaresOrInheritsDefaultValue$lambda$5(ValueParameterDescriptor valueParameterDescriptor) {
        Iterable iterable = valueParameterDescriptor.getOverriddenDescriptors();
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            ValueParameterDescriptor valueParameterDescriptor2 = (ValueParameterDescriptor)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(valueParameterDescriptor2.getOriginal());
        }
        return (List)collection;
    }

    private static final DeclarationDescriptor _get_parentsWithSelf_$lambda$8(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        return declarationDescriptor.getContainingDeclaration();
    }

    private static final Iterable firstOverridden$lambda$10(boolean bl, CallableMemberDescriptor callableMemberDescriptor) {
        CallableMemberDescriptor callableMemberDescriptor2;
        Object object;
        CallableMemberDescriptor callableMemberDescriptor3;
        if (bl) {
            CallableMemberDescriptor callableMemberDescriptor4 = callableMemberDescriptor;
            callableMemberDescriptor3 = callableMemberDescriptor4 != null ? callableMemberDescriptor4.getOriginal() : null;
        } else {
            callableMemberDescriptor3 = callableMemberDescriptor;
        }
        return (object = (callableMemberDescriptor2 = callableMemberDescriptor3)) != null && (object = object.getOverriddenDescriptors()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList();
    }

    private static final Sequence overriddenTreeAsSequence$lambda$12$lambda$11(boolean bl, CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkNotNull((Object)callableMemberDescriptor);
        return DescriptorUtilsKt.overriddenTreeAsSequence(callableMemberDescriptor, bl);
    }

    static {
        Name name = Name.identifier("value");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        RETENTION_PARAMETER_NAME = name;
    }

    static /* synthetic */ Iterable accessor$DescriptorUtilsKt$lambda0(ValueParameterDescriptor valueParameterDescriptor) {
        return DescriptorUtilsKt.declaresOrInheritsDefaultValue$lambda$5(valueParameterDescriptor);
    }

    static /* synthetic */ DeclarationDescriptor accessor$DescriptorUtilsKt$lambda1(DeclarationDescriptor declarationDescriptor) {
        return DescriptorUtilsKt._get_parentsWithSelf_$lambda$8(declarationDescriptor);
    }

    static /* synthetic */ Iterable accessor$DescriptorUtilsKt$lambda2(boolean bl, CallableMemberDescriptor callableMemberDescriptor) {
        return DescriptorUtilsKt.firstOverridden$lambda$10(bl, callableMemberDescriptor);
    }

    static /* synthetic */ Sequence accessor$DescriptorUtilsKt$lambda3(boolean bl, CallableMemberDescriptor callableMemberDescriptor) {
        return DescriptorUtilsKt.overriddenTreeAsSequence$lambda$12$lambda$11(bl, callableMemberDescriptor);
    }
}

