/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.jvm;

import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class InlineClassManglingRulesKt {
    public static final boolean shouldHideConstructorDueToValueClassTypeValueParameters(CallableMemberDescriptor callableMemberDescriptor) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
            ClassConstructorDescriptor classConstructorDescriptor = callableMemberDescriptor instanceof ClassConstructorDescriptor ? (ClassConstructorDescriptor)callableMemberDescriptor : null;
            if (classConstructorDescriptor == null) {
                return false;
            }
            ClassConstructorDescriptor classConstructorDescriptor2 = classConstructorDescriptor;
            if (DescriptorVisibilities.isPrivate(classConstructorDescriptor2.getVisibility())) {
                return false;
            }
            ClassDescriptor classDescriptor = classConstructorDescriptor2.getConstructedClass();
            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"");
            if (InlineClassesUtilsKt.isValueClass(classDescriptor)) {
                return false;
            }
            if (DescriptorUtils.isSealedClass(classConstructorDescriptor2.getConstructedClass())) {
                return false;
            }
            List<ValueParameterDescriptor> list = classConstructorDescriptor2.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            Iterable iterable = list;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t : iterable) {
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)t;
                    boolean bl3 = false;
                    KotlinType kotlinType = valueParameterDescriptor.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
                    if (!InlineClassManglingRulesKt.requiresFunctionNameManglingInParameterTypes(kotlinType)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isValueClassThatRequiresMangling(DeclarationDescriptor declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        return InlineClassesUtilsKt.isValueClass(declarationDescriptor) && !InlineClassManglingRulesKt.isDontMangleClass((ClassDescriptor)declarationDescriptor);
    }

    public static final boolean isValueClassThatRequiresMangling(KotlinType kotlinType) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
            boolean bl2 = false;
            bl = InlineClassesUtilsKt.isInlineClass(classifierDescriptor2) && InlineClassManglingRulesKt.isValueClassThatRequiresMangling(classifierDescriptor2) || InlineClassesUtilsKt.needsMfvcFlattening(kotlinType);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean requiresFunctionNameManglingInParameterTypes(KotlinType kotlinType) {
        return InlineClassManglingRulesKt.isValueClassThatRequiresMangling(kotlinType) || InlineClassManglingRulesKt.isTypeParameterWithUpperBoundThatRequiresMangling(kotlinType, true);
    }

    private static final boolean isDontMangleClass(ClassDescriptor classDescriptor) {
        return Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(classDescriptor), (Object)StandardNames.RESULT_FQ_NAME);
    }

    private static final boolean isTypeParameterWithUpperBoundThatRequiresMangling(KotlinType kotlinType, boolean bl) {
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        TypeParameterDescriptor typeParameterDescriptor = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
        if (typeParameterDescriptor == null) {
            return false;
        }
        TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
        return (bl || !InlineClassesUtilsKt.isMultiFieldValueClass(typeParameterDescriptor2)) && InlineClassManglingRulesKt.requiresFunctionNameManglingInParameterTypes(TypeUtilsKt.getRepresentativeUpperBound(typeParameterDescriptor2));
    }
}

