/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProviderOptimized;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AbstractDeserializedPackageFragmentProvider$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragment;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.KotlinMetadataFinder;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNullable;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.utils.CollectionsKt;

public abstract class AbstractDeserializedPackageFragmentProvider
implements PackageFragmentProviderOptimized {
    private final StorageManager storageManager;
    private final KotlinMetadataFinder finder;
    private final ModuleDescriptor moduleDescriptor;
    protected DeserializationComponents components;
    private final MemoizedFunctionToNullable<FqName, PackageFragmentDescriptor> fragments;

    public AbstractDeserializedPackageFragmentProvider(StorageManager storageManager, KotlinMetadataFinder kotlinMetadataFinder, ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"");
        Intrinsics.checkNotNullParameter((Object)kotlinMetadataFinder, (String)"");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        this.storageManager = storageManager;
        this.finder = kotlinMetadataFinder;
        this.moduleDescriptor = moduleDescriptor;
        AbstractDeserializedPackageFragmentProvider abstractDeserializedPackageFragmentProvider = this;
        this.fragments = this.storageManager.createMemoizedFunctionWithNullableValues(new AbstractDeserializedPackageFragmentProvider$$Lambda$0(abstractDeserializedPackageFragmentProvider));
    }

    protected final StorageManager getStorageManager() {
        return this.storageManager;
    }

    protected final KotlinMetadataFinder getFinder() {
        return this.finder;
    }

    protected final ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    protected final DeserializationComponents getComponents() {
        DeserializationComponents deserializationComponents = this.components;
        if (deserializationComponents != null) {
            return deserializationComponents;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"");
        return null;
    }

    protected final void setComponents(DeserializationComponents deserializationComponents) {
        Intrinsics.checkNotNullParameter((Object)deserializationComponents, (String)"");
        this.components = deserializationComponents;
    }

    protected abstract DeserializedPackageFragment findPackage(FqName var1);

    @Override
    public void collectPackageFragments(FqName fqName, Collection<PackageFragmentDescriptor> collection) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter(collection, (String)"");
        CollectionsKt.addIfNotNull(collection, this.fragments.invoke(fqName));
    }

    @Override
    public boolean isEmpty(FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        PackageFragmentDescriptor packageFragmentDescriptor = this.fragments.isComputed(fqName) ? (PackageFragmentDescriptor)this.fragments.invoke(fqName) : (PackageFragmentDescriptor)this.findPackage(fqName);
        return packageFragmentDescriptor == null;
    }

    @Override
    @Deprecated(message="for usages use #packageFragments(FqName) at final point, for impl use #collectPackageFragments(FqName, MutableCollection<PackageFragmentDescriptor>)")
    public List<PackageFragmentDescriptor> getPackageFragments(FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        return kotlin.collections.CollectionsKt.listOfNotNull((Object)this.fragments.invoke(fqName));
    }

    @Override
    public Collection<FqName> getSubPackagesOf(FqName fqName, Function1<? super Name, Boolean> function1) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        Intrinsics.checkNotNullParameter(function1, (String)"");
        return SetsKt.emptySet();
    }

    private static final PackageFragmentDescriptor fragments$lambda$1(AbstractDeserializedPackageFragmentProvider abstractDeserializedPackageFragmentProvider, FqName fqName) {
        DeserializedPackageFragment deserializedPackageFragment;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        DeserializedPackageFragment deserializedPackageFragment2 = abstractDeserializedPackageFragmentProvider.findPackage(fqName);
        if (deserializedPackageFragment2 != null) {
            DeserializedPackageFragment deserializedPackageFragment3;
            DeserializedPackageFragment deserializedPackageFragment4 = deserializedPackageFragment3 = deserializedPackageFragment2;
            boolean bl = false;
            deserializedPackageFragment4.initialize(abstractDeserializedPackageFragmentProvider.getComponents());
            deserializedPackageFragment = deserializedPackageFragment3;
        } else {
            deserializedPackageFragment = null;
        }
        return deserializedPackageFragment;
    }

    static /* synthetic */ PackageFragmentDescriptor accessor$AbstractDeserializedPackageFragmentProvider$lambda0(AbstractDeserializedPackageFragmentProvider abstractDeserializedPackageFragmentProvider, FqName fqName) {
        return AbstractDeserializedPackageFragmentProvider.fragments$lambda$1(abstractDeserializedPackageFragmentProvider, fqName);
    }
}

