/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.BooleanValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.CharValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValueFactory;
import kotlin.reflect.jvm.internal.impl.resolve.constants.DoubleValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.FloatValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.LongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ShortValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UByteValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UIntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ULongValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UShortValue;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

public final class AnnotationDeserializer {
    private final ModuleDescriptor module;
    private final NotFoundClasses notFoundClasses;

    public AnnotationDeserializer(ModuleDescriptor moduleDescriptor, NotFoundClasses notFoundClasses) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)notFoundClasses, (String)"");
        this.module = moduleDescriptor;
        this.notFoundClasses = notFoundClasses;
    }

    private final KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    public final AnnotationDescriptor deserializeAnnotation(ProtoBuf.Annotation annotation, NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        ClassDescriptor classDescriptor = this.resolveClass(NameResolverUtilKt.getClassId(nameResolver, annotation.getId()));
        Map map = MapsKt.emptyMap();
        if (annotation.getArgumentCount() != 0 && !ErrorUtils.isError(classDescriptor) && DescriptorUtils.isAnnotationClass(classDescriptor)) {
            Collection<ClassConstructorDescriptor> collection = classDescriptor.getConstructors();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"");
            ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (classConstructorDescriptor != null) {
                ValueParameterDescriptor valueParameterDescriptor;
                Object object2;
                List<ValueParameterDescriptor> list = classConstructorDescriptor.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"");
                Iterable iterable = list;
                boolean bl = false;
                int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10)), (int)16);
                Iterable iterable2 = iterable;
                Map map2 = new LinkedHashMap(n);
                boolean bl2 = false;
                for (Object object2 : iterable2) {
                    valueParameterDescriptor = (ValueParameterDescriptor)object2;
                    Map map3 = map2;
                    boolean bl3 = false;
                    map3.put(valueParameterDescriptor.getName(), object2);
                }
                Map map4 = map2;
                List<ProtoBuf.Annotation.Argument> list2 = annotation.getArgumentList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"");
                iterable = list2;
                bl = false;
                Iterable iterable3 = iterable;
                iterable2 = new ArrayList();
                boolean bl4 = false;
                Iterable iterable4 = iterable3;
                boolean bl5 = false;
                object2 = iterable4.iterator();
                while (object2.hasNext()) {
                    Pair<Name, ConstantValue<?>> pair;
                    ValueParameterDescriptor valueParameterDescriptor2 = valueParameterDescriptor = object2.next();
                    boolean bl6 = false;
                    ProtoBuf.Annotation.Argument argument = (ProtoBuf.Annotation.Argument)((Object)valueParameterDescriptor2);
                    boolean bl7 = false;
                    Intrinsics.checkNotNull((Object)argument);
                    if (this.resolveArgument(argument, map4, nameResolver) == null) continue;
                    boolean bl8 = false;
                    iterable2.add(pair);
                }
                map = MapsKt.toMap((Iterable)((List)iterable2));
            }
        }
        return new AnnotationDescriptorImpl(classDescriptor.getDefaultType(), map, SourceElement.NO_SOURCE);
    }

    private final Pair<Name, ConstantValue<?>> resolveArgument(ProtoBuf.Annotation.Argument argument, Map<Name, ? extends ValueParameterDescriptor> map, NameResolver nameResolver) {
        ValueParameterDescriptor valueParameterDescriptor = map.get(NameResolverUtilKt.getName(nameResolver, argument.getNameId()));
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor valueParameterDescriptor2 = valueParameterDescriptor;
        Name name = NameResolverUtilKt.getName(nameResolver, argument.getNameId());
        KotlinType kotlinType = valueParameterDescriptor2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
        ProtoBuf.Annotation.Argument.Value value = argument.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"");
        return new Pair((Object)name, this.resolveValueAndCheckExpectedType(kotlinType, value, nameResolver));
    }

    private final ConstantValue<?> resolveValueAndCheckExpectedType(KotlinType kotlinType, ProtoBuf.Annotation.Argument.Value value, NameResolver nameResolver) {
        ConstantValue constantValue;
        ConstantValue constantValue2 = constantValue = this.resolveValue(kotlinType, value, nameResolver);
        boolean bl = false;
        ConstantValue constantValue3 = this.doesValueConformToExpectedType(constantValue2, kotlinType, value) ? constantValue : null;
        if (constantValue3 == null) {
            constantValue3 = ErrorValue.Companion.create("Unexpected argument value: actual type " + value.getType() + " != expected type " + kotlinType);
        }
        return constantValue3;
    }

    public final ConstantValue<?> resolveValue(KotlinType kotlinType, ProtoBuf.Annotation.Argument.Value value, NameResolver nameResolver) {
        ConstantValue constantValue;
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        Intrinsics.checkNotNullParameter((Object)value, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        Boolean bl = Flags.IS_UNSIGNED.get(value.getFlags());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"");
        boolean bl2 = bl;
        ProtoBuf.Annotation.Argument.Value.Type type = value.getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                ConstantValue constantValue2;
                AnnotationDeserializer annotationDeserializer = this;
                byte by = (byte)value.getIntValue();
                boolean bl3 = false;
                if (bl2) {
                    byte by2 = by;
                    boolean bl4 = false;
                    constantValue2 = new UByteValue(by2);
                } else {
                    byte by3 = by;
                    boolean bl5 = false;
                    constantValue2 = new ByteValue(by3);
                }
                constantValue = constantValue2;
                break;
            }
            case 2: {
                constantValue = new CharValue((char)value.getIntValue());
                break;
            }
            case 3: {
                ConstantValue constantValue3;
                AnnotationDeserializer annotationDeserializer = this;
                short s = (short)value.getIntValue();
                boolean bl6 = false;
                if (bl2) {
                    short s2 = s;
                    boolean bl7 = false;
                    constantValue3 = new UShortValue(s2);
                } else {
                    short s3 = s;
                    boolean bl8 = false;
                    constantValue3 = new ShortValue(s3);
                }
                constantValue = constantValue3;
                break;
            }
            case 4: {
                ConstantValue constantValue4;
                AnnotationDeserializer annotationDeserializer = this;
                int n = (int)value.getIntValue();
                boolean bl9 = false;
                if (bl2) {
                    int n2 = n;
                    boolean bl10 = false;
                    constantValue4 = new UIntValue(n2);
                } else {
                    int n3 = n;
                    boolean bl11 = false;
                    constantValue4 = new IntValue(n3);
                }
                constantValue = constantValue4;
                break;
            }
            case 5: {
                ConstantValue constantValue5;
                AnnotationDeserializer annotationDeserializer = this;
                long l = value.getIntValue();
                boolean bl12 = false;
                if (bl2) {
                    long l2 = l;
                    boolean bl13 = false;
                    constantValue5 = new ULongValue(l2);
                } else {
                    long l3 = l;
                    boolean bl14 = false;
                    constantValue5 = new LongValue(l3);
                }
                constantValue = constantValue5;
                break;
            }
            case 6: {
                constantValue = new FloatValue(value.getFloatValue());
                break;
            }
            case 7: {
                constantValue = new DoubleValue(value.getDoubleValue());
                break;
            }
            case 8: {
                constantValue = new BooleanValue(value.getIntValue() != 0L);
                break;
            }
            case 9: {
                constantValue = new StringValue(nameResolver.getString(value.getStringValue()));
                break;
            }
            case 10: {
                constantValue = new KClassValue(NameResolverUtilKt.getClassId(nameResolver, value.getClassId()), value.getArrayDimensionCount());
                break;
            }
            case 11: {
                constantValue = new EnumValue(NameResolverUtilKt.getClassId(nameResolver, value.getClassId()), NameResolverUtilKt.getName(nameResolver, value.getEnumValueId()));
                break;
            }
            case 12: {
                ProtoBuf.Annotation annotation = value.getAnnotation();
                Intrinsics.checkNotNullExpressionValue((Object)annotation, (String)"");
                constantValue = new AnnotationValue(this.deserializeAnnotation(annotation, nameResolver));
                break;
            }
            case 13: {
                List<ProtoBuf.Annotation.Argument.Value> list = value.getArrayElementList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"");
                Iterable iterable = list;
                ConstantValueFactory constantValueFactory = ConstantValueFactory.INSTANCE;
                boolean bl15 = false;
                Iterable iterable2 = iterable;
                Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                boolean bl16 = false;
                for (Object t : iterable2) {
                    ProtoBuf.Annotation.Argument.Value value2 = (ProtoBuf.Annotation.Argument.Value)t;
                    Collection collection2 = collection;
                    boolean bl17 = false;
                    SimpleType simpleType = this.getBuiltIns().getAnyType();
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
                    KotlinType kotlinType2 = simpleType;
                    Intrinsics.checkNotNull((Object)value2);
                    collection2.add(this.resolveValue(kotlinType2, value2, nameResolver));
                }
                constantValue = constantValueFactory.createArrayValue((List)collection, kotlinType);
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported annotation argument type: " + value.getType() + " (expected " + kotlinType + ')').toString());
            }
        }
        return constantValue;
    }

    private final boolean doesValueConformToExpectedType(ConstantValue<?> constantValue, KotlinType kotlinType, ProtoBuf.Annotation.Argument.Value value) {
        boolean bl;
        ProtoBuf.Annotation.Argument.Value.Type type = value.getType();
        block0 : switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 10: {
                ClassDescriptor classDescriptor;
                ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
                ClassDescriptor classDescriptor2 = classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                if (classDescriptor == null || KotlinBuiltIns.isKClass(classDescriptor)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 13: {
                if (!(constantValue instanceof ArrayValue && ((List)((ArrayValue)constantValue).getValue()).size() == value.getArrayElementList().size())) {
                    boolean bl2 = false;
                    String string = "Deserialized ArrayValue should have the same number of elements as the original array value: " + constantValue;
                    throw new IllegalStateException(string.toString());
                }
                KotlinType kotlinType2 = this.getBuiltIns().getArrayElementTypeOrNull(kotlinType);
                if (kotlinType2 == null) {
                    return false;
                }
                KotlinType kotlinType3 = kotlinType2;
                Iterable iterable = (Iterable)CollectionsKt.getIndices((Collection)((Collection)((ArrayValue)constantValue).getValue()));
                boolean bl3 = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    bl = true;
                    break;
                }
                Iterator iterator2 = iterable.iterator();
                while (iterator2.hasNext()) {
                    int n;
                    int n2 = n = ((IntIterator)iterator2).nextInt();
                    boolean bl4 = false;
                    ConstantValue constantValue2 = (ConstantValue)((List)((ArrayValue)constantValue).getValue()).get(n2);
                    ProtoBuf.Annotation.Argument.Value value2 = value.getArrayElement(n2);
                    Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"");
                    if (this.doesValueConformToExpectedType(constantValue2, kotlinType3, value2)) continue;
                    bl = false;
                    break block0;
                }
                bl = true;
                break;
            }
            default: {
                bl = Intrinsics.areEqual((Object)constantValue.getType(this.module), (Object)kotlinType);
            }
        }
        return bl;
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies(this.module, classId, this.notFoundClasses);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoBuf.Annotation.Argument.Value.Type.values().length];
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.CHAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.SHORT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.INT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.LONG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.DOUBLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.BOOLEAN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.STRING.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.CLASS.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.ENUM.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.ANNOTATION.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.Annotation.Argument.Value.Type.ARRAY.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

